/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.bazel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.bazel.PluginConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Workspace {
    private static final String PLUGIN_CONFIG_PATH = "dart/config/ide/flutter.json";
    public static final String BAZEL_URI_SCHEME = "google3://";
    @NotNull
    private final VirtualFile root;
    @Nullable
    private final PluginConfig config;
    @Nullable
    private final String daemonScript;
    @Nullable
    private final String devToolsScript;
    @Nullable
    private final String doctorScript;
    @Nullable
    private final String testScript;
    @Nullable
    private final String runScript;
    @Nullable
    private final String syncScript;
    @Nullable
    private final String toolsScript;
    @Nullable
    private final String sdkHome;
    @Nullable
    private final String requiredIJPluginID;
    @Nullable
    private final String requiredIJPluginMessage;
    @Nullable
    private final String configWarningPrefix;
    @Nullable
    private final String updatedIosRunMessage;
    private static final Logger LOG = Logger.getInstance(Workspace.class);

    private Workspace(@NotNull VirtualFile root, @Nullable PluginConfig config, @Nullable String daemonScript, @Nullable String devToolsScript, @Nullable String doctorScript, @Nullable String testScript, @Nullable String runScript, @Nullable String syncScript, @Nullable String toolsScript, @Nullable String sdkHome, @Nullable String requiredIJPluginID, @Nullable String requiredIJPluginMessage, @Nullable String configWarningPrefix, @Nullable String updatedIosRunMessage) {
        if (root == null) {
            Workspace.$$$reportNull$$$0(0);
        }
        this.root = root;
        this.config = config;
        this.daemonScript = daemonScript;
        this.devToolsScript = devToolsScript;
        this.doctorScript = doctorScript;
        this.testScript = testScript;
        this.runScript = runScript;
        this.syncScript = syncScript;
        this.toolsScript = toolsScript;
        this.sdkHome = sdkHome;
        this.requiredIJPluginID = requiredIJPluginID;
        this.requiredIJPluginMessage = requiredIJPluginMessage;
        this.configWarningPrefix = configWarningPrefix;
        this.updatedIosRunMessage = updatedIosRunMessage;
    }

    @NotNull
    public ImmutableSet<String> getContentPaths(@NotNull Module module) {
        if (module == null) {
            Workspace.$$$reportNull$$$0(1);
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (VirtualFile root : contentRoots) {
            String path = this.getRelativePath(root);
            if (path == null) continue;
            result.add((Object)path);
        }
        ImmutableSet immutableSet = result.build();
        if (immutableSet == null) {
            Workspace.$$$reportNull$$$0(2);
        }
        return immutableSet;
    }

    @Nullable
    public String getRelativePath(@Nullable VirtualFile file) {
        ArrayList<String> path = new ArrayList<String>();
        while (file != null) {
            if (file.equals(this.root)) {
                if (path.isEmpty()) {
                    return null;
                }
                Collections.reverse(path);
                return Joiner.on((char)'/').join(path);
            }
            path.add(file.getName());
            file = file.getParent();
        }
        return null;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.root;
        if (virtualFile == null) {
            Workspace.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Nullable
    public String getDaemonScript() {
        return this.daemonScript;
    }

    @Nullable
    public String getDevToolsScript() {
        return this.devToolsScript;
    }

    @Nullable
    public String getDoctorScript() {
        return this.doctorScript;
    }

    @Nullable
    public String getTestScript() {
        return this.testScript;
    }

    @Nullable
    public String getRunScript() {
        return this.runScript;
    }

    @Nullable
    public String getSyncScript() {
        return this.syncScript;
    }

    @Nullable
    public String getToolsScript() {
        return this.toolsScript;
    }

    @Nullable
    public String getSdkHome() {
        return this.sdkHome;
    }

    @Nullable
    public String getRequiredIJPluginID() {
        return this.requiredIJPluginID;
    }

    @Nullable
    public String getRequiredIJPluginMessage() {
        return this.requiredIJPluginMessage;
    }

    @Nullable
    public String getConfigWarningPrefix() {
        return this.configWarningPrefix;
    }

    @Nullable
    public String getUpdatedIosRunMessage() {
        return this.updatedIosRunMessage;
    }

    public boolean hasPluginConfig() {
        return this.config != null;
    }

    @NotNull
    public Set<String> getDependencies() {
        ImmutableSet immutableSet = ImmutableSet.of((Object)"WORKSPACE", (Object)PLUGIN_CONFIG_PATH);
        if (immutableSet == null) {
            Workspace.$$$reportNull$$$0(4);
        }
        return immutableSet;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Workspace)) {
            return false;
        }
        Workspace other = (Workspace)obj;
        return Objects.equal((Object)this.root, (Object)other.root) && Objects.equal((Object)this.config, (Object)other.config);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.root, this.config});
    }

    @Nullable
    static Workspace loadUncached(@NotNull Project project) {
        if (project == null) {
            Workspace.$$$reportNull$$$0(5);
        }
        if (project.isDisposed()) {
            return null;
        }
        VirtualFile workspaceFile = Workspace.findWorkspaceFile(project);
        if (workspaceFile == null) {
            return null;
        }
        VirtualFile root = workspaceFile.getParent();
        String readonlyPath = "../READONLY/" + root.getName();
        VirtualFile readonlyRoot = root.findFileByRelativePath(readonlyPath);
        VirtualFile configFile = root.findFileByRelativePath(PLUGIN_CONFIG_PATH);
        if (configFile == null && readonlyRoot != null) {
            configFile = readonlyRoot.findFileByRelativePath(PLUGIN_CONFIG_PATH);
        }
        if (configFile == null) {
            return null;
        }
        PluginConfig config = PluginConfig.load(configFile);
        String daemonScript = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getDaemonScript());
        String devToolsScript = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getDevToolsScript());
        String doctorScript = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getDoctorScript());
        String testScript = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getTestScript());
        String runScript = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getRunScript());
        String syncScript = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getSyncScript());
        String toolsScript = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getToolsScript());
        String sdkHome = config == null ? null : Workspace.getScriptFromPath(root, readonlyPath, config.getSdkHome());
        String requiredIJPluginID = config == null ? null : config.getRequiredIJPluginID();
        String requiredIJPluginMessage = config == null ? null : config.getRequiredIJPluginMessage();
        String configWarningPrefix = config == null ? null : config.getConfigWarningPrefix();
        String updatedIosRunMessage = config == null ? null : config.getUpdatedIosRunMessage();
        return new Workspace(root, config, daemonScript, devToolsScript, doctorScript, testScript, runScript, syncScript, toolsScript, sdkHome, requiredIJPluginID, requiredIJPluginMessage, configWarningPrefix, updatedIosRunMessage);
    }

    @VisibleForTesting
    public static Workspace forTest(VirtualFile workspaceRoot, PluginConfig pluginConfig) {
        return new Workspace(workspaceRoot, pluginConfig, pluginConfig.getDaemonScript(), pluginConfig.getDevToolsScript(), pluginConfig.getDoctorScript(), pluginConfig.getTestScript(), pluginConfig.getRunScript(), pluginConfig.getSyncScript(), pluginConfig.getToolsScript(), pluginConfig.getSdkHome(), pluginConfig.getRequiredIJPluginID(), pluginConfig.getRequiredIJPluginMessage(), pluginConfig.getConfigWarningPrefix(), pluginConfig.getUpdatedIosRunMessage());
    }

    private static String getScriptFromPath(@NotNull VirtualFile root, @NotNull String readonlyPath, @Nullable String relativeScriptPath) {
        if (root == null) {
            Workspace.$$$reportNull$$$0(6);
        }
        if (readonlyPath == null) {
            Workspace.$$$reportNull$$$0(7);
        }
        if (relativeScriptPath == null) {
            return null;
        }
        String readonlyScriptPath = readonlyPath + "/" + relativeScriptPath;
        if (root.findFileByRelativePath(relativeScriptPath) != null) {
            return relativeScriptPath;
        }
        if (root.findFileByRelativePath(readonlyScriptPath) != null) {
            return readonlyScriptPath;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findWorkspaceFile(@NotNull Project p) {
        if (p == null) {
            Workspace.$$$reportNull$$$0(8);
        }
        Computable readAction = () -> {
            HashMap<String, VirtualFile> candidates = new HashMap<String, VirtualFile>();
            for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)p).getContentRoots()) {
                VirtualFile wf = Workspace.findContainingWorkspaceFile(contentRoot);
                if (wf == null) continue;
                candidates.put(wf.getPath(), wf);
            }
            if (candidates.size() == 1) {
                return (VirtualFile)candidates.values().iterator().next();
            }
            return null;
        };
        return (VirtualFile)ApplicationManager.getApplication().runReadAction(readAction);
    }

    @Nullable
    private static VirtualFile findContainingWorkspaceFile(@NotNull VirtualFile dir) {
        if (dir == null) {
            Workspace.$$$reportNull$$$0(9);
        }
        while (dir != null) {
            try {
                VirtualFile child = dir.findChild("WORKSPACE");
                if (child != null && child.exists() && !child.isDirectory()) {
                    return child;
                }
                dir = dir.getParent();
            }
            catch (InvalidVirtualFileAccessException ex) {
                return null;
            }
        }
        return null;
    }

    public String convertPath(String path) {
        if (path.startsWith(BAZEL_URI_SCHEME)) {
            return this.getRoot().getPath() + path.substring(BAZEL_URI_SCHEME.length());
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/bazel/Workspace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readonlyPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/bazel/Workspace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContentPaths";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadUncached";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScriptFromPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findWorkspaceFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findContainingWorkspaceFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

