/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.bazel;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import io.flutter.FlutterUtils;
import io.flutter.bazel.Workspace;
import io.flutter.project.ProjectWatch;
import io.flutter.utils.FileWatch;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkspaceCache {
    @NotNull
    private final Project project;
    @Nullable
    private Workspace cache;
    private boolean disconnected;
    private boolean refreshScheduled;
    private final Set<Runnable> subscribers;
    private static final String dartProjectsWithoutPubspecRegistryKey = "dart.projects.without.pubspec";
    private static final Logger LOG = Logger.getInstance(WorkspaceCache.class);

    private WorkspaceCache(@NotNull Project project) {
        if (project == null) {
            WorkspaceCache.$$$reportNull$$$0(0);
        }
        this.disconnected = false;
        this.refreshScheduled = false;
        this.subscribers = new LinkedHashSet<Runnable>();
        this.project = project;
        AtomicReference fileWatch = new AtomicReference();
        this.subscribe(() -> {
            FileWatch prevWatch;
            if (project.isDisposed()) {
                return;
            }
            Workspace next = this.cache;
            FileWatch nextWatch = null;
            if (next != null) {
                nextWatch = FileWatch.subscribe(next.getRoot(), next.getDependencies(), this::scheduleRefresh);
                nextWatch.setDisposeParent((Disposable)project);
            }
            if ((prevWatch = (FileWatch)fileWatch.getAndSet(nextWatch)) != null) {
                prevWatch.unsubscribe();
            }
        });
        ProjectWatch.subscribe(project, this::scheduleRefresh);
        this.refresh();
    }

    private void scheduleRefresh() {
        if (this.refreshScheduled) {
            return;
        }
        this.refreshScheduled = true;
        SwingUtilities.invokeLater(() -> {
            this.refreshScheduled = false;
            if (this.project.isDisposed()) {
                return;
            }
            this.refresh();
        });
    }

    @NotNull
    public static WorkspaceCache getInstance(@NotNull Project project) {
        if (project == null) {
            WorkspaceCache.$$$reportNull$$$0(1);
        }
        WorkspaceCache workspaceCache = Objects.requireNonNull((WorkspaceCache)project.getService(WorkspaceCache.class));
        if (workspaceCache == null) {
            WorkspaceCache.$$$reportNull$$$0(2);
        }
        return workspaceCache;
    }

    @Nullable
    public Workspace get() {
        return this.cache;
    }

    public boolean isBazel() {
        return this.cache != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Runnable callback) {
        Set<Runnable> set = this.subscribers;
        synchronized (set) {
            this.subscribers.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(Runnable callback) {
        Set<Runnable> set = this.subscribers;
        synchronized (set) {
            this.subscribers.remove(callback);
        }
    }

    private void refresh() {
        Workspace workspace = Workspace.loadUncached(this.project);
        if (workspace == this.cache && !this.disconnected) {
            return;
        }
        if (this.cache != null && workspace == null) {
            this.disconnected = true;
            return;
        }
        this.disconnected = false;
        this.cache = workspace;
        if (this.cache != null && !Registry.is((String)dartProjectsWithoutPubspecRegistryKey, (boolean)false)) {
            Registry.get((String)dartProjectsWithoutPubspecRegistryKey).setValue(true);
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Runnable> getSubscribers() {
        Set<Runnable> set = this.subscribers;
        synchronized (set) {
            return ImmutableSet.copyOf(this.subscribers);
        }
    }

    private void notifyListeners() {
        if (this.project.isDisposed()) {
            return;
        }
        for (Runnable sub : this.getSubscribers()) {
            try {
                sub.run();
            }
            catch (Exception e) {
                if (com.google.common.base.Objects.equal((Object)e.getMessage(), (Object)"expected failure in test")) continue;
                FlutterUtils.warn(LOG, "A subscriber to a WorkspaceCache threw an exception", e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/bazel/WorkspaceCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/bazel/WorkspaceCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

