/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.console;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.sdk.FlutterSdk;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterConsoleFilter
implements Filter {
    @NotNull
    private final Module module;

    public FlutterConsoleFilter(@NotNull Module module) {
        if (module == null) {
            FlutterConsoleFilter.$$$reportNull$$$0(0);
        }
        this.module = module;
    }

    @VisibleForTesting
    @Nullable
    public VirtualFile fileAtPath(@NotNull String pathPart) {
        VirtualFile[] roots;
        if (pathPart == null) {
            FlutterConsoleFilter.$$$reportNull$$$0(1);
        }
        if ((pathPart = pathPart.split(":")[0]).indexOf(46) == -1) {
            return null;
        }
        for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)this.module).getContentRoots()) {
            if (pathPart.isEmpty()) continue;
            String baseDirPath = root.getPath();
            String path = baseDirPath + "/" + pathPart;
            VirtualFile file = FlutterConsoleFilter.findFile(path);
            if (file == null) {
                String exampleDirRelativePath = baseDirPath + "/example/" + pathPart;
                file = FlutterConsoleFilter.findFile(exampleDirRelativePath);
            }
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private static VirtualFile findFile(String path) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        return file != null && file.exists() ? file : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        String[] parts;
        if (line.startsWith("Run \"flutter doctor\" for information about installing additional components.")) {
            return FlutterConsoleFilter.getFlutterDoctorResult(line, entireLength - line.length());
        }
        if (line.startsWith("Lost connection to device")) {
            TextAttributes attr = new TextAttributes(UIUtil.getErrorForeground(), null, null, EffectType.BOXED, 0);
            return new Filter.Result(entireLength - line.length(), entireLength, null, attr);
        }
        int lineNumber = 0;
        String pathPart = line.trim();
        VirtualFile file = null;
        int lineStart = -1;
        int highlightLength = 0;
        if ((pathPart.startsWith("Launching ") || pathPart.startsWith("open ")) && (parts = pathPart.split(" ")).length > 1 && (file = this.fileAtPath(pathPart = parts[1])) != null) {
            lineStart = entireLength - line.length() + line.indexOf(pathPart);
            highlightLength = pathPart.length();
        }
        for (String part : parts = pathPart.split(" ")) {
            if (!part.startsWith("(") || !part.endsWith(")")) continue;
            String[] split = (part = part.substring(1, part.length() - 1)).split(":");
            if (split.length == 2) {
                try {
                    lineNumber = Math.max(0, Integer.parseInt(split[1]) - 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                pathPart = part;
                lineStart = entireLength - line.length() + line.indexOf(pathPart);
                highlightLength = pathPart.length();
                break;
            }
            if (split.length != 4 || !split[0].equals("file")) continue;
            try {
                lineNumber = Math.max(0, Integer.parseInt(split[2]) - 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            pathPart = this.findRelativePath(split[1]);
            if (pathPart == null) {
                return null;
            }
            lineStart = entireLength - line.length() + line.indexOf(part);
            highlightLength = part.length();
            break;
        }
        if (lineStart < 0) {
            String filePathAndLineNumberExpr = "(^.*?):(\\d+?):\\d+?:\\s*?Error";
            Pattern pattern = Pattern.compile("(^.*?):(\\d+?):\\d+?:\\s*?Error");
            Matcher matcher = pattern.matcher(line);
            boolean found = matcher.find();
            if (!found) return null;
            String filePathExpr = "((?:[^/]*/)*)(.*)";
            Pattern pathPattern = Pattern.compile("((?:[^/]*/)*)(.*)");
            Matcher pathMatcher = pathPattern.matcher(matcher.group(1));
            if (!pathMatcher.find()) return null;
            String path = pathMatcher.group(1) + pathMatcher.group(2);
            file = this.fileAtPath(path);
            if (file == null) {
                return null;
            }
            lineNumber = Integer.parseInt(matcher.group(2));
            lineStart = entireLength - line.length();
            highlightLength = path.length();
        }
        if (file == null) {
            file = this.fileAtPath(pathPart);
        }
        if (file == null) return null;
        boolean openAsExternalFile = FlutterUtils.isXcodeFileName(pathPart);
        OpenExternalFileHyperlink hyperlinkInfo = openAsExternalFile ? new OpenExternalFileHyperlink(file) : new OpenFileHyperlinkInfo(this.module.getProject(), file, lineNumber, 0);
        return new Filter.Result(lineStart, lineStart + highlightLength, (HyperlinkInfo)hyperlinkInfo);
    }

    private String findRelativePath(String threeSlashFileName) {
        VirtualFile[] roots;
        for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)this.module).getContentRoots()) {
            String path = root.getPath();
            int index = threeSlashFileName.indexOf(path);
            if (index <= 0) continue;
            return threeSlashFileName.substring((index += path.length()) + 1);
        }
        return null;
    }

    private static Filter.Result getFlutterDoctorResult(String line, int lineStart) {
        int commandStart = line.indexOf(34) + 1;
        int startOffset = lineStart + commandStart;
        int commandLength = "flutter doctor".length();
        return new Filter.Result(startOffset, startOffset + commandLength, (HyperlinkInfo)new FlutterDoctorHyperlinkInfo());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPart";
                break;
            }
        }
        objectArray2[1] = "io/flutter/console/FlutterConsoleFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fileAtPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class OpenExternalFileHyperlink
    implements HyperlinkInfo {
        private final String myPath;

        OpenExternalFileHyperlink(VirtualFile file) {
            this.myPath = file.getPath();
        }

        public void navigate(final @NotNull Project project) {
            if (project == null) {
                OpenExternalFileHyperlink.$$$reportNull$$$0(0);
            }
            try {
                GeneralCommandLine cmd = new GeneralCommandLine().withExePath("open").withParameters(new String[]{this.myPath});
                ColoredProcessHandler handler = new ColoredProcessHandler(cmd);
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (event.getExitCode() != 0) {
                            FlutterMessages.showError("Error Opening ", myPath, project);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/console/FlutterConsoleFilter$OpenExternalFileHyperlink$1", "processTerminated"));
                    }
                });
                handler.startNotify();
            }
            catch (ExecutionException e) {
                FlutterMessages.showError("Error Opening External File", "Exception: " + e.getMessage(), project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/console/FlutterConsoleFilter$OpenExternalFileHyperlink", "navigate"));
        }
    }

    private static class FlutterDoctorHyperlinkInfo
    implements HyperlinkInfo {
        private FlutterDoctorHyperlinkInfo() {
        }

        public void navigate(@NotNull Project project) {
            FlutterSdk sdk;
            if (project == null) {
                FlutterDoctorHyperlinkInfo.$$$reportNull$$$0(0);
            }
            if ((sdk = FlutterSdk.getFlutterSdk(project)) == null) {
                Messages.showErrorDialog((Project)project, (String)"Flutter SDK not found", (String)"Error");
                return;
            }
            if (sdk.flutterDoctor().startInConsole(project) == null) {
                Messages.showErrorDialog((Project)project, (String)"Failed to start 'flutter doctor'", (String)"Error");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/console/FlutterConsoleFilter$FlutterDoctorHyperlinkInfo", "navigate"));
        }
    }
}

