/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.dart;

import com.intellij.psi.PsiElement;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartNamedArgument;
import com.jetbrains.lang.dart.util.DartPsiImplUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartPsiUtil {
    public static int parseLiteralNumber(@NotNull String val) throws NumberFormatException {
        if (val == null) {
            DartPsiUtil.$$$reportNull$$$0(0);
        }
        return val.startsWith("0x") || val.startsWith("0X") ? Integer.parseUnsignedInt(val.substring(2), 16) : Integer.parseUnsignedInt(val);
    }

    @Nullable
    public static PsiElement getNewExprFromType(PsiElement element) {
        if (element.getNode().getElementType() != DartTokenTypes.SIMPLE_TYPE) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        if ((parent = parent.getParent()) == null) {
            return null;
        }
        if (parent.getNode().getElementType() != DartTokenTypes.NEW_EXPRESSION) {
            return null;
        }
        return parent;
    }

    @Nullable
    public static String getValueOfPositionalArgument(@NotNull DartArguments arguments, int index) {
        DartExpression expression;
        if (arguments == null) {
            DartPsiUtil.$$$reportNull$$$0(1);
        }
        if ((expression = DartPsiUtil.getPositionalArgument(arguments, index)) == null) {
            return null;
        }
        if (expression.getNode().getElementType() != DartTokenTypes.LITERAL_EXPRESSION) {
            return null;
        }
        return expression.getText();
    }

    @Nullable
    public static DartExpression getPositionalArgument(@NotNull DartArguments arguments, int index) {
        DartArgumentList list;
        if (arguments == null) {
            DartPsiUtil.$$$reportNull$$$0(2);
        }
        if ((list = arguments.getArgumentList()) == null) {
            return null;
        }
        if (index >= list.getExpressionList().size()) {
            return null;
        }
        return (DartExpression)list.getExpressionList().get(index);
    }

    @Nullable
    public static String getValueOfNamedArgument(@NotNull DartArguments arguments, @NotNull String name) {
        PsiElement family;
        if (arguments == null) {
            DartPsiUtil.$$$reportNull$$$0(3);
        }
        if (name == null) {
            DartPsiUtil.$$$reportNull$$$0(4);
        }
        if ((family = DartPsiUtil.getNamedArgumentExpression(arguments, "fontFamily")) != null) {
            if (family.getNode().getElementType() == DartTokenTypes.STRING_LITERAL_EXPRESSION) {
                return (String)DartPsiImplUtil.getUnquotedDartStringAndItsRange((String)family.getText()).first;
            }
            return "";
        }
        return null;
    }

    @Nullable
    public static PsiElement getNamedArgumentExpression(@NotNull DartArguments arguments, @NotNull String name) {
        DartArgumentList list;
        if (arguments == null) {
            DartPsiUtil.$$$reportNull$$$0(5);
        }
        if (name == null) {
            DartPsiUtil.$$$reportNull$$$0(6);
        }
        if ((list = arguments.getArgumentList()) == null) {
            return null;
        }
        List namedArgumentList = list.getNamedArgumentList();
        for (DartNamedArgument namedArgument : namedArgumentList) {
            DartExpression nameExpression = namedArgument.getParameterReferenceExpression();
            PsiElement childId = nameExpression.getFirstChild();
            PsiElement child = nameExpression.getFirstChild();
            if (!name.equals(child.getText())) continue;
            return namedArgument.getExpression();
        }
        return null;
    }

    @Nullable
    public static PsiElement topmostReferenceExpression(@NotNull PsiElement element) {
        PsiElement id;
        if (element == null) {
            DartPsiUtil.$$$reportNull$$$0(7);
        }
        if ((id = element.getParent()) == null || id.getNode().getElementType() != DartTokenTypes.ID) {
            return null;
        }
        PsiElement refExpr = id.getParent();
        if (refExpr == null || refExpr.getNode().getElementType() != DartTokenTypes.REFERENCE_EXPRESSION) {
            return null;
        }
        for (PsiElement parent = refExpr.getParent(); parent != null && parent.getNode().getElementType() == DartTokenTypes.REFERENCE_EXPRESSION; parent = parent.getParent()) {
            refExpr = parent;
        }
        return refExpr;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "io/flutter/dart/DartPsiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseLiteralNumber";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueOfPositionalArgument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPositionalArgument";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueOfNamedArgument";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamedArgumentExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "topmostReferenceExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

