/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.dart;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartSyntax {
    @Nullable
    public static DartCallExpression findEnclosingFunctionCall(@NotNull PsiElement elt, @NotNull String functionName) {
        if (elt == null) {
            DartSyntax.$$$reportNull$$$0(0);
        }
        if (functionName == null) {
            DartSyntax.$$$reportNull$$$0(1);
        }
        return DartSyntax.findEnclosingFunctionCall(elt, functionName, new Equator<String, String>(){

            @Override
            boolean equate(@NotNull String first, @NotNull String second) {
                if (first == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (second == null) {
                    1.$$$reportNull$$$0(1);
                }
                return Objects.equals(first, second);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "first";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "second";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/dart/DartSyntax$1";
                objectArray[2] = "equate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public static DartCallExpression findEnclosingFunctionCall(@NotNull PsiElement elt, @NotNull Pattern functionRegex) {
        if (elt == null) {
            DartSyntax.$$$reportNull$$$0(2);
        }
        if (functionRegex == null) {
            DartSyntax.$$$reportNull$$$0(3);
        }
        return DartSyntax.findEnclosingFunctionCall(elt, functionRegex, new Equator<Pattern, String>(){

            @Override
            boolean equate(@NotNull Pattern first, @NotNull String second) {
                if (first == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (second == null) {
                    2.$$$reportNull$$$0(1);
                }
                return first.matcher(second).matches();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "first";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "second";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/dart/DartSyntax$2";
                objectArray[2] = "equate";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static <T> DartCallExpression findEnclosingFunctionCall(@NotNull PsiElement elt, @NotNull T functionDescriptor, @NotNull Equator<T, String> equator) {
        if (elt == null) {
            DartSyntax.$$$reportNull$$$0(4);
        }
        if (functionDescriptor == null) {
            DartSyntax.$$$reportNull$$$0(5);
        }
        if (equator == null) {
            DartSyntax.$$$reportNull$$$0(6);
        }
        while (elt != null) {
            DartCallExpression call;
            String name;
            if (elt instanceof DartCallExpression && (name = DartSyntax.getCalledFunctionName(call = (DartCallExpression)elt)) != null && equator.equate(functionDescriptor, name)) {
                return call;
            }
            elt = elt.getParent();
        }
        return null;
    }

    @Nullable
    public static DartCallExpression findClosestEnclosingFunctionCall(@Nullable PsiElement element) {
        while (element != null) {
            DartCallExpression call;
            String name;
            if (element instanceof DartCallExpression && (name = DartSyntax.getCalledFunctionName(call = (DartCallExpression)element)) != null) {
                return call;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static DartNewExpression findEnclosingNewExpression(@NotNull PsiElement elt) {
        if (elt == null) {
            DartSyntax.$$$reportNull$$$0(7);
        }
        while (elt != null) {
            if (elt instanceof DartNewExpression) {
                return (DartNewExpression)elt;
            }
            elt = elt.getParent();
        }
        return null;
    }

    @Nullable
    public static DartReferenceExpression findEnclosingReferenceExpression(@NotNull PsiElement elt) {
        if (elt == null) {
            DartSyntax.$$$reportNull$$$0(8);
        }
        while (elt != null) {
            if (elt instanceof DartReferenceExpression && !(elt.getParent() instanceof DartReferenceExpression)) {
                return (DartReferenceExpression)elt;
            }
            elt = elt.getParent();
        }
        return null;
    }

    @Nullable
    public static <E extends DartExpression> E getArgument(@NotNull DartCallExpression call, int index, @NotNull Class<E> expectedClass) {
        if (call == null) {
            DartSyntax.$$$reportNull$$$0(9);
        }
        if (expectedClass == null) {
            DartSyntax.$$$reportNull$$$0(10);
        }
        if (call.getArguments() == null) {
            return null;
        }
        DartArgumentList list = call.getArguments().getArgumentList();
        if (list == null) {
            return null;
        }
        List args = list.getExpressionList();
        if (args.size() <= index) {
            return null;
        }
        try {
            return (E)((DartExpression)expectedClass.cast(args.get(index)));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static boolean isCallToFunctionNamed(@NotNull DartCallExpression element, @NotNull String functionName) {
        if (element == null) {
            DartSyntax.$$$reportNull$$$0(11);
        }
        if (functionName == null) {
            DartSyntax.$$$reportNull$$$0(12);
        }
        String name = DartSyntax.getCalledFunctionName(element);
        return Objects.equals(name, functionName);
    }

    public static boolean isCallToFunctionMatching(@NotNull DartCallExpression element, @NotNull Pattern functionRegex) {
        String name;
        if (element == null) {
            DartSyntax.$$$reportNull$$$0(13);
        }
        if (functionRegex == null) {
            DartSyntax.$$$reportNull$$$0(14);
        }
        return (name = DartSyntax.getCalledFunctionName(element)) != null && functionRegex.matcher(name).matches();
    }

    public static boolean isMainFunctionDeclaration(@Nullable PsiElement element) {
        if (!(element instanceof DartFunctionDeclarationWithBodyOrNative)) {
            return false;
        }
        String functionName = ((DartFunctionDeclarationWithBodyOrNative)element).getComponentName().getId().getText();
        return Objects.equals(functionName, "main");
    }

    @Nullable
    public static String unquote(@NotNull DartStringLiteralExpression lit) {
        if (lit == null) {
            DartSyntax.$$$reportNull$$$0(15);
        }
        if (!lit.getShortTemplateEntryList().isEmpty() || !lit.getLongTemplateEntryList().isEmpty()) {
            return null;
        }
        if (lit.getFirstChild() == null) {
            return null;
        }
        PsiElement second = lit.getFirstChild().getNextSibling();
        if (second.getNextSibling() != lit.getLastChild()) {
            return null;
        }
        if (!(second instanceof LeafPsiElement)) {
            return null;
        }
        LeafPsiElement leaf = (LeafPsiElement)second;
        if (leaf.getElementType() != DartTokenTypes.REGULAR_STRING_PART) {
            return null;
        }
        return leaf.getText();
    }

    @Nullable
    private static String getCalledFunctionName(@NotNull DartCallExpression call) {
        if (call == null) {
            DartSyntax.$$$reportNull$$$0(16);
        }
        if (!(call.getFirstChild() instanceof DartReference)) {
            return null;
        }
        return call.getFirstChild().getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionRegex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equator";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedClass";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lit";
                break;
            }
        }
        objectArray2[1] = "io/flutter/dart/DartSyntax";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findEnclosingFunctionCall";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findEnclosingNewExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findEnclosingReferenceExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getArgument";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallToFunctionNamed";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallToFunctionMatching";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "unquote";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getCalledFunctionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class Equator<T, S> {
        private Equator() {
        }

        abstract boolean equate(@NotNull T var1, @NotNull S var2);
    }
}

