/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.dart;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.dart.server.AnalysisServerListener;
import com.google.dart.server.AnalysisServerListenerAdapter;
import com.google.dart.server.ResponseListener;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import io.flutter.FlutterInitializer;
import io.flutter.analytics.TimeTracker;
import io.flutter.dart.DartPlugin;
import io.flutter.dart.FlutterOutlineListener;
import io.flutter.dart.FlutterRequestUtilities;
import io.flutter.utils.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.dartlang.analysis.server.protocol.FlutterWidgetProperty;
import org.dartlang.analysis.server.protocol.FlutterWidgetPropertyValue;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterDartAnalysisServer
implements Disposable {
    private static final String FLUTTER_NOTIFICATION_OUTLINE = "flutter.outline";
    private static final String FLUTTER_NOTIFICATION_OUTLINE_KEY = "\"flutter.outline\"";
    @NotNull
    final Project project;
    private final Map<String, List<String>> subscriptions;
    @VisibleForTesting
    protected final Map<String, List<FlutterOutlineListener>> fileOutlineListeners;
    private final Map<String, Consumer<JsonObject>> responseConsumers;
    private boolean isDisposed;

    @NotNull
    public static FlutterDartAnalysisServer getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(0);
        }
        FlutterDartAnalysisServer flutterDartAnalysisServer = Objects.requireNonNull((FlutterDartAnalysisServer)project.getService(FlutterDartAnalysisServer.class));
        if (flutterDartAnalysisServer == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(1);
        }
        return flutterDartAnalysisServer;
    }

    @NotNull
    private DartAnalysisServerService getAnalysisService() {
        DartAnalysisServerService dartAnalysisServerService = Objects.requireNonNull(DartPlugin.getInstance().getAnalysisService(this.project));
        if (dartAnalysisServerService == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(2);
        }
        return dartAnalysisServerService;
    }

    @VisibleForTesting
    public FlutterDartAnalysisServer(final @NotNull Project project) {
        if (project == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(3);
        }
        this.subscriptions = new HashMap<String, List<String>>();
        this.fileOutlineListeners = new HashMap<String, List<FlutterOutlineListener>>();
        this.responseConsumers = new HashMap<String, Consumer<JsonObject>>();
        this.isDisposed = false;
        this.project = project;
        DartAnalysisServerService analysisService = this.getAnalysisService();
        analysisService.addResponseListener((ResponseListener)new CompatibleResponseListener());
        analysisService.addAnalysisServerListener((AnalysisServerListener)new AnalysisServerListenerAdapter(){
            private boolean hasComputedErrors = false;

            public void serverConnected(String s) {
                if (!FlutterDartAnalysisServer.this.subscriptions.isEmpty()) {
                    FlutterDartAnalysisServer.this.sendSubscriptions();
                }
            }

            public void computedErrors(String file, List<AnalysisError> errors) {
                if (!this.hasComputedErrors && project.isOpen()) {
                    FlutterInitializer.getAnalytics().sendEventMetric("startup", "analysisComputedErrors", TimeTracker.getInstance(project).millisSinceProjectOpen());
                    this.hasComputedErrors = true;
                }
                super.computedErrors(file, errors);
            }
        });
        Disposer.register((Disposable)project, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutlineListener(@NotNull String filePath, @NotNull FlutterOutlineListener listener) {
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(4);
        }
        if (listener == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(5);
        }
        Map<String, List<FlutterOutlineListener>> map = this.fileOutlineListeners;
        synchronized (map) {
            List listeners = this.fileOutlineListeners.computeIfAbsent(filePath, k -> new ArrayList());
            listeners.add(listener);
        }
        this.addSubscription("OUTLINE", filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutlineListener(@NotNull String filePath, @NotNull FlutterOutlineListener listener) {
        boolean removeSubscription;
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(6);
        }
        if (listener == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(7);
        }
        Map<String, List<FlutterOutlineListener>> map = this.fileOutlineListeners;
        synchronized (map) {
            List<FlutterOutlineListener> listeners = this.fileOutlineListeners.get(filePath);
            removeSubscription = listeners != null && listeners.remove(listener);
        }
        if (removeSubscription) {
            this.removeSubscription("OUTLINE", filePath);
        }
    }

    private void addSubscription(@NotNull String service, @NotNull String filePath) {
        List files;
        if (service == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(8);
        }
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(9);
        }
        if (!(files = this.subscriptions.computeIfAbsent(service, k -> new ArrayList())).contains(filePath)) {
            files.add(filePath);
            this.sendSubscriptions();
        }
    }

    private void removeSubscription(@NotNull String service, @NotNull String filePath) {
        List<String> files;
        if (service == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(10);
        }
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(11);
        }
        if ((files = this.subscriptions.get(service)) != null && files.remove(filePath)) {
            this.sendSubscriptions();
        }
    }

    private void sendSubscriptions() {
        DartAnalysisServerService analysisService = this.getAnalysisService();
        String id = analysisService.generateUniqueId();
        analysisService.sendRequest(id, FlutterRequestUtilities.generateAnalysisSetSubscriptions(id, this.subscriptions));
    }

    @NotNull
    public List<SourceChange> edit_getAssists(@NotNull VirtualFile file, int offset, int length) {
        if (file == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(12);
        }
        DartAnalysisServerService analysisService = this.getAnalysisService();
        List list = analysisService.edit_getAssists(file, offset, length);
        if (list == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(13);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompletableFuture<List<FlutterWidgetProperty>> getWidgetDescription(@NotNull VirtualFile file, int _offset) {
        if (file == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(14);
        }
        CompletableFuture<List<FlutterWidgetProperty>> result = new CompletableFuture<List<FlutterWidgetProperty>>();
        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        DartAnalysisServerService analysisService = this.getAnalysisService();
        int offset = analysisService.getOriginalOffset(file, _offset);
        String id = analysisService.generateUniqueId();
        Map<String, Consumer<JsonObject>> map = this.responseConsumers;
        synchronized (map) {
            this.responseConsumers.put(id, (Consumer<JsonObject>)((Consumer)resultObject -> {
                try {
                    JsonArray propertiesObject = resultObject.getAsJsonArray("properties");
                    ArrayList<FlutterWidgetProperty> properties = new ArrayList<FlutterWidgetProperty>();
                    for (JsonElement propertyObject : propertiesObject) {
                        properties.add(FlutterWidgetProperty.fromJson(propertyObject.getAsJsonObject()));
                    }
                    result.complete(properties);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }));
        }
        JsonObject request = FlutterRequestUtilities.generateFlutterGetWidgetDescription(id, filePath, offset);
        analysisService.sendRequest(id, request);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SourceChange setWidgetPropertyValue(int propertyId, FlutterWidgetPropertyValue value) {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        DartAnalysisServerService analysisService = this.getAnalysisService();
        String id = analysisService.generateUniqueId();
        Map<String, Consumer<JsonObject>> map = this.responseConsumers;
        synchronized (map) {
            this.responseConsumers.put(id, (Consumer<JsonObject>)((Consumer)resultObject -> {
                try {
                    JsonObject propertiesObject = resultObject.getAsJsonObject("change");
                    result.set(SourceChange.fromJson((JsonObject)propertiesObject));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                latch.countDown();
            }));
        }
        JsonObject request = FlutterRequestUtilities.generateFlutterSetWidgetPropertyValue(id, propertyId, value);
        analysisService.sendRequest(id, request);
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        return (SourceChange)result.get();
    }

    private void processString(String jsonString) {
        if (this.isDisposed) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.isDisposed) {
                return;
            }
            this.processResponse(JsonUtils.parseString(jsonString).getAsJsonObject());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(JsonObject response) {
        Consumer<JsonObject> consumer;
        JsonElement eventName = response.get("event");
        if (eventName != null && eventName.isJsonPrimitive()) {
            this.processNotification(response, eventName);
            return;
        }
        if (response.has("error")) {
            return;
        }
        JsonObject resultObject = response.getAsJsonObject("result");
        if (resultObject == null) {
            return;
        }
        JsonPrimitive idJsonPrimitive = (JsonPrimitive)response.get("id");
        if (idJsonPrimitive == null) {
            return;
        }
        String idString = idJsonPrimitive.getAsString();
        Map<String, Consumer<JsonObject>> map = this.responseConsumers;
        synchronized (map) {
            consumer = this.responseConsumers.remove(idString);
        }
        if (consumer == null) {
            return;
        }
        consumer.consume((Object)resultObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotification(JsonObject response, @NotNull JsonElement eventName) {
        String event;
        if (eventName == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(15);
        }
        if ((event = eventName.getAsString()).equals(FLUTTER_NOTIFICATION_OUTLINE)) {
            ArrayList listenersUpdated;
            JsonObject paramsObject = response.get("params").getAsJsonObject();
            String file = paramsObject.get("file").getAsString();
            JsonElement instrumentedCodeElement = paramsObject.get("instrumentedCode");
            String instrumentedCode = instrumentedCodeElement != null ? instrumentedCodeElement.getAsString() : null;
            JsonObject outlineObject = paramsObject.get("outline").getAsJsonObject();
            FlutterOutline outline = FlutterOutline.fromJson(outlineObject);
            Map<String, List<FlutterOutlineListener>> map = this.fileOutlineListeners;
            synchronized (map) {
                List<FlutterOutlineListener> listeners = this.fileOutlineListeners.get(file);
                listenersUpdated = listeners != null ? Lists.newArrayList(listeners) : null;
            }
            if (listenersUpdated != null) {
                for (FlutterOutlineListener listener : listenersUpdated) {
                    listener.outlineUpdated(file, outline, instrumentedCode);
                }
            }
        }
    }

    public void dispose() {
        this.isDisposed = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/dart/FlutterDartAnalysisServer";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/dart/FlutterDartAnalysisServer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisService";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "edit_getAssists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addOutlineListener";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeOutlineListener";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addSubscription";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeSubscription";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "edit_getAssists";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getWidgetDescription";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processNotification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 13 -> new IllegalStateException(string);
        };
    }

    class CompatibleResponseListener
    implements ResponseListener {
        CompatibleResponseListener() {
        }

        public void onResponse(JsonObject jsonObject) {
            FlutterDartAnalysisServer.this.processResponse(jsonObject);
        }

        public void onResponse(String jsonString) {
            FlutterDartAnalysisServer.this.processString(jsonString);
        }
    }
}

