/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.devtools;

import io.flutter.bazel.WorkspaceCache;
import io.flutter.devtools.DevToolsIdeFeature;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.sdk.FlutterSdkVersion;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevToolsUrl {
    private String devtoolsHost;
    private int devtoolsPort;
    private String vmServiceUri;
    private String page;
    private boolean embed;
    public String colorHexCode;
    public String widgetId;
    public Float fontSize;
    private final FlutterSdkVersion flutterSdkVersion;
    private final FlutterSdkUtil sdkUtil;
    private final boolean canUseDevToolsPathUrl;
    public final DevToolsIdeFeature ideFeature;

    public DevToolsUrl(String devtoolsHost, int devtoolsPort, String vmServiceUri, String page, boolean embed, String colorHexCode, Float fontSize, @Nullable FlutterSdkVersion flutterSdkVersion, WorkspaceCache workspaceCache, DevToolsIdeFeature ideFeature) {
        this(devtoolsHost, devtoolsPort, vmServiceUri, page, embed, colorHexCode, fontSize, flutterSdkVersion, workspaceCache, ideFeature, new FlutterSdkUtil());
    }

    public DevToolsUrl(String devtoolsHost, int devtoolsPort, String vmServiceUri, String page, boolean embed, String colorHexCode, Float fontSize, FlutterSdkVersion flutterSdkVersion, WorkspaceCache workspaceCache, DevToolsIdeFeature ideFeature, FlutterSdkUtil flutterSdkUtil) {
        this.devtoolsHost = devtoolsHost;
        this.devtoolsPort = devtoolsPort;
        this.vmServiceUri = vmServiceUri;
        this.page = page;
        this.embed = embed;
        this.colorHexCode = colorHexCode;
        this.fontSize = fontSize;
        this.flutterSdkVersion = flutterSdkVersion;
        this.ideFeature = ideFeature;
        this.sdkUtil = flutterSdkUtil;
        this.canUseDevToolsPathUrl = workspaceCache != null && workspaceCache.isBazel() ? true : (flutterSdkVersion != null ? flutterSdkVersion.canUseDevToolsPathUrls() : false);
    }

    @NotNull
    public String getUrlString() {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("ide=" + this.sdkUtil.getFlutterHostEnvValue());
        if (this.page != null && !this.canUseDevToolsPathUrl) {
            params.add("page=" + this.page);
        }
        if (this.colorHexCode != null) {
            params.add("backgroundColor=" + this.colorHexCode);
        }
        if (this.embed) {
            params.add("embed=true");
        }
        if (this.fontSize != null) {
            params.add("fontSize=" + this.fontSize);
        }
        if (this.ideFeature != null) {
            params.add("ideFeature=" + this.ideFeature.value);
        }
        if (this.vmServiceUri != null) {
            String urlParam = URLEncoder.encode(this.vmServiceUri, StandardCharsets.UTF_8);
            params.add("uri=" + urlParam);
        }
        if (this.widgetId != null) {
            params.add("inspectorRef=" + this.widgetId);
        }
        if (this.canUseDevToolsPathUrl) {
            String string = "http://" + this.devtoolsHost + ":" + this.devtoolsPort + "/" + (this.page != null ? this.page : "") + "?" + String.join((CharSequence)"&", params);
            if (string == null) {
                DevToolsUrl.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = "http://" + this.devtoolsHost + ":" + this.devtoolsPort + "/#/?" + String.join((CharSequence)"&", params);
        if (string == null) {
            DevToolsUrl.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/devtools/DevToolsUrl", "getUrlString"));
    }
}

