/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import io.flutter.FlutterUtils;
import io.flutter.dart.FlutterDartAnalysisServer;
import io.flutter.dart.FlutterOutlineListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActiveEditorsOutlineService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, FlutterOutline> pathToOutline;
    @NotNull
    private final Map<String, FlutterOutlineListener> outlineListeners;
    @NotNull
    private final Set<Listener> listeners;

    @NotNull
    public static ActiveEditorsOutlineService getInstance(@NotNull Project project) {
        if (project == null) {
            ActiveEditorsOutlineService.$$$reportNull$$$0(0);
        }
        ActiveEditorsOutlineService activeEditorsOutlineService = Objects.requireNonNull((ActiveEditorsOutlineService)project.getService(ActiveEditorsOutlineService.class));
        if (activeEditorsOutlineService == null) {
            ActiveEditorsOutlineService.$$$reportNull$$$0(1);
        }
        return activeEditorsOutlineService;
    }

    public ActiveEditorsOutlineService(@NotNull Project project) {
        if (project == null) {
            ActiveEditorsOutlineService.$$$reportNull$$$0(2);
        }
        this.pathToOutline = new HashMap<String, FlutterOutline>();
        this.outlineListeners = new HashMap<String, FlutterOutlineListener>();
        this.listeners = new HashSet<Listener>();
        this.project = project;
        this.updateActiveEditors();
        project.getMessageBus().connect((Disposable)this.getAnalysisServer()).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ActiveEditorsOutlineService.this.updateActiveEditors();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/editor/ActiveEditorsOutlineService$1", "selectionChanged"));
            }
        });
    }

    @NotNull
    private FlutterDartAnalysisServer getAnalysisServer() {
        FlutterDartAnalysisServer flutterDartAnalysisServer = FlutterDartAnalysisServer.getInstance(this.project);
        if (flutterDartAnalysisServer == null) {
            ActiveEditorsOutlineService.$$$reportNull$$$0(3);
        }
        return flutterDartAnalysisServer;
    }

    public List<EditorEx> getActiveDartEditors() {
        if (this.project.isDisposed()) {
            return Collections.emptyList();
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        if (fileEditorManager == null) {
            return Collections.emptyList();
        }
        FileEditor[] editors = fileEditorManager.getSelectedEditors();
        ArrayList<EditorEx> dartEditors = new ArrayList<EditorEx>();
        for (FileEditor fileEditor : editors) {
            TextEditor textEditor;
            Editor editor;
            if (!(fileEditor instanceof TextEditor) || !((editor = (textEditor = (TextEditor)fileEditor).getEditor()) instanceof EditorEx) || editor.isDisposed() || !FlutterUtils.isDartFile(((EditorEx)editor).getVirtualFile())) continue;
            dartEditors.add((EditorEx)editor);
        }
        return dartEditors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveEditors() {
        if (this.project.isDisposed()) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        if (fileEditorManager == null) {
            return;
        }
        VirtualFile[] files = fileEditorManager.getSelectedFiles();
        HashSet<String> newPaths = new HashSet<String>();
        for (VirtualFile file : files) {
            if (!FlutterUtils.isDartFile(file) || !file.isInLocalFileSystem()) continue;
            newPaths.add(file.getPath());
        }
        ArrayList<String> obsoletePaths = new ArrayList<String>();
        FlutterDartAnalysisServer analysisServer = this.getAnalysisServer();
        Map<String, Object> map = this.outlineListeners;
        synchronized (map) {
            FlutterOutlineListener listener;
            for (String path : this.outlineListeners.keySet()) {
                if (newPaths.contains(path)) continue;
                obsoletePaths.add(path);
            }
            for (String path : obsoletePaths) {
                listener = this.outlineListeners.remove(path);
                if (listener == null) continue;
                this.getAnalysisServer().removeOutlineListener(path, listener);
            }
            for (String path : newPaths) {
                if (this.outlineListeners.containsKey(path)) continue;
                listener = new OutlineListener(path);
                this.outlineListeners.put(path, listener);
                this.getAnalysisServer().addOutlineListener(FileUtil.toSystemDependentName((String)path), listener);
            }
        }
        map = this.pathToOutline;
        synchronized (map) {
            for (String path : obsoletePaths) {
                this.pathToOutline.remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOutlineUpdated(String path) {
        ArrayList listenerList;
        Set<Listener> set = this.listeners;
        synchronized (set) {
            listenerList = Lists.newArrayList(this.listeners);
        }
        for (Listener listener : listenerList) {
            listener.onOutlineChanged(path, this.getOutline(path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            ActiveEditorsOutlineService.$$$reportNull$$$0(4);
        }
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            ActiveEditorsOutlineService.$$$reportNull$$$0(5);
        }
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    @Nullable
    public FlutterOutline getOutline(@Nullable String path) {
        return this.pathToOutline.get(path);
    }

    @Nullable
    public FlutterOutline getIfUpdated(@NotNull PsiFile file) {
        FlutterOutline outline;
        if (file == null) {
            ActiveEditorsOutlineService.$$$reportNull$$$0(6);
        }
        if ((outline = this.getOutline(file.getVirtualFile().getPath())) == null || this.isOutdated(outline, file)) {
            return null;
        }
        return outline;
    }

    private boolean isOutdated(@NotNull FlutterOutline outline, @NotNull PsiFile file) {
        if (outline == null) {
            ActiveEditorsOutlineService.$$$reportNull$$$0(7);
        }
        if (file == null) {
            ActiveEditorsOutlineService.$$$reportNull$$$0(8);
        }
        DartAnalysisServerService das = DartAnalysisServerService.getInstance((Project)file.getProject());
        return file.getTextLength() != outline.getLength() && file.getTextLength() != das.getConvertedOffset(file.getVirtualFile(), outline.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        FlutterDartAnalysisServer analysisServer = this.getAnalysisServer();
        Object object = this.outlineListeners;
        synchronized (object) {
            Iterator<Map.Entry<String, FlutterOutlineListener>> iterator = this.outlineListeners.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, FlutterOutlineListener> entry = iterator.next();
                String path = entry.getKey();
                FlutterOutlineListener listener = entry.getValue();
                iterator.remove();
                if (listener == null) continue;
                this.getAnalysisServer().removeOutlineListener(path, listener);
            }
            this.outlineListeners.clear();
        }
        object = this.pathToOutline;
        synchronized (object) {
            this.pathToOutline.clear();
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/editor/ActiveEditorsOutlineService";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outline";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/editor/ActiveEditorsOutlineService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIfUpdated";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isOutdated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    private class OutlineListener
    implements FlutterOutlineListener {
        private final String path;

        OutlineListener(String path) {
            this.path = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void outlineUpdated(@NotNull String systemDependentPath, @NotNull FlutterOutline outline, @Nullable String instrumentedCode) {
            if (systemDependentPath == null) {
                OutlineListener.$$$reportNull$$$0(0);
            }
            if (outline == null) {
                OutlineListener.$$$reportNull$$$0(1);
            }
            Map<String, Object> map = ActiveEditorsOutlineService.this.outlineListeners;
            synchronized (map) {
                if (!ActiveEditorsOutlineService.this.outlineListeners.containsKey(this.path)) {
                    return;
                }
            }
            map = ActiveEditorsOutlineService.this.pathToOutline;
            synchronized (map) {
                ActiveEditorsOutlineService.this.pathToOutline.put(this.path, outline);
                ActiveEditorsOutlineService.this.notifyOutlineUpdated(this.path);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "systemDependentPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outline";
                    break;
                }
            }
            objectArray[1] = "io/flutter/editor/ActiveEditorsOutlineService$OutlineListener";
            objectArray[2] = "outlineUpdated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener {
        public void onOutlineChanged(@NotNull String var1, @Nullable FlutterOutline var2);
    }
}

