/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import io.flutter.editor.ColorPickerProvider;
import io.flutter.editor.ExpressionParsingUtils;
import io.flutter.editor.FlutterColors;
import io.flutter.editor.PropertyEditorPanel;
import io.flutter.inspector.InspectorObjectGroupManager;
import io.flutter.inspector.InspectorService;
import io.flutter.utils.ColorIconMaker;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.dartlang.analysis.server.protocol.FlutterWidgetProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ColorField
extends ExtendableTextField {
    private final String originalExpression;
    private final String name;
    private final ExtendableTextComponent.Extension setColorExtension;
    @Nullable
    private Color currentColor;
    private ColorPickerProvider colorPicker;
    private final PropertyEditorPanel panel;
    private Color colorAtPopupLaunch;
    private String expressionAtPopupLaunch;

    public ColorField(PropertyEditorPanel panel2, String name, FlutterWidgetProperty property, Disposable parentDisposable) {
        super("", 1);
        this.name = name;
        String expression = property.getExpression();
        if (expression != null) {
            this.setText(expression);
        }
        this.originalExpression = expression;
        this.currentColor = ColorField.parseColorExpression(expression);
        final ColorIconMaker maker = new ColorIconMaker();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 64);
        this.setColorExtension = new ExtendableTextComponent.Extension(){

            public boolean isIconBeforeText() {
                return true;
            }

            public Icon getIcon(boolean hovered) {
                if (ColorField.this.currentColor == null) {
                    return AllIcons.Actions.Colors;
                }
                return maker.getCustomIcon(ColorField.this.currentColor);
            }

            public String getTooltip() {
                return "Edit color";
            }

            public Runnable getActionOnClick() {
                return () -> ColorField.this.showColorFieldPopup();
            }
        };
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ColorField.this.showColorFieldPopup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/editor/ColorField$2", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), (JComponent)((Object)this), parentDisposable);
        this.addExtension(this.setColorExtension);
        panel2.addTextFieldListeners(name, (JBTextField)this);
        this.panel = panel2;
    }

    @Nullable
    private static Color parseColorExpression(String expression) {
        FlutterColors.FlutterColor flutterColor;
        if (expression == null) {
            return null;
        }
        String colorsPrefix = "Colors.";
        if (expression.startsWith("Colors.") && (flutterColor = FlutterColors.getColor(expression.substring("Colors.".length()))) != null) {
            return flutterColor.getAWTColor();
        }
        return ExpressionParsingUtils.parseColor(expression);
    }

    private static String buildColorExpression(@Nullable Color color) {
        if (color == null) {
            return "";
        }
        String flutterColorName = FlutterColors.getColorName(color);
        if (flutterColorName != null) {
            return "Colors." + flutterColorName;
        }
        return String.format("Color(0x%02x%02x%02x%02x)", color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public void addTextFieldListeners(final String name, final JBTextField field) {
        final FlutterOutline matchingOutline = this.panel.getCurrentOutline();
        field.addActionListener(e -> this.panel.setPropertyValue(name, field.getText()));
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ColorField.this.disposeColorPicker();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ColorField.this.panel.getCurrentOutline() != matchingOutline) {
                    return;
                }
                if (e.isTemporary()) {
                    return;
                }
                if (ColorField.this.colorPicker != null) {
                    return;
                }
                ColorField.this.panel.setPropertyValue(name, field.getText());
            }
        });
    }

    void cancelPopup() {
        this.currentColor = this.colorAtPopupLaunch;
        this.setText(this.expressionAtPopupLaunch);
        this.panel.setPropertyValue(this.name, this.originalExpression, true);
        this.repaint();
        this.colorPicker.dispose();
        this.colorPicker = null;
    }

    void disposeColorPicker() {
        if (this.colorPicker != null) {
            this.colorPicker.dispose();
            this.colorPicker = null;
        }
    }

    void showColorFieldPopup() {
        this.disposeColorPicker();
        assert (this.colorPicker == null);
        this.colorPicker = (ColorPickerProvider)ColorPickerProvider.EP_NAME.getExtensionList().get(0);
        if (this.colorPicker != null) {
            this.colorAtPopupLaunch = this.currentColor;
            Insets insets = this.getInsets();
            Point bottomColorIconOffset = new Point(insets.left + this.setColorExtension.getIconGap(), this.getHeight() / 2);
            this.colorPicker.show(this.currentColor, (JComponent)((Object)this), bottomColorIconOffset, Balloon.Position.atLeft, this::colorListener, this::cancelPopup, this::applyColor);
            this.expressionAtPopupLaunch = this.getText();
        }
    }

    private void colorListener(@Nullable Color color, Object o) {
        if (this.colorPicker == null) {
            return;
        }
        this.currentColor = color;
        InspectorObjectGroupManager groupManager = this.panel.getGroupManager();
        String colorExpression = ColorField.buildColorExpression(color);
        this.setText(colorExpression);
        this.repaint();
        if (this.panel.getNode() != null && groupManager != null) {
            InspectorService.ObjectGroup group = groupManager.getCurrent();
            CompletableFuture<Boolean> valueFuture = groupManager.getCurrent().setColorProperty(this.panel.getNode(), color);
            group.safeWhenComplete(valueFuture, (success, error) -> {
                if (success == null || error != null) {
                    return;
                }
            });
        }
    }

    private void applyColor() {
        this.disposeColorPicker();
        String colorExpression = ColorField.buildColorExpression(this.currentColor);
        this.setText(colorExpression);
        this.panel.setPropertyValue(this.name, colorExpression);
        this.repaint();
    }
}

