/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EditorEventServiceBase<L>
implements Disposable {
    private final SetMultimap<EditorEx, L> listeners = HashMultimap.create();
    private final Project project;

    public EditorEventServiceBase(Project project) {
        this.project = project;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    protected void invokeAll(InvokeListener<L> invoke, Editor editor) {
        if (!(editor instanceof EditorEx)) {
            return;
        }
        ArrayList<EditorEx> disposedEditors = new ArrayList<EditorEx>();
        for (EditorEx e : this.listeners.keySet()) {
            if (!e.isDisposed()) continue;
            disposedEditors.add(e);
        }
        for (EditorEx e : disposedEditors) {
            this.listeners.removeAll((Object)e);
        }
        EditorEx editorEx = (EditorEx)editor;
        Set matches = this.listeners.get((Object)editorEx);
        if (matches == null || matches.isEmpty()) {
            return;
        }
        for (Object listener : matches) {
            try {
                invoke.run(listener);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull EditorEx editor, @NotNull L listener, Disposable parent) {
        if (editor == null) {
            EditorEventServiceBase.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            EditorEventServiceBase.$$$reportNull$$$0(1);
        }
        SetMultimap<EditorEx, L> setMultimap = this.listeners;
        synchronized (setMultimap) {
            this.listeners.put((Object)editor, listener);
            Disposer.register((Disposable)parent, () -> this.removeListener(editor, listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(@NotNull EditorEx editor, @NotNull L listener) {
        if (editor == null) {
            EditorEventServiceBase.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            EditorEventServiceBase.$$$reportNull$$$0(3);
        }
        SetMultimap<EditorEx, L> setMultimap = this.listeners;
        synchronized (setMultimap) {
            this.listeners.remove((Object)editor, listener);
        }
    }

    EditorEx getIfValidForProject(Editor editor) {
        if (editor.getProject() != this.project) {
            return null;
        }
        if (editor.isDisposed() || this.project.isDisposed()) {
            return null;
        }
        if (!(editor instanceof EditorEx)) {
            return null;
        }
        return (EditorEx)editor;
    }

    public void dispose() {
        this.listeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "io/flutter/editor/EditorEventServiceBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static interface InvokeListener<L> {
        public void run(L var1);
    }
}

