/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import io.flutter.editor.EditorEventServiceBase;
import java.awt.Rectangle;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class EditorPositionService
extends EditorEventServiceBase<Listener>
implements Disposable {
    private final VisibleAreaListener visibleAreaListener;
    private final EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();

    public EditorPositionService(Project project) {
        super(project);
        this.visibleAreaListener = event -> this.invokeAll(listener -> listener.updateVisibleArea(event.getNewRectangle()), event.getEditor());
        this.eventMulticaster.addVisibleAreaListener(this.visibleAreaListener);
        this.eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                EditorPositionService.this.invokeAll(listener -> listener.updateSelected(e.getCaret()), e.getEditor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "io/flutter/editor/EditorPositionService$1", "caretPositionChanged"));
            }
        }, (Disposable)this);
    }

    @NotNull
    public static EditorPositionService getInstance(@NotNull Project project) {
        if (project == null) {
            EditorPositionService.$$$reportNull$$$0(0);
        }
        EditorPositionService editorPositionService = Objects.requireNonNull((EditorPositionService)project.getService(EditorPositionService.class));
        if (editorPositionService == null) {
            EditorPositionService.$$$reportNull$$$0(1);
        }
        return editorPositionService;
    }

    @Override
    public void addListener(@NotNull EditorEx editor, @NotNull Listener listener, Disposable disposable) {
        if (editor == null) {
            EditorPositionService.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            EditorPositionService.$$$reportNull$$$0(3);
        }
        super.addListener(editor, listener, disposable);
        listener.updateVisibleArea(editor.getScrollingModel().getVisibleArea());
        Caret carat = editor.getCaretModel().getPrimaryCaret();
        if (carat.isValid()) {
            listener.updateSelected(carat);
        }
    }

    @Override
    public void dispose() {
        this.eventMulticaster.removeVisibleAreaListener(this.visibleAreaListener);
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/editor/EditorPositionService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/editor/EditorPositionService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static interface Listener {
        public void updateVisibleArea(Rectangle var1);

        public void onVisibleChanged();

        default public void updateSelected(Caret carat) {
        }
    }
}

