/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import java.awt.Color;

public class ExpressionParsingUtils {
    public static Integer parseNumberFromCallParam(String callText, String prefix) {
        if (callText.startsWith(prefix) && callText.endsWith(")")) {
            String val = callText.substring(prefix.length(), callText.length() - 1).trim();
            int index = val.indexOf(44);
            if (index != -1) {
                val = val.substring(0, index);
            }
            try {
                return val.startsWith("0x") ? Integer.parseUnsignedInt(val.substring(2), 16) : Integer.parseUnsignedInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Color parseColor(String text) {
        Color color = ExpressionParsingUtils.parseColor(text, "const Color(");
        if (color != null) {
            return color;
        }
        return ExpressionParsingUtils.parseColor(text, "Color(");
    }

    public static Color parseColor(String text, String colorText) {
        Integer val = ExpressionParsingUtils.parseNumberFromCallParam(text, colorText);
        if (val == null) {
            return null;
        }
        try {
            int value = val;
            return new Color(value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF, value >> 24 & 0xFF);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Color parseColorComponents(String callText, String prefix, boolean isARGB) {
        if (callText.startsWith(prefix) && callText.endsWith(")")) {
            String colorString = callText.substring(prefix.length(), callText.length() - 1).trim();
            String[] maybeNumbers = colorString.split(",");
            if (maybeNumbers.length < 4) {
                return null;
            }
            return isARGB ? ExpressionParsingUtils.parseARGBColorComponents(maybeNumbers) : ExpressionParsingUtils.parseRGBOColorComponents(maybeNumbers);
        }
        return null;
    }

    private static Color parseARGBColorComponents(String[] maybeNumbers) {
        if (maybeNumbers.length < 4) {
            return null;
        }
        int[] argb = new int[4];
        for (int i = 0; i < 4; ++i) {
            String maybeNumber = maybeNumbers[i].trim();
            try {
                if (maybeNumber.startsWith("0x")) {
                    argb[i] = Integer.parseUnsignedInt(maybeNumber.substring(2), 16);
                    continue;
                }
                argb[i] = Integer.parseUnsignedInt(maybeNumber);
                continue;
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        try {
            return new Color(argb[1], argb[2], argb[3], argb[0]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Color parseRGBOColorComponents(String[] maybeNumbers) {
        float[] rgbo = new float[4];
        for (int i = 0; i < 4; ++i) {
            String maybeNumber = maybeNumbers[i].trim();
            try {
                if (i == 3) {
                    rgbo[i] = Float.parseFloat(maybeNumber);
                    if (!(rgbo[3] < 0.0f) && !(rgbo[3] > 1.0f)) continue;
                    return null;
                }
                rgbo[i] = maybeNumber.startsWith("0x") ? (float)Integer.parseUnsignedInt(maybeNumber.substring(2), 16) / 255.0f : (float)Integer.parseUnsignedInt(maybeNumber) / 255.0f;
                if (!(rgbo[i] < 0.0f) && !(rgbo[i] > 1.0f)) continue;
                return null;
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return new Color(rgbo[0], rgbo[1], rgbo[2], rgbo[3]);
    }
}

