/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentGuideDescriptor;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.IntStack;
import com.intellij.util.text.CharArrayUtil;
import io.flutter.editor.LineRange;
import io.flutter.editor.WidgetIndentHitTester;
import io.flutter.editor.WidgetIndentsHighlightingPass;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FilteredIndentsHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    private static final Key<List<RangeHighlighter>> INDENT_HIGHLIGHTERS_IN_EDITOR_KEY = Key.create((String)"INDENT_HIGHLIGHTERS_IN_EDITOR_KEY");
    private static final Key<Long> LAST_TIME_INDENTS_BUILT = Key.create((String)"LAST_TIME_INDENTS_BUILT");
    private final EditorEx myEditor;
    private final PsiFile myFile;
    private volatile List<TextRange> myRanges;
    private volatile List<IndentGuideDescriptor> myDescriptors;
    private static final CustomHighlighterRenderer RENDERER = (editor, highlighter, g) -> {
        Rectangle clip;
        CaretModel caretModel;
        int caretOffset;
        int off;
        Document doc;
        int textLength;
        int startOffset = highlighter.getStartOffset();
        if (startOffset >= (textLength = (doc = highlighter.getDocument()).getTextLength())) {
            return;
        }
        int endOffset = Math.min(highlighter.getEndOffset(), textLength);
        int endLine = doc.getLineNumber(endOffset);
        int startLine = doc.getLineNumber(startOffset);
        IndentGuideDescriptor descriptor = editor.getIndentsModel().getDescriptor(startLine, endLine);
        CharSequence chars = doc.getCharsSequence();
        do {
            int start = doc.getLineStartOffset(startLine);
            int end = doc.getLineEndOffset(startLine);
            off = CharArrayUtil.shiftForward((CharSequence)chars, (int)start, (int)end, (String)" \t");
        } while (--startLine > 1 && off < doc.getTextLength() && chars.charAt(off) == '\n');
        VisualPosition startPosition = editor.offsetToVisualPosition(off);
        int indentColumn = startPosition.column;
        int lineShift = 1;
        if (indentColumn <= 0 && descriptor != null) {
            indentColumn = descriptor.indentLevel;
            lineShift = 0;
        }
        if (indentColumn <= 0) {
            return;
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        if (foldingModel.isOffsetCollapsed(off)) {
            return;
        }
        FoldRegion headerRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineEndOffset(doc.getLineNumber(off)));
        FoldRegion tailRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineStartOffset(doc.getLineNumber(endOffset)));
        if (tailRegion != null && tailRegion == headerRegion) {
            return;
        }
        IndentGuideDescriptor guide = editor.getIndentsModel().getCaretIndentGuide();
        boolean selected = guide != null ? (caretOffset = (caretModel = editor.getCaretModel()).getOffset()) >= off && caretOffset < endOffset && caretModel.getLogicalPosition().column == indentColumn : false;
        Point start = editor.visualPositionToXY(new VisualPosition(startPosition.line + lineShift, indentColumn));
        VisualPosition endPosition = editor.offsetToVisualPosition(endOffset);
        Point end = editor.visualPositionToXY(new VisualPosition(endPosition.line, endPosition.column));
        int maxY = end.y;
        if (endPosition.line == editor.offsetToVisualPosition((int)doc.getTextLength()).line) {
            maxY += editor.getLineHeight();
        }
        if ((clip = g.getClipBounds()) != null) {
            if (clip.y >= maxY || clip.y + clip.height <= start.y) {
                return;
            }
            maxY = Math.min(maxY, clip.y + clip.height);
        }
        if (WidgetIndentsHighlightingPass.isIndentGuideHidden(editor, new LineRange(startLine, endPosition.line))) {
            return;
        }
        EditorColorsScheme scheme = editor.getColorsScheme();
        g.setColor(scheme.getColor(selected ? EditorColors.SELECTED_INDENT_GUIDE_COLOR : EditorColors.INDENT_GUIDE_COLOR));
        if (selected) {
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(start.x + WidgetIndentsHighlightingPass.INDENT_GUIDE_DELTA), (double)start.y, (double)(start.x + WidgetIndentsHighlightingPass.INDENT_GUIDE_DELTA), (double)(maxY - 1));
        } else {
            int y = start.y;
            int newY = start.y;
            SoftWrapModel softWrapModel = editor.getSoftWrapModel();
            int lineHeight = editor.getLineHeight();
            for (int i = Math.max(0, startLine + lineShift); i < endLine && newY < maxY; ++i) {
                List softWraps = softWrapModel.getSoftWrapsForLine(i);
                int logicalLineHeight = softWraps.size() * lineHeight;
                if (i > startLine + lineShift) {
                    logicalLineHeight += lineHeight;
                }
                if (!softWraps.isEmpty() && ((SoftWrap)softWraps.get(0)).getIndentInColumns() < indentColumn) {
                    if (y < newY || i > startLine + lineShift) {
                        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(start.x + WidgetIndentsHighlightingPass.INDENT_GUIDE_DELTA), (double)y, (double)(start.x + WidgetIndentsHighlightingPass.INDENT_GUIDE_DELTA), (double)(newY + lineHeight - 1));
                    }
                    y = newY += logicalLineHeight;
                } else {
                    newY += logicalLineHeight;
                }
                FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineEndOffset(i));
                if (foldRegion == null || foldRegion.getEndOffset() >= doc.getTextLength()) continue;
                i = doc.getLineNumber(foldRegion.getEndOffset());
            }
            if (y < maxY) {
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(start.x + WidgetIndentsHighlightingPass.INDENT_GUIDE_DELTA), (double)y, (double)(start.x + WidgetIndentsHighlightingPass.INDENT_GUIDE_DELTA), (double)(maxY - 1));
            }
        }
    };

    static LineRange getGuideLineRange(Editor editor, RangeHighlighter highlighter) {
        int off;
        Document doc;
        int textLength;
        int startOffset = highlighter.getStartOffset();
        if (startOffset >= (textLength = (doc = highlighter.getDocument()).getTextLength()) || !highlighter.isValid()) {
            return null;
        }
        int endOffset = Math.min(highlighter.getEndOffset(), textLength);
        int endLine = doc.getLineNumber(endOffset);
        int startLine = doc.getLineNumber(startOffset);
        IndentGuideDescriptor descriptor = editor.getIndentsModel().getDescriptor(startLine, endLine);
        CharSequence chars = doc.getCharsSequence();
        do {
            int start = doc.getLineStartOffset(startLine);
            int end = doc.getLineEndOffset(startLine);
            off = CharArrayUtil.shiftForward((CharSequence)chars, (int)start, (int)end, (String)" \t");
        } while (--startLine > 1 && off < textLength && chars.charAt(off) == '\n');
        VisualPosition startPosition = editor.offsetToVisualPosition(off);
        int indentColumn = startPosition.column;
        boolean lineShift = true;
        if (indentColumn <= 0 && descriptor != null) {
            indentColumn = descriptor.indentLevel;
            lineShift = false;
        }
        if (indentColumn <= 0) {
            return null;
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        if (foldingModel.isOffsetCollapsed(off)) {
            return null;
        }
        FoldRegion headerRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineEndOffset(doc.getLineNumber(off)));
        FoldRegion tailRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineStartOffset(doc.getLineNumber(endOffset)));
        if (tailRegion != null && tailRegion == headerRegion) {
            return null;
        }
        VisualPosition endPosition = editor.offsetToVisualPosition(endOffset);
        return new LineRange(startLine, endPosition.line);
    }

    FilteredIndentsHighlightingPass(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            FilteredIndentsHighlightingPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FilteredIndentsHighlightingPass.$$$reportNull$$$0(1);
        }
        if (file == null) {
            FilteredIndentsHighlightingPass.$$$reportNull$$$0(2);
        }
        super(project, editor.getDocument(), false);
        this.myRanges = Collections.emptyList();
        this.myDescriptors = Collections.emptyList();
        this.myEditor = (EditorEx)editor;
        this.myFile = file;
    }

    public static void onWidgetIndentsChanged(EditorEx editor, WidgetIndentHitTester oldHitTester, WidgetIndentHitTester newHitTester) {
        List highlighters = (List)editor.getUserData(INDENT_HIGHLIGHTERS_IN_EDITOR_KEY);
        if (highlighters != null) {
            DocumentEx doc = editor.getDocument();
            int textLength = doc.getTextLength();
            for (RangeHighlighter highlighter : highlighters) {
                boolean after;
                boolean before;
                LineRange range;
                if (!highlighter.isValid() || (range = FilteredIndentsHighlightingPass.getGuideLineRange((Editor)editor, highlighter)) == null || (before = WidgetIndentsHighlightingPass.isIndentGuideHidden(oldHitTester, range)) == (after = WidgetIndentsHighlightingPass.isIndentGuideHidden(newHitTester, range))) continue;
                int safeStart = Math.min(highlighter.getStartOffset(), textLength);
                int safeEnd = Math.min(highlighter.getEndOffset(), textLength);
                if (safeEnd <= safeStart) continue;
                editor.repaint(safeStart, safeEnd);
            }
        }
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            FilteredIndentsHighlightingPass.$$$reportNull$$$0(3);
        }
        assert (this.myDocument != null);
        Long stamp = (Long)this.myEditor.getUserData(LAST_TIME_INDENTS_BUILT);
        if (stamp != null && stamp.longValue() == this.nowStamp()) {
            return;
        }
        this.myDescriptors = this.buildDescriptors();
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        for (IndentGuideDescriptor descriptor : this.myDescriptors) {
            ProgressManager.checkCanceled();
            int endOffset = descriptor.endLine < this.myDocument.getLineCount() ? this.myDocument.getLineStartOffset(descriptor.endLine) : this.myDocument.getTextLength();
            ranges.add(new TextRange(this.myDocument.getLineStartOffset(descriptor.startLine), endOffset));
        }
        Collections.sort(ranges, Segment.BY_START_OFFSET_THEN_END_OFFSET);
        this.myRanges = ranges;
    }

    private long nowStamp() {
        if (this.myEditor.getSettings().isIndentGuidesShown()) {
            return -1L;
        }
        assert (this.myDocument != null);
        return this.myDocument.getModificationStamp();
    }

    public static void cleanupHighlighters(Editor editor) {
        List highlighters = (List)editor.getUserData(INDENT_HIGHLIGHTERS_IN_EDITOR_KEY);
        if (highlighters == null) {
            return;
        }
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.dispose();
        }
        editor.putUserData(INDENT_HIGHLIGHTERS_IN_EDITOR_KEY, null);
        editor.putUserData(LAST_TIME_INDENTS_BUILT, null);
    }

    public void doApplyInformationToEditor() {
        Long stamp = (Long)this.myEditor.getUserData(LAST_TIME_INDENTS_BUILT);
        if (stamp != null && stamp.longValue() == this.nowStamp()) {
            return;
        }
        List oldHighlighters = (List)this.myEditor.getUserData(INDENT_HIGHLIGHTERS_IN_EDITOR_KEY);
        ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>();
        MarkupModelEx mm = this.myEditor.getMarkupModel();
        int curRange = 0;
        if (oldHighlighters != null) {
            RangeHighlighter highlighter;
            oldHighlighters.sort(Comparator.comparing(h -> !h.isValid()).thenComparing(Segment.BY_START_OFFSET_THEN_END_OFFSET));
            int curHighlight = 0;
            while (curRange < this.myRanges.size() && curHighlight < oldHighlighters.size()) {
                TextRange range = this.myRanges.get(curRange);
                RangeHighlighter highlighter2 = (RangeHighlighter)oldHighlighters.get(curHighlight);
                if (!highlighter2.isValid()) break;
                int cmp = FilteredIndentsHighlightingPass.compare(range, highlighter2);
                if (cmp < 0) {
                    newHighlighters.add(FilteredIndentsHighlightingPass.createHighlighter((MarkupModel)mm, range));
                    ++curRange;
                    continue;
                }
                if (cmp > 0) {
                    highlighter2.dispose();
                    ++curHighlight;
                    continue;
                }
                newHighlighters.add(highlighter2);
                ++curHighlight;
                ++curRange;
            }
            while (curHighlight < oldHighlighters.size() && (highlighter = (RangeHighlighter)oldHighlighters.get(curHighlight)).isValid()) {
                highlighter.dispose();
                ++curHighlight;
            }
        }
        int startRangeIndex = curRange;
        assert (this.myDocument != null);
        DocumentUtil.executeInBulk((Document)this.myDocument, (this.myRanges.size() > 10000 ? 1 : 0) != 0, () -> this.lambda$doApplyInformationToEditor$2(startRangeIndex, newHighlighters, (MarkupModel)mm));
        this.myEditor.putUserData(INDENT_HIGHLIGHTERS_IN_EDITOR_KEY, newHighlighters);
        this.myEditor.putUserData(LAST_TIME_INDENTS_BUILT, (Object)this.nowStamp());
        this.myEditor.getIndentsModel().assumeIndents(this.myDescriptors);
    }

    private List<IndentGuideDescriptor> buildDescriptors() {
        if (this.myEditor.getSettings().isIndentGuidesShown()) {
            return Collections.emptyList();
        }
        IndentsCalculator calculator = new IndentsCalculator();
        calculator.calculate();
        int[] lineIndents = calculator.lineIndents;
        IntStack lines = new IntStack();
        IntStack indents = new IntStack();
        lines.push(0);
        indents.push(0);
        assert (this.myDocument != null);
        ArrayList<IndentGuideDescriptor> descriptors = new ArrayList<IndentGuideDescriptor>();
        for (int line = 1; line < lineIndents.length; ++line) {
            ProgressManager.checkCanceled();
            int curIndent = Math.abs(lineIndents[line]);
            block1: while (!indents.empty() && curIndent <= indents.peek()) {
                ProgressManager.checkCanceled();
                int level = indents.pop();
                int startLine = lines.pop();
                if (level <= 0) continue;
                for (int i = startLine; i < line; ++i) {
                    if (level == Math.abs(lineIndents[i])) continue;
                    descriptors.add(this.createDescriptor(level, startLine, line, lineIndents));
                    continue block1;
                }
            }
            int prevLine = line - 1;
            int prevIndent = Math.abs(lineIndents[prevLine]);
            if (curIndent - prevIndent <= 1) continue;
            lines.push(prevLine);
            indents.push(prevIndent);
        }
        while (!indents.empty()) {
            ProgressManager.checkCanceled();
            int level = indents.pop();
            int startLine = lines.pop();
            if (level <= 0) continue;
            descriptors.add(this.createDescriptor(level, startLine, this.myDocument.getLineCount(), lineIndents));
        }
        return descriptors;
    }

    private IndentGuideDescriptor createDescriptor(int level, int startLine, int endLine, int[] lineIndents) {
        while (startLine > 0 && lineIndents[startLine] < 0) {
            --startLine;
        }
        int codeConstructStartLine = this.findCodeConstructStartLine(startLine);
        return new IndentGuideDescriptor(level, codeConstructStartLine, startLine, endLine);
    }

    private int findCodeConstructStartLine(int startLine) {
        HighlighterIterator iterator;
        Language language;
        int lineStartOffset;
        DocumentEx document = this.myEditor.getDocument();
        CharSequence text = document.getImmutableCharSequence();
        int firstNonWsOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)(lineStartOffset = document.getLineStartOffset(startLine)), (String)" \t");
        FileType type = PsiUtilBase.getPsiFileAtOffset((PsiFile)this.myFile, (int)firstNonWsOffset).getFileType();
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher((FileType)type, (Language)(language = PsiUtilCore.getLanguageAtOffset((PsiFile)this.myFile, (int)firstNonWsOffset)));
        if (braceMatcher.isLBraceToken(iterator = this.myEditor.getHighlighter().createIterator(firstNonWsOffset), text, type)) {
            int codeConstructStart = braceMatcher.getCodeConstructStart(this.myFile, firstNonWsOffset);
            return document.getLineNumber(codeConstructStart);
        }
        return startLine;
    }

    @NotNull
    private static RangeHighlighter createHighlighter(MarkupModel mm, TextRange range) {
        RangeHighlighter highlighter = mm.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 0, null, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setCustomRenderer(RENDERER);
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            FilteredIndentsHighlightingPass.$$$reportNull$$$0(4);
        }
        return rangeHighlighter;
    }

    private static int compare(@NotNull TextRange r, @NotNull RangeHighlighter h) {
        int answer;
        if (r == null) {
            FilteredIndentsHighlightingPass.$$$reportNull$$$0(5);
        }
        if (h == null) {
            FilteredIndentsHighlightingPass.$$$reportNull$$$0(6);
        }
        return (answer = r.getStartOffset() - h.getStartOffset()) != 0 ? answer : r.getEndOffset() - h.getEndOffset();
    }

    private /* synthetic */ void lambda$doApplyInformationToEditor$2(int startRangeIndex, List newHighlighters, MarkupModel mm) {
        for (int i = startRangeIndex; i < this.myRanges.size(); ++i) {
            newHighlighters.add(FilteredIndentsHighlightingPass.createHighlighter(mm, this.myRanges.get(i)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/editor/FilteredIndentsHighlightingPass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/editor/FilteredIndentsHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private class IndentsCalculator {
        @NotNull
        final Map<Language, TokenSet> myComments = new HashMap<Language, TokenSet>();
        @NotNull
        final int[] lineIndents;
        @NotNull
        final CharSequence myChars;

        IndentsCalculator() {
            assert (FilteredIndentsHighlightingPass.this.myDocument != null);
            this.lineIndents = new int[FilteredIndentsHighlightingPass.this.myDocument.getLineCount()];
            this.myChars = FilteredIndentsHighlightingPass.this.myDocument.getCharsSequence();
        }

        void calculate() {
            assert (FilteredIndentsHighlightingPass.this.myDocument != null);
            FileType fileType = FilteredIndentsHighlightingPass.this.myFile.getFileType();
            int tabSize = EditorUtil.getTabSize((Editor)FilteredIndentsHighlightingPass.this.myEditor);
            for (int line = 0; line < this.lineIndents.length; ++line) {
                int offset;
                ProgressManager.checkCanceled();
                int lineStart = FilteredIndentsHighlightingPass.this.myDocument.getLineStartOffset(line);
                int lineEnd = FilteredIndentsHighlightingPass.this.myDocument.getLineEndOffset(line);
                int column = 0;
                block5: for (offset = lineStart; offset < lineEnd; ++offset) {
                    switch (this.myChars.charAt(offset)) {
                        case ' ': {
                            ++column;
                            continue block5;
                        }
                        case '\t': {
                            column = (column / tabSize + 1) * tabSize;
                            continue block5;
                        }
                    }
                }
                this.lineIndents[line] = offset == lineEnd || this.isComment(offset) ? -1 : column;
            }
            int topIndent = 0;
            for (int line = 0; line < this.lineIndents.length; ++line) {
                ProgressManager.checkCanceled();
                if (this.lineIndents[line] >= 0) {
                    topIndent = this.lineIndents[line];
                    continue;
                }
                int startLine = line;
                while (line < this.lineIndents.length && this.lineIndents[line] < 0) {
                    ++line;
                }
                int bottomIndent = line < this.lineIndents.length ? this.lineIndents[line] : topIndent;
                int indent = Math.min(topIndent, bottomIndent);
                if (bottomIndent < topIndent) {
                    int lineStart = FilteredIndentsHighlightingPass.this.myDocument.getLineStartOffset(line);
                    int lineEnd = FilteredIndentsHighlightingPass.this.myDocument.getLineEndOffset(line);
                    int nonWhitespaceOffset = CharArrayUtil.shiftForward((CharSequence)this.myChars, (int)lineStart, (int)lineEnd, (String)" \t");
                    HighlighterIterator iterator = FilteredIndentsHighlightingPass.this.myEditor.getHighlighter().createIterator(nonWhitespaceOffset);
                    if (BraceMatchingUtil.isRBraceToken((HighlighterIterator)iterator, (CharSequence)this.myChars, (FileType)fileType)) {
                        indent = topIndent;
                    }
                }
                for (int blankLine = startLine; blankLine < line; ++blankLine) {
                    assert (this.lineIndents[blankLine] == -1);
                    this.lineIndents[blankLine] = -Math.min(topIndent, indent);
                }
                --line;
            }
        }

        private boolean isComment(int offset) {
            HighlighterIterator it = FilteredIndentsHighlightingPass.this.myEditor.getHighlighter().createIterator(offset);
            IElementType tokenType = it.getTokenType();
            Language language = tokenType.getLanguage();
            TokenSet comments = this.myComments.get(language);
            if (comments == null) {
                ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
                if (definition != null) {
                    comments = definition.getCommentTokens();
                }
                if (comments == null) {
                    return false;
                }
                this.myComments.put(language, comments);
            }
            return comments.contains(tokenType);
        }
    }
}

