/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ElementColorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartClassMembers;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartLiteralExpression;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import com.jetbrains.lang.dart.psi.DartVarInit;
import io.flutter.FlutterBundle;
import io.flutter.dart.DartPsiUtil;
import io.flutter.editor.ExpressionParsingUtils;
import io.flutter.editor.FlutterColors;
import io.flutter.editor.FlutterCupertinoColors;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterColorProvider
implements ElementColorProvider {
    @Nullable
    public Color getColorFrom(@NotNull PsiElement element) {
        String code;
        PsiElement idNode;
        if (element == null) {
            FlutterColorProvider.$$$reportNull$$$0(0);
        }
        if (element.getNode().getElementType() != DartTokenTypes.IDENTIFIER) {
            return null;
        }
        String name = element.getText();
        if (name == null) {
            return null;
        }
        PsiElement refExpr = DartPsiUtil.topmostReferenceExpression(element);
        if (refExpr == null) {
            return null;
        }
        PsiElement parent = refExpr.getParent();
        if (parent == null) {
            return null;
        }
        if (parent.getNode().getElementType() == DartTokenTypes.ARRAY_ACCESS_EXPRESSION) {
            if (name.equals(refExpr.getFirstChild().getText()) && refExpr.getChildren().length > 1) {
                return null;
            }
            String code2 = AstBufferUtil.getTextSkippingWhitespaceComments((ASTNode)parent.getNode());
            return this.parseColorText(code2.substring(code2.indexOf(name)), name);
        }
        if (parent.getNode().getElementType() == DartTokenTypes.CALL_EXPRESSION) {
            if (name.matches("fromARGB") || name.matches("fromRGBO")) {
                return null;
            }
            if (parent.getLastChild() instanceof DartArguments && !name.matches("(Cupertino)?Color")) {
                DartArgumentList argumentList = ((DartArguments)parent.getLastChild()).getArgumentList();
                if (argumentList == null) {
                    return null;
                }
                Color color = null;
                List expressionList = argumentList.getExpressionList();
                if (!expressionList.isEmpty()) {
                    DartExpression colorExpression = (DartExpression)expressionList.get(0);
                    color = this.parseColorElements((PsiElement)colorExpression, colorExpression.getFirstChild());
                }
                if (color != null) {
                    return null;
                }
            }
            return this.parseColorElements(parent, refExpr);
        }
        if (parent.getNode().getElementType() == DartTokenTypes.SIMPLE_TYPE) {
            if (name.matches("fromARGB") || name.matches("fromRGBO")) {
                return null;
            }
            if ((parent = DartPsiUtil.getNewExprFromType(parent)) == null) {
                return null;
            }
            return this.parseColorElements(parent, refExpr);
        }
        if (parent.getNode().getElementType() == DartTokenTypes.VAR_INIT || parent.getNode().getElementType() == DartTokenTypes.FUNCTION_BODY) {
            if (name.equals(refExpr.getFirstChild().getText()) && refExpr.getChildren().length > 1) {
                return null;
            }
            PsiElement reference = this.resolveReferencedElement(refExpr);
            if (reference != null && reference.getLastChild() != null) {
                Color tryParseColor;
                DartExpression expression;
                if (reference instanceof DartCallExpression && (expression = ((DartCallExpression)reference).getExpression()) != null && expression.getLastChild() instanceof DartReferenceExpression && (tryParseColor = this.parseColorElements(reference, (PsiElement)expression)) != null) {
                    return tryParseColor;
                }
                PsiElement lastChild = reference.getLastChild();
                tryParseColor = lastChild instanceof DartArguments && reference.getParent() != null ? this.parseColorElements(reference, reference.getParent()) : this.parseColorElements(reference, reference.getLastChild());
                if (tryParseColor != null) {
                    return tryParseColor;
                }
            }
        }
        if ((idNode = refExpr.getFirstChild()) == null) {
            return null;
        }
        if (name.equals(idNode.getText())) {
            PsiElement selectorNode = refExpr.getLastChild();
            if (selectorNode == null) {
                return null;
            }
            code = AstBufferUtil.getTextSkippingWhitespaceComments((ASTNode)selectorNode.getNode());
            return this.parseColorText(code, name);
        }
        PsiElement child = refExpr.getLastChild();
        if (child == null) {
            return null;
        }
        if (child.getText().startsWith("shade")) {
            if (idNode.getText().contains(name)) {
                return null;
            }
            code = AstBufferUtil.getTextSkippingWhitespaceComments((ASTNode)refExpr.getNode());
            code = code.replaceFirst("(Cupertino)?Colors\\.", "");
            return this.parseColorText(code, name);
        }
        return null;
    }

    @Nullable
    private PsiElement resolveReferencedElement(@NotNull PsiElement element) {
        PsiElement result;
        if (element == null) {
            FlutterColorProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof DartCallExpression && element.getFirstChild().getText().equals("Color")) {
            return element;
        }
        PsiElement symbol = element.getLastChild();
        if (symbol instanceof DartReference) {
            result = ((DartReference)symbol).resolve();
        } else if (element instanceof DartReference) {
            result = ((DartReference)element).resolve();
        } else {
            return null;
        }
        if (!(result instanceof DartComponentName) || result.getParent() == null) {
            return null;
        }
        PsiElement declaration = result.getParent().getParent();
        if (declaration instanceof DartClassMembers) {
            return declaration;
        }
        if (!(declaration instanceof DartVarDeclarationList)) {
            return null;
        }
        PsiElement lastChild = declaration.getLastChild();
        if (!(lastChild instanceof DartVarInit)) {
            return null;
        }
        PsiElement effectiveElement = lastChild.getLastChild();
        if (effectiveElement instanceof DartReference && !(effectiveElement instanceof DartCallExpression)) {
            return this.resolveReferencedElement(effectiveElement);
        }
        return effectiveElement;
    }

    @Nullable
    private Color parseColorElements(@NotNull PsiElement parent, @NotNull PsiElement refExpr) {
        PsiElement selectorNode;
        if (parent == null) {
            FlutterColorProvider.$$$reportNull$$$0(2);
        }
        if (refExpr == null) {
            FlutterColorProvider.$$$reportNull$$$0(3);
        }
        if ((selectorNode = refExpr.getLastChild()) == null) {
            return null;
        }
        String selector = selectorNode.getText();
        boolean isFromARGB = "fromARGB".equals(selector);
        boolean isFromRGBO = "fromRGBO".equals(selector);
        if (isFromARGB || isFromRGBO) {
            String code = AstBufferUtil.getTextSkippingWhitespaceComments((ASTNode)parent.getNode());
            if (code.startsWith("constColor(") || code.startsWith("constColor.")) {
                code = code.substring(5);
            }
            return ExpressionParsingUtils.parseColorComponents(code.substring(code.indexOf(selector)), selector + "(", isFromARGB);
        }
        PsiElement args = parent.getLastChild();
        if (args != null && args.getNode().getElementType() == DartTokenTypes.ARGUMENTS) {
            String code = AstBufferUtil.getTextSkippingWhitespaceComments((ASTNode)parent.getNode());
            if (code.startsWith("constColor(")) {
                code = code.substring(5);
            }
            return ExpressionParsingUtils.parseColor(code);
        }
        return null;
    }

    @Nullable
    private Color parseColorText(@NotNull String text, @NotNull String platform) {
        FlutterColors.FlutterColor color;
        if (text == null) {
            FlutterColorProvider.$$$reportNull$$$0(4);
        }
        if (platform == null) {
            FlutterColorProvider.$$$reportNull$$$0(5);
        }
        if ((color = "CupertinoColors".equals(platform) ? FlutterCupertinoColors.getColor(text) : FlutterColors.getColor(text)) != null) {
            return color.getAWTColor();
        }
        return null;
    }

    public void setColorTo(@NotNull PsiElement element, @NotNull Color color) {
        if (element == null) {
            FlutterColorProvider.$$$reportNull$$$0(6);
        }
        if (color == null) {
            FlutterColorProvider.$$$reportNull$$$0(7);
        }
        if (!element.getText().equals("Color")) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
        Runnable command = () -> {
            PsiElement refExpr = DartPsiUtil.topmostReferenceExpression(element);
            if (refExpr == null) {
                return;
            }
            PsiElement parent = refExpr.getParent();
            if (parent == null) {
                return;
            }
            if (parent.getNode().getElementType() == DartTokenTypes.CALL_EXPRESSION) {
                this.replaceColor(parent, refExpr, color);
            } else if (parent.getNode().getElementType() == DartTokenTypes.SIMPLE_TYPE) {
                if ((parent = DartPsiUtil.getNewExprFromType(parent)) == null) {
                    return;
                }
                this.replaceColor(parent, refExpr, color);
            }
        };
        CommandProcessor.getInstance().executeCommand(element.getProject(), command, FlutterBundle.message("change.color.command.text", new Object[0]), null, document);
    }

    private void replaceColor(@NotNull PsiElement parent, @NotNull PsiElement refExpr, Color color) {
        PsiElement selectorNode;
        if (parent == null) {
            FlutterColorProvider.$$$reportNull$$$0(8);
        }
        if (refExpr == null) {
            FlutterColorProvider.$$$reportNull$$$0(9);
        }
        if ((selectorNode = refExpr.getLastChild()) == null) {
            return;
        }
        String selector = selectorNode.getText();
        boolean isFromARGB = "fromARGB".equals(selector);
        boolean isFromRGBO = "fromRGBO".equals(selector);
        PsiElement args = parent.getLastChild();
        if (args == null || args.getNode().getElementType() != DartTokenTypes.ARGUMENTS) {
            return;
        }
        DartArgumentList list = ((DartArguments)args).getArgumentList();
        if (list == null) {
            return;
        }
        if (isFromARGB) {
            this.replaceARGB(list.getExpressionList(), color);
        } else if (isFromRGBO) {
            this.replaceRGBO(list.getExpressionList(), color);
        } else {
            this.replaceArg(list.getExpressionList(), color);
        }
    }

    private void replaceARGB(@NotNull List<DartExpression> args, Color color) {
        if (args == null) {
            FlutterColorProvider.$$$reportNull$$$0(10);
        }
        if (args.size() != 4) {
            return;
        }
        List<Integer> colors = Arrays.asList(color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
        for (int i = 0; i < args.size(); ++i) {
            this.replaceInt(args.get(i), colors.get(i));
        }
    }

    private void replaceRGBO(@NotNull List<DartExpression> args, Color color) {
        if (args == null) {
            FlutterColorProvider.$$$reportNull$$$0(11);
        }
        if (args.size() != 4) {
            return;
        }
        List<Integer> colors = Arrays.asList(color.getRed(), color.getGreen(), color.getBlue());
        for (int i = 0; i < colors.size(); ++i) {
            this.replaceInt(args.get(i), colors.get(i));
        }
        this.replaceDouble(args.get(3), (double)color.getAlpha() / 255.0);
    }

    private void replaceArg(@NotNull List<DartExpression> args, Color color) {
        if (args == null) {
            FlutterColorProvider.$$$reportNull$$$0(12);
        }
        if (args.size() != 1) {
            return;
        }
        this.replaceInt(args.get(0), color.getRGB());
    }

    private void replaceInt(DartExpression expr, Integer value) {
        if (expr instanceof DartLiteralExpression) {
            String source = expr.getText();
            String number = source.substring(Math.min(2, source.length()));
            boolean isHex = source.startsWith("0x") || source.startsWith("0X");
            boolean isUpper = isHex && number.toUpperCase().equals(number);
            String newValue = isHex ? Integer.toHexString(value) : Integer.toString(value);
            String num = isUpper ? newValue.toUpperCase() : newValue;
            String hex = isHex ? source.substring(0, 2) + num : num;
            PsiFileFactoryImpl factory = new PsiFileFactoryImpl(expr.getManager());
            PsiElement newPsi = factory.createElementFromText(hex, DartLanguage.INSTANCE, DartTokenTypes.LITERAL_EXPRESSION, expr.getContext());
            if (newPsi != null) {
                expr.replace(newPsi);
            }
        }
    }

    private void replaceDouble(DartExpression expr, Double value) {
        String number;
        PsiFileFactoryImpl factory;
        PsiElement newPsi;
        if (expr instanceof DartLiteralExpression && (newPsi = (factory = new PsiFileFactoryImpl(expr.getManager())).createElementFromText(number = Double.toString(value), DartLanguage.INSTANCE, DartTokenTypes.LITERAL_EXPRESSION, expr.getContext())) != null) {
            expr.replace(newPsi);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        objectArray2[1] = "io/flutter/editor/FlutterColorProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getColorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReferencedElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseColorElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseColorText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setColorTo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceColor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceARGB";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceRGBO";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceArg";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

