/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.diagnostic.Logger;
import io.flutter.FlutterUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterColors {
    private static final Logger LOG = Logger.getInstance(FlutterColors.class);
    static final String primarySuffix = ".primary";
    static final String defaultShade = "[500]";
    private static final Properties colors = new Properties();
    private static final Map<Color, String> colorToName;

    @Nullable
    public static FlutterColor getColor(@NotNull String key) {
        Color color;
        if (key == null) {
            FlutterColors.$$$reportNull$$$0(0);
        }
        if (((String)key).contains(".shade")) {
            key = ((String)key).replace(".shade", "[") + "]";
        }
        if (colors.containsKey(key)) {
            Color color2 = FlutterColors.getColorValue((String)key);
            if (color2 != null) {
                return new FlutterColor(color2, false);
            }
        } else if (colors.containsKey((String)key + primarySuffix) && (color = FlutterColors.getColorValue((String)key + primarySuffix)) != null) {
            return new FlutterColor(color, true);
        }
        return null;
    }

    @Nullable
    public static String getColorName(@Nullable Color color) {
        String name = colorToName.get(color);
        if (name == null) {
            return null;
        }
        name = FlutterColors.maybeTrimSuffix(name, primarySuffix);
        name = FlutterColors.maybeTrimSuffix(name, defaultShade);
        return name;
    }

    private static String maybeTrimSuffix(String value, String suffix) {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    private static Color parseColor(String hexValue) {
        if (hexValue == null) {
            return null;
        }
        try {
            long value = Long.parseLong(hexValue, 16);
            return new Color((int)(value >> 16) & 0xFF, (int)(value >> 8) & 0xFF, (int)value & 0xFF, (int)(value >> 24) & 0xFF);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Color getColorValue(String name) {
        String hexValue = colors.getProperty(name);
        return FlutterColors.parseColor(hexValue);
    }

    static {
        try {
            colors.load(FlutterUtils.class.getResourceAsStream("/flutter/colors/material.properties"));
        }
        catch (IOException e) {
            FlutterUtils.warn(LOG, e);
        }
        colorToName = new HashMap<Color, String>();
        for (Map.Entry<Object, Object> entry : colors.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            Color color = FlutterColors.parseColor(value);
            if (color == null) continue;
            colorToName.put(color, name);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "io/flutter/editor/FlutterColors", "getColor"));
    }

    public static class FlutterColor {
        @NotNull
        private final Color color;
        private final boolean isPrimary;

        FlutterColor(@NotNull Color color, boolean isPrimary) {
            if (color == null) {
                FlutterColor.$$$reportNull$$$0(0);
            }
            this.color = color;
            this.isPrimary = isPrimary;
        }

        @NotNull
        public Color getAWTColor() {
            Color color = this.color;
            if (color == null) {
                FlutterColor.$$$reportNull$$$0(1);
            }
            return color;
        }

        public boolean isPrimary() {
            return this.isPrimary;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/editor/FlutterColors$FlutterColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/editor/FlutterColors$FlutterColor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAWTColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

