/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.diagnostic.Logger;
import io.flutter.FlutterUtils;
import io.flutter.editor.FlutterColors;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterCupertinoColors {
    private static final Logger LOG = Logger.getInstance(FlutterCupertinoColors.class);
    private static final Properties colors = new Properties();
    private static final Map<Color, String> colorToName;

    @Nullable
    public static FlutterColors.FlutterColor getColor(@NotNull String key) {
        Color color;
        if (key == null) {
            FlutterCupertinoColors.$$$reportNull$$$0(0);
        }
        if (((String)key).contains(".shade")) {
            key = ((String)key).replace(".shade", "[") + "]";
        }
        if (colors.containsKey(key)) {
            Color color2 = FlutterCupertinoColors.getColorValue((String)key);
            if (color2 != null) {
                return new FlutterColors.FlutterColor(color2, false);
            }
        } else if (colors.containsKey((String)key + ".primary") && (color = FlutterCupertinoColors.getColorValue((String)key + ".primary")) != null) {
            return new FlutterColors.FlutterColor(color, true);
        }
        return null;
    }

    @Nullable
    public static String getColorName(@Nullable Color color) {
        String name = colorToName.get(color);
        if (name == null) {
            return null;
        }
        name = FlutterCupertinoColors.maybeTrimSuffix(name, ".primary");
        name = FlutterCupertinoColors.maybeTrimSuffix(name, "[500]");
        return name;
    }

    private static String maybeTrimSuffix(String value, String suffix) {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    private static Color parseColor(String hexValue) {
        if (hexValue == null) {
            return null;
        }
        try {
            long value = Long.parseLong(hexValue, 16);
            return new Color((int)(value >> 16) & 0xFF, (int)(value >> 8) & 0xFF, (int)value & 0xFF, (int)(value >> 24) & 0xFF);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Color getColorValue(String name) {
        String hexValue = colors.getProperty(name);
        return FlutterCupertinoColors.parseColor(hexValue);
    }

    static {
        try {
            colors.load(FlutterUtils.class.getResourceAsStream("/flutter/colors/cupertino.properties"));
        }
        catch (IOException e) {
            FlutterUtils.warn(LOG, e);
        }
        colorToName = new HashMap<Color, String>();
        for (Map.Entry<Object, Object> entry : colors.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            Color color = FlutterCupertinoColors.parseColor(value);
            if (color == null) continue;
            colorToName.put(color, name);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "io/flutter/editor/FlutterCupertinoColors", "getColor"));
    }
}

