/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.codeInsight.daemon.GutterName;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.AstBufferUtil;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartRecursiveVisitor;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartVarAccessDeclaration;
import com.jetbrains.lang.dart.psi.DartVarInit;
import com.jetbrains.lang.dart.psi.impl.DartCallExpressionImpl;
import com.jetbrains.lang.dart.util.DartPsiImplUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashSet;
import info.debatty.java.stringsimilarity.JaroWinkler;
import io.flutter.FlutterBundle;
import io.flutter.dart.DartPsiUtil;
import io.flutter.editor.FlutterCupertinoIcons;
import io.flutter.editor.FlutterMaterialIcons;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.utils.IconPreviewGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class FlutterIconLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public static final Map<String, Set<String>> KnownPaths = new HashMap<String, Set<String>>();
    private static final Map<String, String> BuiltInPaths = new HashMap<String, String>();
    private static final Logger LOG = Logger.getInstance(FlutterIconLineMarkerProvider.class);
    private static final String MaterialRelativeAssetPath = "/bin/cache/artifacts/material_fonts/MaterialIcons-Regular.otf";
    private static final String MaterialRelativeIconsPath = "/packages/flutter/lib/src/material/icons.dart";
    private static final String CupertinoRelativeAssetPath = "/assets/CupertinoIcons.ttf";
    private static final String CupertinoRelativeIconsPath = "/packages/flutter/lib/src/cupertino/icons.dart";

    public static void initialize() {
        KnownPaths.clear();
        KnownPaths.put("Icons", (Set<String>)new THashSet(Collections.singleton("packages/flutter/lib/src/material")));
        KnownPaths.put("IconData", (Set<String>)new THashSet(Collections.singleton("packages/flutter/lib/src/widgets")));
        KnownPaths.put("CupertinoIcons", (Set<String>)new THashSet(Collections.singleton("packages/flutter/lib/src/cupertino")));
        BuiltInPaths.clear();
        BuiltInPaths.put("Icons", MaterialRelativeIconsPath);
        BuiltInPaths.put("IconData", MaterialRelativeIconsPath);
        BuiltInPaths.put("CupertinoIcons", CupertinoRelativeIconsPath);
    }

    @Nullable(value="null means disabled")
    @GutterName
    public @Nullable(value="null means disabled") @GutterName String getName() {
        return FlutterBundle.message("flutter.icon.preview.title", new Object[0]);
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        FlutterSdk sdk;
        if (element == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return (sdk = FlutterSdk.getFlutterSdk(element.getProject())) == null ? null : this.getLineMarkerInfo(element, sdk);
    }

    @VisibleForTesting
    @Nullable
    LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element, @NotNull FlutterSdk sdk) {
        String path;
        if (element == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (sdk == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if ((element.getNode() != null ? element.getNode().getElementType() : null) != DartTokenTypes.IDENTIFIER) {
            return null;
        }
        String name = element.getText();
        assert (name != null);
        if (!KnownPaths.containsKey(name)) {
            return null;
        }
        PsiElement refExpr = DartPsiUtil.topmostReferenceExpression(element);
        if (refExpr == null) {
            return null;
        }
        PsiElement parent = refExpr.getParent();
        if (parent == null) {
            return null;
        }
        String knownPath = null;
        assert (ApplicationManager.getApplication() != null);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement symbol;
            PsiElement psiElement = symbol = "IconData".equals(name) ? refExpr : refExpr.getFirstChild();
            if (!(symbol instanceof DartReference)) {
                return null;
            }
            PsiElement result = ((DartReference)symbol).resolve();
            if (result == null) {
                return null;
            }
            assert (result.getContainingFile() != null);
            List library = DartResolveUtil.findLibrary((PsiFile)result.getContainingFile());
            block0: for (VirtualFile file : library) {
                int index;
                assert (file != null);
                VirtualFile dir = file.getParent();
                assert (dir != null);
                if (!dir.isInLocalFileSystem()) continue;
                String trimmedPath = path = dir.getPath();
                if (!path.endsWith("lib") && (index = path.indexOf("lib")) >= 0) {
                    trimmedPath = path.substring(0, index + 3);
                }
                Set<String> knownPaths = KnownPaths.get(name);
                assert (knownPaths != null);
                if (knownPaths.contains(path) || knownPaths.contains(trimmedPath)) {
                    knownPath = file.getPath();
                    break;
                }
                for (String aPath : knownPaths) {
                    assert (aPath != null);
                    if (!path.endsWith(aPath) && !aPath.contains(path) && !trimmedPath.endsWith(aPath) && !aPath.contains(trimmedPath)) continue;
                    knownPath = file.getPath();
                    continue block0;
                }
            }
            if (knownPath == null) {
                return null;
            }
        }
        ASTNode parentNode = parent.getNode();
        assert (parentNode != null);
        if (parentNode.getElementType() == DartTokenTypes.CALL_EXPRESSION) {
            arguments = DartPsiImplUtil.getArguments((DartCallExpression)((DartCallExpression)parent));
            if (arguments == null) {
                return null;
            }
            family = DartPsiUtil.getValueOfNamedArgument(arguments, "fontFamily");
            fontPackage = DartPsiUtil.getNamedArgumentExpression(arguments, "fontPackage");
            argument = DartPsiUtil.getValueOfPositionalArgument(arguments, 0);
            if (argument == null) {
                return null;
            }
            icon = this.getIconFromPackage(fontPackage, family, argument, element.getProject(), sdk, parent);
            if (icon != null) {
                return this.createLineMarker(element, icon);
            }
        } else if (parentNode.getElementType() == DartTokenTypes.SIMPLE_TYPE) {
            if ((parent = DartPsiUtil.getNewExprFromType(parent)) == null) {
                return null;
            }
            arguments = DartPsiImplUtil.getArguments((DartNewExpression)((DartNewExpression)parent));
            if (arguments == null) {
                return null;
            }
            family = DartPsiUtil.getValueOfNamedArgument(arguments, "fontFamily");
            fontPackage = DartPsiUtil.getNamedArgumentExpression(arguments, "fontPackage");
            argument = DartPsiUtil.getValueOfPositionalArgument(arguments, 0);
            if (argument == null) {
                return null;
            }
            icon = this.getIconFromPackage(fontPackage, family, argument, element.getProject(), sdk, parent);
            if (icon != null) {
                return this.createLineMarker(element, icon);
            }
        } else {
            PsiElement idNode = refExpr.getFirstChild();
            if (idNode == null) {
                return null;
            }
            if (name.equals(idNode.getText())) {
                Icon icon;
                PsiElement selectorNode = refExpr.getLastChild();
                if (selectorNode == null) {
                    return null;
                }
                assert (selectorNode.getNode() != null);
                String selector = AstBufferUtil.getTextSkippingWhitespaceComments((ASTNode)selectorNode.getNode());
                if (name.equals("Icons")) {
                    if (sdk.getVersion().canUseDistributedIcons()) {
                        icon = FlutterMaterialIcons.getIconForName(selector);
                    } else {
                        iconDef = this.findStandardDefinition(name, selector, element.getProject(), knownPath, sdk);
                        if (iconDef == null) {
                            return null;
                        }
                        icon = this.findStandardIconFromDef(name, iconDef, sdk.getHomePath() + MaterialRelativeAssetPath);
                    }
                } else if (name.equals("CupertinoIcons")) {
                    if (sdk.getVersion().canUseDistributedIcons()) {
                        icon = FlutterCupertinoIcons.getIconForName(selector);
                    } else {
                        iconDef = this.findStandardDefinition(name, selector, element.getProject(), knownPath, sdk);
                        if (iconDef == null) {
                            return null;
                        }
                        path = FlutterSdkUtil.getPathToCupertinoIconsPackage(element.getProject());
                        icon = this.findStandardIconFromDef(name, iconDef, path + CupertinoRelativeAssetPath);
                    }
                } else {
                    PsiElement iconElement = refExpr.getLastChild();
                    if (iconElement == null) {
                        return null;
                    }
                    String iconName = iconElement.getText();
                    assert (iconName != null);
                    assert (knownPath != null);
                    IconInfo iconDef = this.findDefinition(name, iconName, element.getProject(), knownPath);
                    if (iconDef == null) {
                        return null;
                    }
                    icon = this.findIconFromDef(name, iconDef, knownPath);
                }
                if (icon != null) {
                    return this.createLineMarker(element, icon);
                }
            }
        }
        return null;
    }

    @Nullable
    private IconInfo findStandardDefinition(@NotNull String className, @NotNull String iconName, @NotNull Project project, @Nullable String path, @NotNull FlutterSdk sdk) {
        if (className == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (iconName == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (path != null) {
            return this.findDefinition(className, iconName, project, path);
        }
        assert (Objects.requireNonNull(ApplicationManager.getApplication()).isUnitTestMode());
        return this.findDefinition(className, iconName, project, sdk.getHomePath() + BuiltInPaths.get(className));
    }

    @Nullable
    private Icon findStandardIconFromDef(@NotNull String name, @NotNull IconInfo iconDef, @NotNull String path) {
        if (name == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (iconDef == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(8);
        }
        if (path == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(9);
        }
        assert (LocalFileSystem.getInstance() != null);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile == null) {
            return null;
        }
        IconPreviewGenerator generator = new IconPreviewGenerator(virtualFile.getPath());
        return generator.convert(iconDef.codepoint);
    }

    @Nullable
    private Icon getIconFromPackage(@Nullable PsiElement aPackage, @Nullable String family, @NotNull String argument, @NotNull Project project, @NotNull FlutterSdk sdk, @NotNull PsiElement parent) {
        int code;
        if (argument == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(10);
        }
        if (project == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(11);
        }
        if (sdk == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(12);
        }
        if (parent == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(13);
        }
        try {
            code = DartPsiUtil.parseLiteralNumber(argument);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        if (family == null) {
            family = "MaterialIcons";
        } else if (family.isEmpty()) {
            PsiElement parent2 = parent.getParent();
            if (parent2 == null) {
                return null;
            }
            PsiElement varDecl = parent2.getParent();
            if (varDecl == null) {
                return null;
            }
            ASTNode node = varDecl.getNode();
            if (node == null) {
                return null;
            }
            ASTNode firstChild = node.getFirstChildNode();
            if (firstChild == null) {
                return null;
            }
            ASTNode lastChild = firstChild.getLastChildNode();
            if (lastChild == null) {
                return null;
            }
            String iconName = lastChild.getFirstChildNode().getText();
            IconInfo iconDef = this.findDefinition("", iconName, project, parent.getContainingFile().getVirtualFile().getPath());
            if (iconDef == null) {
                return null;
            }
            family = iconDef.familyName;
            if (family == null) {
                return null;
            }
            aPackage = null;
        }
        if (aPackage == null) {
            String relativeAssetPath = family.equals("MaterialIcons") ? MaterialRelativeAssetPath : CupertinoRelativeAssetPath;
            String base = this.getBasePathForFamily(family, sdk, project);
            if (base == null) {
                return null;
            }
            IconPreviewGenerator generator = new IconPreviewGenerator(base + relativeAssetPath);
            return generator.convert(code);
        }
        return null;
    }

    @Nullable
    private String getBasePathForFamily(@NotNull String family, @NotNull FlutterSdk sdk, @NotNull Project project) {
        if (family == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(14);
        }
        if (sdk == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(15);
        }
        if (project == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(16);
        }
        if (family.equals("MaterialIcons")) {
            return sdk.getHomePath();
        }
        return FlutterSdkUtil.getPathToCupertinoIconsPackage(project);
    }

    @Nullable
    private LineMarkerInfo<PsiElement> createLineMarker(@Nullable PsiElement element, @NotNull Icon icon) {
        if (icon == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(17);
        }
        if (element == null) {
            return null;
        }
        assert (element.getTextRange() != null);
        return new LineMarkerInfo(element, element.getTextRange(), icon, null, null, GutterIconRenderer.Alignment.LEFT, () -> "");
    }

    @Nullable
    private IconInfo findDefinition(@NotNull String className, @NotNull String iconName, @NotNull Project project, @NotNull String path) {
        if (className == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(18);
        }
        if (iconName == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(19);
        }
        if (project == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(20);
        }
        if (path == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(21);
        }
        assert (LocalFileSystem.getInstance() != null);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        IconInfoVisitor visitor = new IconInfoVisitor(iconName);
        psiFile.accept((PsiElementVisitor)visitor);
        return visitor.info;
    }

    @Nullable
    private Icon findIconFromDef(@NotNull String iconClassName, @NotNull IconInfo iconDef, @NotNull String path) {
        IconPreviewGenerator generator;
        Icon icon;
        VirtualFile parent;
        if (iconClassName == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(22);
        }
        if (iconDef == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(23);
        }
        if (path == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(24);
        }
        assert (LocalFileSystem.getInstance() != null);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile == null) {
            return null;
        }
        for (parent = virtualFile; parent != null && !parent.getName().equals("lib"); parent = parent.getParent()) {
        }
        if (parent != null) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return null;
        }
        final ArrayList ttfFiles = new ArrayList();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)parent, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                String ext;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("ttf".equals(ext = file.getExtension())) {
                    ttfFiles.add(file);
                    return false;
                }
                return super.visitFile(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "io/flutter/editor/FlutterIconLineMarkerProvider$1", "visitFile"));
            }
        });
        double match = -1.0;
        String family = iconDef.familyName;
        VirtualFile bestFileMatch = null;
        if (family != null) {
            for (VirtualFile file : ttfFiles) {
                assert (file != null);
                double n = this.findPattern(file.getNameWithoutExtension(), family);
                if (!(n > match)) continue;
                match = n;
                bestFileMatch = file;
            }
        }
        if (bestFileMatch != null && (icon = (generator = new IconPreviewGenerator(bestFileMatch.getPath())).convert(iconDef.codepoint)) != null) {
            return icon;
        }
        for (VirtualFile file : ttfFiles) {
            assert (file != null);
            IconPreviewGenerator generator2 = new IconPreviewGenerator(file.getPath());
            Icon icon2 = generator2.convert(iconDef.codepoint);
            if (icon2 == null) continue;
            return icon2;
        }
        return null;
    }

    public double findPattern(@NotNull String t, @NotNull String p) {
        if (t == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(25);
        }
        if (p == null) {
            FlutterIconLineMarkerProvider.$$$reportNull$$$0(26);
        }
        JaroWinkler jw = new JaroWinkler();
        return jw.similarity(t, p);
    }

    static {
        FlutterIconLineMarkerProvider.initialize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconName";
                break;
            }
            case 5: 
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconDef";
                break;
            }
            case 9: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconClassName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        objectArray2[1] = "io/flutter/editor/FlutterIconLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findStandardDefinition";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findStandardIconFromDef";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getIconFromPackage";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getBasePathForFamily";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "createLineMarker";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "findDefinition";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "findIconFromDef";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "findPattern";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class IconInfo {
        @NotNull
        final String iconName;
        @NotNull
        final String className;
        @Nullable
        final String familyName;
        @NotNull
        final String codepoint;

        IconInfo(@NotNull String className, @NotNull String iconName, @Nullable String familyName, @NotNull String codepoint) {
            if (className == null) {
                IconInfo.$$$reportNull$$$0(0);
            }
            if (iconName == null) {
                IconInfo.$$$reportNull$$$0(1);
            }
            if (codepoint == null) {
                IconInfo.$$$reportNull$$$0(2);
            }
            this.className = className;
            this.iconName = iconName;
            this.familyName = familyName;
            this.codepoint = codepoint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "className";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "iconName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "codepoint";
                    break;
                }
            }
            objectArray[1] = "io/flutter/editor/FlutterIconLineMarkerProvider$IconInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class IconInfoVisitor
    extends DartRecursiveVisitor {
        final HashMap<String, String> staticVars = new HashMap();
        final String iconName;
        IconInfo info;

        IconInfoVisitor(String iconName) {
            this.iconName = iconName;
        }

        @Nullable
        private String findFamilyName(@Nullable PsiElement expression, @Nullable DartType type) {
            if (expression == null && type != null) {
                LOG.info("Check superclass constructor for font family: " + type.getName());
                return null;
            }
            if (expression instanceof DartStringLiteralExpression) {
                Pair pair = DartPsiImplUtil.getUnquotedDartStringAndItsRange((String)expression.getText().trim());
                return (String)pair.first;
            }
            if (expression != null) {
                assert (expression.getNode() != null);
                if (expression.getNode().getElementType() == DartTokenTypes.REFERENCE_EXPRESSION) {
                    assert (expression.getText() != null);
                    Pair pair = DartPsiImplUtil.getUnquotedDartStringAndItsRange((String)expression.getText().trim());
                    String varName = (String)pair.first;
                    return this.staticVars.get(varName);
                }
            }
            return null;
        }

        public void visitVarAccessDeclaration(@NotNull DartVarAccessDeclaration o) {
            if (o == null) {
                IconInfoVisitor.$$$reportNull$$$0(0);
            }
            if (Objects.requireNonNull(o.getComponentName().getText()).trim().equals(this.iconName)) {
                List list;
                DartArgumentList argumentList;
                assert (o.getParent() != null);
                DartVarInit init = (DartVarInit)o.getParent().getLastChild();
                assert (init != null);
                DartExpression expression = init.getExpression();
                String className = null;
                DartArguments arguments = null;
                DartType type = null;
                if (expression instanceof DartNewExpression) {
                    DartNewExpression newExpr = (DartNewExpression)expression;
                    type = newExpr.getType();
                    if (type != null) {
                        className = type.getText();
                        arguments = newExpr.getArguments();
                    }
                } else if (expression instanceof DartCallExpression) {
                    DartCallExpressionImpl callExpr = (DartCallExpressionImpl)expression;
                    arguments = callExpr.getArguments();
                    className = callExpr.getExpression().getText();
                }
                if (KnownPaths.containsKey(className) && arguments != null && (argumentList = arguments.getArgumentList()) != null && !(list = argumentList.getExpressionList()).isEmpty()) {
                    DartExpression dartExpression = (DartExpression)list.get(0);
                    assert (dartExpression != null);
                    String codepoint = dartExpression.getText();
                    PsiElement family = DartPsiUtil.getNamedArgumentExpression(arguments, "fontFamily");
                    String familyName = this.findFamilyName(family, type);
                    assert (className != null);
                    assert (codepoint != null);
                    this.info = new IconInfo(className, this.iconName, familyName, codepoint);
                }
            } else {
                PsiElement firstChild = o.getFirstChild();
                assert (firstChild != null);
                assert (firstChild.getText() != null);
                if (firstChild.getText().trim().equals("static")) {
                    String varName = Objects.requireNonNull(o.getComponentName().getText()).trim();
                    assert (o.getParent() != null);
                    DartVarInit init = (DartVarInit)o.getParent().getLastChild();
                    assert (init != null);
                    DartExpression expression = init.getExpression();
                    if (expression instanceof DartStringLiteralExpression) {
                        assert (expression.getText() != null);
                        Pair pair = DartPsiImplUtil.getUnquotedDartStringAndItsRange((String)expression.getText());
                        this.staticVars.put(varName, (String)pair.first);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "io/flutter/editor/FlutterIconLineMarkerProvider$IconInfoVisitor", "visitVarAccessDeclaration"));
        }
    }
}

