/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import io.flutter.FlutterUtils;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Icon;

public class FlutterMaterialIcons {
    private static final Logger LOG = Logger.getInstance(FlutterMaterialIcons.class);
    private static final Properties icons = new Properties();

    public static Icon getIconForHex(String hexValue) {
        String iconName = icons.getProperty(hexValue + ".codepoint");
        return FlutterMaterialIcons.getIcon(iconName);
    }

    public static Icon getIconForName(String name) {
        return FlutterMaterialIcons.getIcon(name);
    }

    private static Icon getIcon(String name) {
        if (name == null) {
            return null;
        }
        String path = icons.getProperty(name);
        if (path == null) {
            return null;
        }
        return IconLoader.findIcon((String)("/flutter/icons/" + path), FlutterMaterialIcons.class);
    }

    static {
        try {
            icons.load(FlutterMaterialIcons.class.getResourceAsStream("/flutter/icons/material.properties"));
        }
        catch (IOException e) {
            FlutterUtils.warn(LOG, e);
        }
    }
}

