/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import icons.FlutterIcons;
import io.flutter.FlutterUtils;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.pub.PubRoot;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.UIUtils;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterPubspecNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"flutter.pubspec");

    public FlutterPubspecNotificationProvider(@NotNull Project project) {
        if (project == null) {
            FlutterPubspecNotificationProvider.$$$reportNull$$$0(0);
        }
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            FlutterPubspecNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            FlutterPubspecNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            FlutterPubspecNotificationProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            FlutterPubspecNotificationProvider.$$$reportNull$$$0(4);
        }
        if (!PubRoot.isPubspec(file) || !file.isInLocalFileSystem()) {
            return null;
        }
        if (WorkspaceCache.getInstance(project).isBazel()) {
            return null;
        }
        if (!FlutterUtils.declaresFlutter(file)) {
            return null;
        }
        if (FlutterSdk.getFlutterSdk(project) == null) {
            return null;
        }
        return new FlutterPubspecActionsPanel(project, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/editor/FlutterPubspecNotificationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/editor/FlutterPubspecNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    static class FlutterPubspecActionsPanel
    extends EditorNotificationPanel {
        @NotNull
        final Project project;
        @NotNull
        final VirtualFile myFile;

        FlutterPubspecActionsPanel(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                FlutterPubspecActionsPanel.$$$reportNull$$$0(0);
            }
            if (file == null) {
                FlutterPubspecActionsPanel.$$$reportNull$$$0(1);
            }
            super(UIUtils.getEditorNotificationBackgroundColor());
            this.project = project;
            this.myFile = file;
            this.icon(FlutterIcons.Flutter);
            this.text("Flutter commands");
            HyperlinkLabel label = this.createActionLabel("Pub get", () -> this.runPubGet(false));
            label.setToolTipText("Install referenced packages");
            label = this.createActionLabel("Pub upgrade", () -> this.runPubGet(true));
            label.setToolTipText("Upgrade referenced packages to the latest versions");
            FlutterSdk sdk = FlutterSdk.getFlutterSdk(project);
            if (sdk != null && sdk.getVersion().isPubOutdatedSupported()) {
                label = this.createActionLabel("Pub outdated", this::runPubOutdated);
                label.setToolTipText("Analyze packages to determine which ones can be upgraded");
            }
            this.myLinksPanel.add(new JSeparator(1));
            label = this.createActionLabel("Flutter doctor", "flutter.doctor");
            label.setToolTipText("Validate installed tools and their versions");
        }

        private void runPubGet(boolean upgrade) {
            FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.project);
            if (sdk == null) {
                return;
            }
            PubRoot root = PubRoot.forDirectory(this.myFile.getParent());
            if (root != null) {
                if (!upgrade) {
                    sdk.startPubGet(root, this.project);
                } else {
                    sdk.startPubUpgrade(root, this.project);
                }
            }
        }

        private void runPubOutdated() {
            FlutterSdk sdk = FlutterSdk.getFlutterSdk(this.project);
            if (sdk == null) {
                return;
            }
            PubRoot root = PubRoot.forDirectory(this.myFile.getParent());
            if (root != null) {
                sdk.startPubOutdated(root, this.project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "io/flutter/editor/FlutterPubspecNotificationProvider$FlutterPubspecActionsPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

