/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.AppTopics;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.AssistUtils;
import io.flutter.FlutterUtils;
import io.flutter.dart.DartPlugin;
import io.flutter.settings.FlutterSettings;
import java.util.Collections;
import java.util.List;
import org.dartlang.analysis.server.protocol.SourceEdit;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterSaveActionsManager {
    private static final Logger LOG = Logger.getInstance(FlutterSaveActionsManager.class);
    @NotNull
    private final Project myProject;

    public static void init(@NotNull Project project) {
        if (project == null) {
            FlutterSaveActionsManager.$$$reportNull$$$0(0);
        }
        FlutterSaveActionsManager.getInstance(project);
    }

    @Nullable
    public static FlutterSaveActionsManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterSaveActionsManager.$$$reportNull$$$0(1);
        }
        return (FlutterSaveActionsManager)project.getService(FlutterSaveActionsManager.class);
    }

    private FlutterSaveActionsManager(@NotNull Project project) {
        if (project == null) {
            FlutterSaveActionsManager.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        MessageBus bus = project.getMessageBus();
        MessageBusConnection connection = bus.connect();
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void beforeDocumentSaving(@NotNull Document document) {
                if (document == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!document.isWritable()) {
                    return;
                }
                FlutterSaveActionsManager.this.handleBeforeDocumentSaving(document);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "io/flutter/editor/FlutterSaveActionsManager$1", "beforeDocumentSaving"));
            }
        });
    }

    private void handleBeforeDocumentSaving(@NotNull Document document) {
        FlutterSettings settings;
        if (document == null) {
            FlutterSaveActionsManager.$$$reportNull$$$0(3);
        }
        if (!(settings = FlutterSettings.getInstance()).isFormatCodeOnSave()) {
            return;
        }
        if (!this.myProject.isInitialized() || this.myProject.isDisposed()) {
            return;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file == null) {
            return;
        }
        if (!FlutterUtils.isDartFile(file)) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (psiFile == null || !psiFile.isValid()) {
            return;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            return;
        }
        if (!DartPlugin.isDartSdkEnabled(module)) {
            return;
        }
        if (PsiErrorElementUtil.hasErrors((Project)this.myProject, (VirtualFile)psiFile.getVirtualFile())) {
            return;
        }
        if (DartAnalysisServerService.getInstance((Project)this.myProject).serverReadyForRequest()) {
            if (settings.isOrganizeImportsOnSave()) {
                this.performOrganizeThenFormat(document, file, psiFile);
            } else {
                this.performFormat(document, file, false, psiFile);
            }
        }
    }

    private void performOrganizeThenFormat(final @NotNull Document document, final @NotNull VirtualFile file, final @NotNull PsiFile psiFile) {
        if (document == null) {
            FlutterSaveActionsManager.$$$reportNull$$$0(4);
        }
        if (file == null) {
            FlutterSaveActionsManager.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            FlutterSaveActionsManager.$$$reportNull$$$0(6);
        }
        String filePath = file.getPath();
        final SourceFileEdit fileEdit = DartAnalysisServerService.getInstance((Project)this.myProject).edit_organizeDirectives(filePath);
        if (fileEdit != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

                    protected void run() {
                        if (FlutterSaveActionsManager.this.myProject.isDisposed()) {
                            return;
                        }
                        AssistUtils.applySourceEdits((Project)FlutterSaveActionsManager.this.myProject, (VirtualFile)file, (Document)document, (List)fileEdit.getEdits(), Collections.emptySet());
                        PsiDocumentManager.getInstance((Project)FlutterSaveActionsManager.this.myProject).commitDocument(document);
                        ApplicationManager.getApplication().invokeLater(() -> FlutterSaveActionsManager.this.performFormat(document, file, true, psiFile));
                    }
                }.execute();
            });
        }
    }

    private void performFormat(final @NotNull Document document, @NotNull VirtualFile file, final boolean reSave, @NotNull PsiFile psiFile) {
        if (document == null) {
            FlutterSaveActionsManager.$$$reportNull$$$0(7);
        }
        if (file == null) {
            FlutterSaveActionsManager.$$$reportNull$$$0(8);
        }
        if (psiFile == null) {
            FlutterSaveActionsManager.$$$reportNull$$$0(9);
        }
        int lineLength = FlutterSaveActionsManager.getRightMargin(psiFile);
        DartAnalysisServerService das = DartAnalysisServerService.getInstance((Project)this.myProject);
        das.updateFilesContent();
        final DartAnalysisServerService.FormatResult formatResult = das.edit_format(file, 0, 0, lineLength);
        if (formatResult == null) {
            if (reSave) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            new WriteCommandAction.Simple(this.myProject, new PsiFile[0]){

                protected void run() {
                    if (FlutterSaveActionsManager.this.myProject.isDisposed()) {
                        return;
                    }
                    boolean didFormat = false;
                    List edits = formatResult.getEdits();
                    if (edits != null && edits.size() == 1) {
                        String replacement = StringUtil.convertLineSeparators((String)((SourceEdit)edits.get(0)).getReplacement());
                        document.replaceString(0, document.getTextLength(), (CharSequence)replacement);
                        PsiDocumentManager.getInstance((Project)FlutterSaveActionsManager.this.myProject).commitDocument(document);
                        didFormat = true;
                    }
                    if (reSave || didFormat) {
                        ApplicationManager.getApplication().invokeLater(() -> FileDocumentManager.getInstance().saveDocument(document));
                    }
                }
            }.execute();
        });
    }

    private static int getRightMargin(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            FlutterSaveActionsManager.$$$reportNull$$$0(10);
        }
        return CodeStyle.getLanguageSettings((PsiFile)psiFile, (Language)DartLanguage.INSTANCE).RIGHT_MARGIN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "io/flutter/editor/FlutterSaveActionsManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBeforeDocumentSaving";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "performOrganizeThenFormat";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "performFormat";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getRightMargin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

