/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import io.flutter.editor.EditorPositionService;
import io.flutter.editor.InlineWidgetViewModelData;
import io.flutter.editor.PreviewViewControllerBase;
import io.flutter.editor.PropertyEditorPanel;
import io.flutter.editor.WidgetIndentGuideDescriptor;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.InspectorService;
import io.flutter.inspector.Screenshot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlinePreviewViewController
extends PreviewViewControllerBase
implements CustomHighlighterRenderer {
    protected float previewWidthScale = 0.7f;

    public InlinePreviewViewController(InlineWidgetViewModelData data, boolean drawBackground, Disposable disposable) {
        super(data, drawBackground, disposable);
        data.context.editorPositionService.addListener(this.getEditor(), new EditorPositionService.Listener(){

            @Override
            public void updateVisibleArea(Rectangle newRectangle) {
                InlinePreviewViewController.this.updateVisibleArea(newRectangle);
            }

            @Override
            public void onVisibleChanged() {
                InlinePreviewViewController.this.onVisibleChanged();
            }
        }, (Disposable)this);
    }

    InlineWidgetViewModelData getData() {
        return (InlineWidgetViewModelData)this.data;
    }

    protected EditorEx getEditor() {
        return this.getData().editor;
    }

    public Point offsetToPoint(int offset) {
        return this.getEditor().visualPositionToXY(this.getEditor().offsetToVisualPosition(offset));
    }

    @Override
    public void forceRender() {
        if (!this.visible) {
            return;
        }
        this.getEditor().getComponent().repaint();
    }

    @Override
    InspectorService.Location getLocation() {
        WidgetIndentGuideDescriptor descriptor = this.getDescriptor();
        if (descriptor == null || descriptor.widget == null) {
            return null;
        }
        return InspectorService.Location.outlineToLocation((Editor)this.getEditor(), descriptor.outlineNode);
    }

    public WidgetIndentGuideDescriptor getDescriptor() {
        return this.getData().descriptor;
    }

    @Override
    public void computeScreenshotBounds() {
        Document doc;
        int textLength;
        Rectangle previousScreenshotBounds = this.screenshotBounds;
        this.screenshotBounds = null;
        this.maxHeight = Math.round(83.2f);
        WidgetIndentGuideDescriptor descriptor = this.getDescriptor();
        int lineHeight = this.getEditor() != null ? this.getEditor().getLineHeight() : 20;
        this.extraHeight = descriptor != null && this.screenshot != null ? lineHeight : 0;
        Rectangle visibleRect = this.visibleRect;
        if (visibleRect == null) {
            return;
        }
        if (descriptor == null) {
            Screenshot latestScreenshot = this.getScreenshotNow();
            int previewWidth = Math.round(280.0f * this.previewWidthScale);
            int previewHeight = Math.round(83.2f * this.previewWidthScale);
            if (latestScreenshot != null) {
                previewWidth = (int)((double)latestScreenshot.image.getWidth() / this.getDPI());
                previewHeight = (int)((double)latestScreenshot.image.getHeight() / this.getDPI());
            }
            int previewStartX = Math.max(0, visibleRect.x + visibleRect.width - previewWidth - 20);
            previewHeight = Math.min(previewHeight, visibleRect.height);
            this.maxHeight = visibleRect.height;
            int previewStartY = Math.max(visibleRect.y, visibleRect.y + visibleRect.height - previewHeight);
            this.screenshotBounds = new Rectangle(previewStartX, previewStartY, previewWidth, previewHeight);
            return;
        }
        TextRange marker = this.getData().getMarker();
        if (marker == null) {
            return;
        }
        int startOffset = marker.getStartOffset();
        if (startOffset >= (textLength = (doc = this.getData().document).getTextLength())) {
            return;
        }
        int endOffset = Math.min(marker.getEndOffset(), textLength);
        int startLine = doc.getLineNumber(startOffset);
        int widgetOffset = this.getDescriptor().widget.getGuideOffset();
        int widgetLine = doc.getLineNumber(widgetOffset);
        int lineEndOffset = doc.getLineEndOffset(widgetLine);
        VisualPosition visualPosition = this.getEditor().offsetToVisualPosition(lineEndOffset);
        visualPosition = new VisualPosition(Math.max(visualPosition.line, 0), 81);
        Point start = this.getEditor().visualPositionToXY(visualPosition);
        Point endz = this.offsetToPoint(endOffset);
        int endY = endz.y;
        int visibleEndX = visibleRect.x + visibleRect.width;
        int width = Math.max(0, visibleEndX - 20 - start.x);
        int height = Math.max(0, endY - start.y);
        int previewStartY = start.y;
        int previewStartX = start.x;
        int visibleStart = visibleRect.y;
        int visibleEnd = (int)visibleRect.getMaxY();
        Screenshot latestScreenshot = this.getScreenshotNow();
        int previewWidth = 280;
        int previewHeight = 86;
        if (latestScreenshot != null) {
            previewWidth = (int)((double)latestScreenshot.image.getWidth() / this.getDPI());
            previewHeight = (int)((double)latestScreenshot.image.getHeight() / this.getDPI());
        }
        previewStartX = Math.max(previewStartX, visibleEndX - previewWidth - 20);
        previewHeight += this.extraHeight;
        previewHeight = Math.min(previewHeight, height);
        this.maxHeight = endz.y - start.y;
        if (this.popupActive()) {
            this.screenshotBounds = new Rectangle(this.lastScreenshotBoundsWindow);
            this.screenshotBounds.translate(visibleRect.x, visibleRect.y);
        } else {
            boolean lockUpdate = false;
            if (this.isVisiblityLocked() && previousScreenshotBounds != null && visibleRect.contains(previousScreenshotBounds)) {
                this.screenshotBounds = new Rectangle(previousScreenshotBounds);
                if (previewWidth != this.screenshotBounds.width) {
                    this.screenshotBounds.x += this.screenshotBounds.width - previewWidth;
                    this.screenshotBounds.width = previewWidth;
                }
                this.screenshotBounds.height = previewHeight;
                this.lastScreenshotBoundsWindow = new Rectangle(this.screenshotBounds);
                this.lastScreenshotBoundsWindow.translate(-visibleRect.x, -visibleRect.y);
                lockUpdate = true;
            }
            if (!lockUpdate) {
                this.lastLockedRectangle = null;
                if (start.y <= visibleEnd && endY >= visibleStart) {
                    if (visibleStart > previewStartY) {
                        previewStartY = Math.max(previewStartY, visibleStart);
                        previewStartY = Math.min(previewStartY, Math.min(endY - previewHeight, visibleEnd - previewHeight));
                    }
                    this.screenshotBounds = new Rectangle(previewStartX, previewStartY, previewWidth, previewHeight);
                    this.lastScreenshotBoundsWindow = new Rectangle(this.screenshotBounds);
                    this.lastScreenshotBoundsWindow.translate(-visibleRect.x, -visibleRect.y);
                }
            }
        }
        if (this.popupActive()) {
            this.lastLockedRectangle = new Rectangle(visibleRect);
        }
    }

    @Override
    protected Dimension getPreviewSize() {
        int previewWidth = 280;
        int previewHeight = 520;
        if (this.getDescriptor() == null) {
            previewWidth = Math.round((float)previewWidth * this.previewWidthScale);
            previewHeight = Math.round((float)previewHeight * this.previewWidthScale);
        }
        return new Dimension(previewWidth, previewHeight);
    }

    private void updateVisibleArea(Rectangle newRectangle) {
        boolean nowVisible;
        this.visibleRect = newRectangle;
        if (this.getDescriptor() == null || this.getData().getMarker() == null) {
            if (!this.visible) {
                this.visible = true;
                this.onVisibleChanged();
            }
            return;
        }
        TextRange marker = this.getData().getMarker();
        if (marker == null) {
            return;
        }
        Point start = this.offsetToPoint(marker.getStartOffset());
        Point end = this.offsetToPoint(marker.getEndOffset());
        boolean bl = nowVisible = newRectangle == null || newRectangle.y <= end.y && newRectangle.y + newRectangle.height >= start.y || this.updateVisiblityLocked(newRectangle);
        if (this.visible != nowVisible) {
            this.visible = nowVisible;
            this.onVisibleChanged();
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    protected Component getComponent() {
        return this.getEditor().getComponent();
    }

    @Override
    protected VirtualFile getVirtualFile() {
        return this.getEditor().getVirtualFile();
    }

    @Override
    protected Document getDocument() {
        return this.getEditor().getDocument();
    }

    @Override
    protected void showPopup(Point location, DiagnosticsNode node) {
        location = SwingUtilities.convertPoint(this.getEditor().getContentComponent(), location, this.getEditor().getComponent());
        this.popup = PropertyEditorPanel.showPopup(this.data.context.inspectorGroupManagerService, this.getEditor(), node, node.getCreationLocation().getLocation(), this.data.context.flutterDartAnalysisService, location);
    }

    @Override
    TextRange getActiveRange() {
        return this.getData().getMarker();
    }

    @Override
    void setCustomCursor(@Nullable Cursor cursor) {
        if (this.getEditor() == null) {
            return;
        }
        this.getEditor().setCustomCursor((Object)this, cursor);
    }

    public int getPriority() {
        int priority = 0;
        if (this.popupActive()) {
            priority += 20;
        }
        if (this.isVisiblityLocked()) {
            priority += 10;
        }
        if (this.isSelected) {
            priority += 5;
        }
        if (this.getDescriptor() != null) {
            ++priority;
        }
        if (this.screenshot == null && (this.elements == null || this.elements.isEmpty())) {
            priority -= 5;
            if (this.getDescriptor() != null) {
                priority -= 100;
            }
        } else if (this.hasCurrentHits() || this._mouseInScreenshot) {
            priority += 10;
        }
        if (this._mouseInScreenshot) {
            priority += 20;
        }
        return priority;
    }

    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        if (editor == null) {
            InlinePreviewViewController.$$$reportNull$$$0(0);
        }
        if (highlighter == null) {
            InlinePreviewViewController.$$$reportNull$$$0(1);
        }
        if (g == null) {
            InlinePreviewViewController.$$$reportNull$$$0(2);
        }
        if (editor != this.getEditor()) {
            return;
        }
        if (this.getEditor().isPurePaintingMode()) {
            return;
        }
        if (!highlighter.isValid()) {
            return;
        }
        if (this.getDescriptor() != null && !this.getDescriptor().widget.isValid()) {
            return;
        }
        int lineHeight = editor.getLineHeight();
        this.paint(g, lineHeight);
    }

    @Override
    public void paint(@NotNull Graphics g, int lineHeight) {
        if (g == null) {
            InlinePreviewViewController.$$$reportNull$$$0(3);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        Screenshot latestScreenshot = this.getScreenshotNow();
        if (latestScreenshot != null) {
            int imageWidth = (int)((double)latestScreenshot.image.getWidth() * this.getDPI());
            int imageHeight = (int)((double)latestScreenshot.image.getHeight() * this.getDPI());
            if (this.extraHeight > 0) {
                WidgetIndentGuideDescriptor descriptor;
                if (this.drawBackground) {
                    g2d.setColor((Color)JBColor.LIGHT_GRAY);
                    g2d.fillRect(this.screenshotBounds.x, this.screenshotBounds.y, Math.min(this.screenshotBounds.width, imageWidth), Math.min(this.screenshotBounds.height, this.extraHeight));
                }
                if ((descriptor = this.getDescriptor()) != null) {
                    int line = descriptor.widget.getLine() + 1;
                    int column = descriptor.widget.getColumn() + 1;
                    int numActive = this.elements != null ? this.elements.size() : 0;
                    String message = descriptor.outlineNode.getClassName() + " ";
                    if (numActive == 0) {
                        message = message + "(inactive)";
                    } else if (numActive > 1) {
                        message = message + "(" + (this.activeIndex + 1) + " of " + numActive + ")";
                    }
                    if (numActive > 0 && this.screenshot != null && this.screenshot.transformedRect != null) {
                        Rectangle2D bounds = this.screenshot.transformedRect.getRectangle();
                        long w = Math.round(bounds.getWidth());
                        long h = Math.round(bounds.getHeight());
                        message = message + " " + w + "x" + h;
                    }
                    g2d.setColor((Color)JBColor.BLACK);
                    this.drawMultilineString(g2d, message, this.screenshotBounds.x + 4, this.screenshotBounds.y + lineHeight - 6, lineHeight);
                }
            }
        }
        super.paint(g, lineHeight);
    }

    @Override
    String getNoScreenshotMessage() {
        WidgetIndentGuideDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return super.getNoScreenshotMessage();
        }
        int line = descriptor.widget.getLine() + 1;
        int column = descriptor.widget.getColumn() + 1;
        return descriptor.outlineNode.getClassName() + " Widget " + line + ":" + column + "\nnot currently active";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "highlighter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "g";
                break;
            }
        }
        objectArray[1] = "io/flutter/editor/InlinePreviewViewController";
        objectArray[2] = "paint";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

