/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.utils.UIUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeEditorNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"flutter.native.editor.notification");
    private final Project project;
    private boolean showNotification;

    public NativeEditorNotificationProvider(@NotNull Project project) {
        if (project == null) {
            NativeEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        this.showNotification = true;
        this.project = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            NativeEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            NativeEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            NativeEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            NativeEditorNotificationProvider.$$$reportNull$$$0(4);
        }
        if (!file.isInLocalFileSystem() || !this.showNotification) {
            return null;
        }
        return this.createPanelForFile(file, NativeEditorNotificationProvider.findRootDir(file, project.getBaseDir()));
    }

    private EditorNotificationPanel createPanelForFile(VirtualFile file, VirtualFile root) {
        if (root == null) {
            return null;
        }
        return this.createPanelForAction(file, root, NativeEditorNotificationProvider.getActionName(root));
    }

    private EditorNotificationPanel createPanelForAction(VirtualFile file, VirtualFile root, String actionName) {
        if (actionName == null) {
            return null;
        }
        NativeEditorActionsPanel panel2 = new NativeEditorActionsPanel(file, root, actionName);
        return panel2.isValidForFile() ? panel2 : null;
    }

    private static String getActionName(VirtualFile root) {
        if (root == null) {
            return null;
        }
        if (root.getName().equals("android")) {
            return "flutter.androidstudio.open";
        }
        if (root.getName().equals("ios")) {
            return "flutter.xcode.open";
        }
        if (root.getName().equals("macos")) {
            return "flutter.xcode.open";
        }
        return null;
    }

    @Nullable
    private static VirtualFile findRootDir(@NotNull VirtualFile file, @Nullable VirtualFile projectDir) {
        if (file == null) {
            NativeEditorNotificationProvider.$$$reportNull$$$0(5);
        }
        if (projectDir == null) {
            return null;
        }
        VirtualFile parent = file.getParent();
        if (projectDir.equals(parent)) {
            return null;
        }
        VirtualFile root = parent;
        while (parent != null) {
            if (projectDir.equals(parent = parent.getParent())) {
                return root;
            }
            root = parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/editor/NativeEditorNotificationProvider";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/editor/NativeEditorNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findRootDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    class NativeEditorActionsPanel
    extends EditorNotificationPanel {
        final VirtualFile myFile;
        final VirtualFile myRoot;
        final AnAction myAction;
        final boolean isVisible;

        NativeEditorActionsPanel(VirtualFile file, VirtualFile root, String actionName) {
            super(UIUtils.getEditorNotificationBackgroundColor());
            this.myFile = file;
            this.myRoot = root;
            this.myAction = ActionManager.getInstance().getAction(actionName);
            this.icon(FlutterIcons.Flutter);
            this.text("Flutter commands");
            this.myAction.update(AnActionEvent.createFromDataContext((String)"EditorToolbar", (Presentation)this.myAction.getTemplatePresentation(), (DataContext)this.makeContext()));
            this.isVisible = this.myAction.getTemplatePresentation().isVisible();
            this.createActionLabel(this.myAction.getTemplatePresentation().getText(), this::performAction).setToolTipText(this.myAction.getTemplatePresentation().getDescription());
            this.createActionLabel(FlutterBundle.message("flutter.androidstudio.open.hide.notification.text", new Object[0]), () -> {
                NativeEditorNotificationProvider.this.showNotification = false;
                EditorNotifications.getInstance((Project)NativeEditorNotificationProvider.this.project).updateAllNotifications();
            }).setToolTipText(FlutterBundle.message("flutter.androidstudio.open.hide.notification.description", new Object[0]));
        }

        private boolean isValidForFile() {
            if (this.isVisible) {
                return FileUtil.isAncestor((String)this.myRoot.getPath(), (String)this.myFile.getPath(), (boolean)true);
            }
            return false;
        }

        private void performAction() {
            this.myAction.actionPerformed(AnActionEvent.createFromDataContext((String)"EditorToolbar", (Presentation)this.myAction.getTemplatePresentation(), (DataContext)this.makeContext()));
        }

        private DataContext makeContext() {
            return dataId -> {
                if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                    return this.myFile;
                }
                if (CommonDataKeys.PROJECT.is(dataId)) {
                    return NativeEditorNotificationProvider.this.project;
                }
                return null;
            };
        }
    }
}

