/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.editor.TextRangeTracker;
import io.flutter.editor.WidgetIndentsHighlightingPass;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.Nullable;

public class OutlineLocation
implements Comparable<OutlineLocation> {
    private final int line;
    private final int column;
    private final int indent;
    private final int offset;
    private final TextRangeTracker guideTracker;
    private final TextRangeTracker fullTracker;
    @Nullable
    private String nodeStartingWord;
    private Document document;

    public OutlineLocation(FlutterOutline node, int line, int column, int indent, VirtualFile file, WidgetIndentsHighlightingPass pass) {
        this.line = line;
        this.column = column;
        assert (indent >= 0);
        assert (column >= 0);
        assert (column >= indent);
        assert (line >= 0);
        this.indent = indent;
        int nodeOffset = pass.getConvertedOffset(node);
        int endOffset = pass.getConvertedOffset(node.getOffset() + node.getLength());
        this.fullTracker = new TextRangeTracker(nodeOffset, endOffset);
        int delta = Math.max(column - indent, 0);
        this.offset = Math.max(nodeOffset - delta, 0);
        this.guideTracker = new TextRangeTracker(this.offset, nodeOffset + 1);
    }

    public void dispose() {
        if (this.guideTracker != null) {
            this.guideTracker.dispose();
        }
        if (this.fullTracker != null) {
            this.fullTracker.dispose();
        }
    }

    public void track(Document document) {
        this.document = document;
        assert (this.indent <= this.column);
        this.fullTracker.track(document);
        this.guideTracker.track(document);
    }

    public int hashCode() {
        int hashCode = this.line;
        hashCode = hashCode * 31 + this.column;
        hashCode = hashCode * 31 + this.indent;
        hashCode = hashCode * 31 + this.offset;
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OutlineLocation)) {
            return false;
        }
        OutlineLocation other = (OutlineLocation)o;
        return this.line == other.line && this.column == other.column && this.indent == other.indent && this.offset == other.offset && this.getGuideOffset() == other.getGuideOffset();
    }

    public int getGuideOffset() {
        if (this.guideTracker.isTracking() && this.guideTracker.getRange() != null) {
            return this.guideTracker.getRange().getStartOffset();
        }
        return this.offset;
    }

    public boolean isValid() {
        if (!this.guideTracker.isTracking()) {
            return true;
        }
        return this.guideTracker.isConsistentEndingWord();
    }

    public int getLine() {
        if (this.guideTracker.isTracking() && this.guideTracker.getRange() != null) {
            return this.document.getLineNumber(this.guideTracker.getRange().getStartOffset());
        }
        return this.line;
    }

    public int getColumnForOffset(int offset) {
        assert (this.document != null);
        int currentLine = this.document.getLineNumber(offset);
        return offset - this.document.getLineStartOffset(currentLine);
    }

    public int getIndent() {
        if (!this.guideTracker.isTracking()) {
            return this.indent;
        }
        TextRange range = this.guideTracker.getRange();
        assert (range != null);
        return this.getColumnForOffset(range.getStartOffset());
    }

    public int getColumn() {
        if (!this.guideTracker.isTracking()) {
            return this.column;
        }
        TextRange range = this.guideTracker.getRange();
        assert (range != null);
        return this.getColumnForOffset(Math.max(range.getStartOffset(), range.getEndOffset() - 1));
    }

    public TextRange getGuideTextRange() {
        return this.guideTracker.getRange();
    }

    public TextRange getFullRange() {
        return this.fullTracker.getRange();
    }

    @Override
    public int compareTo(OutlineLocation o) {
        int delta = Integer.compare(this.line, o.line);
        if (delta != 0) {
            return delta;
        }
        delta = Integer.compare(this.column, o.column);
        if (delta != 0) {
            return delta;
        }
        return Integer.compare(this.indent, o.indent);
    }
}

