/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.editor.PreviewViewControllerBase;
import io.flutter.editor.PropertyEditorPanel;
import io.flutter.editor.WidgetViewModelData;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.InspectorService;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;

public class PreviewViewController
extends PreviewViewControllerBase {
    Rectangle screenshotBoundsOverride;
    final Component component;

    public PreviewViewController(WidgetViewModelData data, boolean drawBackground, Component component, Disposable parentDisposable) {
        super(data, drawBackground, parentDisposable);
        this.visible = true;
        this.component = component;
    }

    public void setScreenshotBounds(Rectangle bounds) {
        boolean sizeChanged = this.screenshotBounds != null && (this.screenshotBounds.width != bounds.width || this.screenshotBounds.height != bounds.height);
        this.screenshotBoundsOverride = bounds;
        this.screenshotBounds = bounds;
        if (sizeChanged) {
            this.fetchScreenshot(false);
        }
    }

    @Override
    protected Component getComponent() {
        return this.component;
    }

    @Override
    protected VirtualFile getVirtualFile() {
        return null;
    }

    @Override
    protected Document getDocument() {
        return null;
    }

    @Override
    protected void showPopup(Point location, DiagnosticsNode node) {
        this.popup = PropertyEditorPanel.showPopup(this.data.context.inspectorGroupManagerService, this.data.context.project, this.getComponent(), node, node.getCreationLocation().getLocation(), this.data.context.flutterDartAnalysisService, location);
    }

    @Override
    TextRange getActiveRange() {
        return null;
    }

    @Override
    void setCustomCursor(@Nullable Cursor cursor) {
        this.getComponent().setCursor(cursor);
    }

    @Override
    public void computeScreenshotBounds() {
        this.screenshotBounds = this.screenshotBoundsOverride;
    }

    @Override
    protected Dimension getPreviewSize() {
        return this.screenshotBoundsOverride.getSize();
    }

    @Override
    public void forceRender() {
        if (this.component != null) {
            this.component.revalidate();
            this.component.repaint();
        }
    }

    @Override
    InspectorService.Location getLocation() {
        return null;
    }
}

