/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.flutter.editor.FlutterEditorColors;
import io.flutter.editor.WidgetViewController;
import io.flutter.editor.WidgetViewModelData;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.InspectorObjectGroupManager;
import io.flutter.inspector.InspectorService;
import io.flutter.inspector.Screenshot;
import io.flutter.inspector.TransformedRect;
import io.flutter.utils.AsyncRateLimiter;
import io.flutter.utils.math.Matrix4;
import io.flutter.utils.math.Vector3;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PreviewViewControllerBase
extends WidgetViewController {
    public static final boolean ENABLE_POPUP_SUPPORT = false;
    public static final int PREVIEW_PADDING_X = 20;
    public static final double MOUSE_FRAMES_PER_SECOND = 10.0;
    public static final double SCREENSHOT_FRAMES_PER_SECOND = 3.0;
    public static final int PREVIEW_MAX_WIDTH = 280;
    public static final int PREVIEW_MAX_HEIGHT = 520;
    private static final Stroke SOLID_STROKE = new BasicStroke(1.0f);
    private static final Color SHADOW_COLOR = new JBColor(new Color(0, 0, 0, 64), new Color(0, 0, 0, 64));
    protected static final int defaultLineHeight = 20;
    protected final boolean drawBackground;
    protected Balloon popup;
    protected Point lastPoint;
    protected AsyncRateLimiter mouseRateLimiter;
    protected AsyncRateLimiter screenshotRateLimiter;
    protected boolean controlDown;
    protected ArrayList<DiagnosticsNode> currentHits;
    protected InspectorObjectGroupManager hover;
    protected InspectorService.ObjectGroup screenshotGroup;
    protected boolean screenshotDirty = false;
    protected int extraHeight = 0;
    protected boolean screenshotLoading;
    protected boolean popopOpenInProgress;
    protected boolean altDown;
    protected Screenshot screenshot;
    protected ArrayList<DiagnosticsNode> boxes;
    Rectangle relativeRect;
    Rectangle lastLockedRectangle;
    Rectangle screenshotBounds;
    Rectangle lastScreenshotBoundsWindow;
    int maxHeight;
    boolean _mouseInScreenshot = false;

    public PreviewViewControllerBase(WidgetViewModelData data, boolean drawBackground, Disposable parent) {
        super(data, parent);
        this.drawBackground = drawBackground;
    }

    @Override
    public void dispose() {
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
        if (this.hover != null) {
            this.hover.clear(false);
            this.hover = null;
        }
        this.screenshot = null;
        super.dispose();
    }

    AsyncRateLimiter getMouseRateLimiter() {
        if (this.mouseRateLimiter != null) {
            return this.mouseRateLimiter;
        }
        this.mouseRateLimiter = new AsyncRateLimiter(10.0, () -> this.updateMouse(false), this);
        return this.mouseRateLimiter;
    }

    AsyncRateLimiter getScreenshotRateLimiter() {
        if (this.screenshotRateLimiter != null) {
            return this.screenshotRateLimiter;
        }
        this.screenshotRateLimiter = new AsyncRateLimiter(3.0, this::updateScreenshot, this);
        return this.screenshotRateLimiter;
    }

    public InspectorObjectGroupManager getHovers() {
        if (this.hover != null && this.hover.getInspectorService() == this.getInspectorService()) {
            return this.hover;
        }
        if (this.getInspectorService() == null) {
            return null;
        }
        this.hover = new InspectorObjectGroupManager(this.getInspectorService(), "hover");
        return this.hover;
    }

    @Nullable
    public InspectorService.ObjectGroup getScreenshotGroup() {
        if (this.screenshotGroup != null && this.screenshotGroup.getInspectorService() == this.getInspectorService()) {
            return this.screenshotGroup;
        }
        if (this.getInspectorService() == null) {
            return null;
        }
        this.screenshotGroup = this.getInspectorService().createObjectGroup("screenshot");
        return this.screenshotGroup;
    }

    protected double getDPI() {
        return JBUI.pixScale((Component)this.getComponent());
    }

    protected abstract Component getComponent();

    protected int toPixels(int value) {
        return (int)((double)value * this.getDPI());
    }

    Rectangle getScreenshotBoundsTight() {
        if (this.screenshotBounds == null || this.extraHeight == 0) {
            return this.screenshotBounds;
        }
        Rectangle bounds = new Rectangle(this.screenshotBounds);
        bounds.height -= this.extraHeight;
        bounds.y += this.extraHeight;
        return bounds;
    }

    @Override
    public void onSelectionChanged(DiagnosticsNode selection) {
        super.onSelectionChanged(selection);
        if (!this.visible) {
            return;
        }
        if (this.getLocation() != null) {
            this.screenshotDirty = true;
        }
        this.getGroups().cancelNext();
        InspectorService.ObjectGroup nextGroup = this.getGroups().getNext();
        CompletableFuture<ArrayList<DiagnosticsNode>> selectionResults = nextGroup.getBoundingBoxes(this.getSelectedElement(), selection);
        nextGroup.safeWhenComplete(selectionResults, (boxes, error) -> {
            if (nextGroup.isDisposed()) {
                return;
            }
            if (error != null || boxes == null) {
                return;
            }
            if (this.getGroups() == null) {
                return;
            }
            this.getGroups().promoteNext();
            this.boxes = boxes;
            this.forceRender();
        });
        this.getScreenshotRateLimiter().scheduleRequest();
    }

    public CompletableFuture<?> updateMouse(boolean navigateTo) {
        int endLine;
        int startLine;
        InspectorObjectGroupManager hoverGroups = this.getHovers();
        if (hoverGroups == null || (this.popupActive() || this.popopOpenInProgress) && !navigateTo) {
            return CompletableFuture.completedFuture(null);
        }
        Screenshot latestScreenshot = this.getScreenshotNow();
        if (this.screenshotBounds == null || latestScreenshot == null || this.lastPoint == null || !this.getScreenshotBoundsTight().contains(this.lastPoint) || this.getSelectedElement() == null) {
            return CompletableFuture.completedFuture(null);
        }
        hoverGroups.cancelNext();
        InspectorService.ObjectGroup nextGroup = hoverGroups.getNext();
        Matrix4 matrix = this.buildTransformToScreenshot(latestScreenshot);
        matrix.invert();
        Vector3 point = matrix.perspectiveTransform(new Vector3(this.lastPoint.getX(), this.lastPoint.getY(), 0.0));
        String file = this.controlDown || this.getVirtualFile() == null ? null : InspectorService.toSourceLocationUri(this.getVirtualFile().getPath());
        TextRange activeRange = this.getActiveRange();
        if (this.controlDown || activeRange == null || this.getDocument() == null) {
            startLine = -1;
            endLine = -1;
        } else {
            startLine = this.getDocument().getLineNumber(activeRange.getStartOffset());
            endLine = this.getDocument().getLineNumber(activeRange.getEndOffset());
        }
        CompletableFuture<ArrayList<DiagnosticsNode>> hitResults = nextGroup.hitTest(this.getSelectedElement(), point.getX(), point.getY(), file, startLine, endLine);
        nextGroup.safeWhenComplete(hitResults, (hits, error) -> {
            if (nextGroup.isDisposed()) {
                return;
            }
            if (error != null || hits == null) {
                return;
            }
            this.currentHits = hits;
            hoverGroups.promoteNext();
            if (navigateTo && this.popopOpenInProgress) {
                DiagnosticsNode node;
                DiagnosticsNode diagnosticsNode = node = !hits.isEmpty() ? (DiagnosticsNode)hits.get(0) : null;
                if (node == null) {
                    return;
                }
                TransformedRect transform = node.getTransformToRoot();
                if (transform != null) {
                    Matrix4 transformMatrix = this.buildTransformToScreenshot(latestScreenshot);
                    transformMatrix.multiply(transform.getTransform());
                    Rectangle2D rect = transform.getRectangle();
                    Vector3 transformed = transformMatrix.perspectiveTransform(new Vector3(new double[]{rect.getCenterX(), rect.getMinY(), 0.0}));
                    Point pendingPopupOpenLocation = new Point((int)Math.round(transformed.getX()), (int)Math.round(transformed.getY() + 1.0));
                    this.showPopup(pendingPopupOpenLocation, node);
                }
                this.popopOpenInProgress = false;
            }
            if (navigateTo && !hits.isEmpty()) {
                this.getGroups().getCurrent().setSelection(((DiagnosticsNode)hits.get(0)).getValueRef(), false, false);
            }
            this.forceRender();
        });
        return hitResults;
    }

    protected abstract VirtualFile getVirtualFile();

    protected abstract Document getDocument();

    protected abstract void showPopup(Point var1, DiagnosticsNode var2);

    @Nullable
    abstract TextRange getActiveRange();

    void setMouseInScreenshot(boolean v) {
        if (this._mouseInScreenshot == v) {
            return;
        }
        this._mouseInScreenshot = v;
        this.forceRender();
    }

    public void updateMouseCursor() {
        if (this.screenshotBounds == null) {
            this.setMouseInScreenshot(false);
            return;
        }
        if (this.lastPoint != null && this.screenshotBounds.contains(this.lastPoint)) {
            this.setCustomCursor(Cursor.getPredefinedCursor(0));
            this.setMouseInScreenshot(true);
            if (!this.getScreenshotBoundsTight().contains(this.lastPoint)) {
                this.cancelHovers();
            }
        } else {
            this.setCustomCursor(null);
            this._mouseOutOfScreenshot();
        }
    }

    abstract void setCustomCursor(@Nullable Cursor var1);

    void registerLastEvent(MouseEvent event) {
        this.lastPoint = event.getPoint();
        this.controlDown = event.isControlDown();
        this.altDown = event.isAltDown();
        this.updateMouseCursor();
    }

    @Override
    public void onMouseMoved(MouseEvent event) {
        assert (!event.isConsumed());
        this.registerLastEvent(event);
        if (this._mouseInScreenshot) {
            event.consume();
            if (this.getScreenshotBoundsTight().contains(this.lastPoint) && !this.popupActive()) {
                this.getMouseRateLimiter().scheduleRequest();
            }
        }
    }

    boolean popupActive() {
        return this.popup != null && !this.popup.isDisposed() || this.popopOpenInProgress;
    }

    protected void _hidePopup() {
        if (this.popup != null && !this.popup.isDisposed()) {
            this.popup.dispose();
            this.popup = null;
        }
    }

    @Override
    public void onMousePressed(MouseEvent event) {
        this.registerLastEvent(event);
        Point point = event.getPoint();
        if (this.screenshotBounds != null && this.screenshotBounds.contains(point)) {
            event.consume();
            if (this.isPopupTrigger(event)) {
                this._hidePopup();
                this.popopOpenInProgress = true;
                this.updateMouse(true);
            }
        }
    }

    private boolean isPopupTrigger(MouseEvent event) {
        return false;
    }

    @Override
    public void onMouseReleased(MouseEvent event) {
        this.registerLastEvent(event);
        if (this.screenshotBounds == null) {
            return;
        }
        Point point = event.getPoint();
        if (this.screenshotBounds.contains(point)) {
            Rectangle tightBounds = this.getScreenshotBoundsTight();
            event.consume();
            if (tightBounds.contains(point)) {
                if (this.isPopupTrigger(event)) {
                    this._hidePopup();
                    this.popopOpenInProgress = true;
                }
                this.updateMouse(true);
            } else {
                this._hidePopup();
                if (this.elements != null) {
                    if (this.elements.size() > 1) {
                        int newIndex = this.activeIndex + 1;
                        if (newIndex >= this.elements.size()) {
                            newIndex = 1;
                        }
                        this.getGroups().getCurrent().setSelection(((DiagnosticsNode)this.elements.get(newIndex)).getValueRef(), false, true);
                    } else if (this.elements.size() == 1) {
                        this.getGroups().getCurrent().setSelection(((DiagnosticsNode)this.elements.get(0)).getValueRef(), false, true);
                    }
                }
            }
        }
    }

    @Override
    public void onMouseExited(MouseEvent event) {
        this.lastPoint = null;
        this.controlDown = false;
        this.altDown = false;
        this.setMouseInScreenshot(false);
        this.updateMouseCursor();
    }

    @Override
    public void onFlutterFrame() {
        this.fetchScreenshot(false);
    }

    public void _mouseOutOfScreenshot() {
        this.setMouseInScreenshot(false);
        this.lastPoint = null;
        this.cancelHovers();
    }

    public void cancelHovers() {
        this.hover = this.getHovers();
        if (this.hover != null) {
            this.hover.cancelNext();
            this.controlDown = false;
            this.altDown = false;
        }
        if (this.currentHits != null) {
            this.currentHits = null;
            this.forceRender();
        }
    }

    @Override
    public void onMouseEntered(MouseEvent event) {
        this.onMouseMoved(event);
    }

    void clearState() {
        this.screenshotDirty = true;
        this.currentHits = new ArrayList();
        if (this.hover != null) {
            this.hover.clear(true);
        }
        this.screenshot = null;
    }

    @Override
    public void onInspectorAvailabilityChanged() {
        this.clearState();
    }

    @Override
    public void onVisibleChanged() {
        if (!this.visible) {
            this._hidePopup();
        }
        if (this.visible) {
            this.computeScreenshotBounds();
            if (this.getInspectorService() != null && (this.screenshot == null || this.screenshotDirty)) {
                this.fetchScreenshot(false);
            }
        }
    }

    public abstract void computeScreenshotBounds();

    @Override
    public boolean updateVisiblityLocked(Rectangle newRectangle) {
        if (this.popupActive()) {
            this.lastLockedRectangle = new Rectangle(newRectangle);
            return true;
        }
        if (this.lastLockedRectangle != null && this.visible) {
            if (newRectangle.intersects(this.lastLockedRectangle)) {
                return true;
            }
            this.lastLockedRectangle = null;
        }
        return false;
    }

    public boolean isVisiblityLocked() {
        if (this.popupActive()) {
            return true;
        }
        if (this.lastLockedRectangle != null && this.visible && this.visibleRect != null) {
            return this.visibleRect.intersects(this.lastLockedRectangle);
        }
        return false;
    }

    public Screenshot getScreenshotNow() {
        return this.screenshot;
    }

    protected Matrix4 buildTransformToScreenshot(Screenshot latestScreenshot) {
        Matrix4 matrix = Matrix4.identity();
        matrix.translate(this.screenshotBounds.x, this.screenshotBounds.y + this.extraHeight, 0.0);
        Rectangle2D imageRect = latestScreenshot.transformedRect.getRectangle();
        double centerX = imageRect.getCenterX();
        double centerY = imageRect.getCenterY();
        matrix.translate(-centerX, -centerY, 0.0);
        matrix.scale(1.0 / this.getDPI(), 1.0 / this.getDPI(), 1.0 / this.getDPI());
        matrix.translate(centerX * this.getDPI(), centerY * this.getDPI(), 0.0);
        matrix.multiply(latestScreenshot.transformedRect.getTransform());
        return matrix;
    }

    protected ArrayList<DiagnosticsNode> getNodesToHighlight() {
        return this.currentHits != null && !this.currentHits.isEmpty() ? this.currentHits : this.boxes;
    }

    protected void clearScreenshot() {
        if (this.getScreenshotNow() != null) {
            this.screenshot = null;
            this.computeScreenshotBounds();
            this.forceRender();
        }
    }

    @Override
    public void setElements(ArrayList<DiagnosticsNode> elements) {
        super.setElements(elements);
        this.currentHits = null;
        this.boxes = null;
    }

    boolean hasCurrentHits() {
        return this.currentHits != null && !this.currentHits.isEmpty();
    }

    public void onMaybeFetchScreenshot() {
        if (this.screenshot == null || this.screenshotDirty) {
            this.fetchScreenshot(false);
        }
    }

    void fetchScreenshot(boolean mightBeIncompatible) {
        if (mightBeIncompatible) {
            this.screenshotLoading = true;
        }
        this.screenshotDirty = true;
        if (!this.visible) {
            return;
        }
        this.getScreenshotRateLimiter().scheduleRequest();
    }

    protected CompletableFuture<InspectorService.InteractiveScreenshot> updateScreenshot() {
        InspectorService.ObjectGroup group = this.getScreenshotGroup();
        if (group == null) {
            return CompletableFuture.completedFuture(null);
        }
        Dimension previewSize = this.getPreviewSize();
        long startTime = System.currentTimeMillis();
        CompletableFuture<InspectorService.InteractiveScreenshot> screenshotFuture = group.getScreenshotAtLocation(this.getLocation(), 10, this.toPixels(previewSize.width), this.toPixels(previewSize.height), this.getDPI() * 0.7);
        group.safeWhenComplete(screenshotFuture, (pair, e2) -> {
            if (e2 != null || group.isDisposed() || this.getInspectorService() == null) {
                return;
            }
            if (pair == null) {
                this.setElements(null);
                this.screenshot = null;
                this.boxes = null;
            } else {
                this.setElements(pair.elements);
                this.screenshot = pair.screenshot;
                this.boxes = pair.boxes;
            }
            this.screenshotDirty = false;
            this.screenshotLoading = false;
            this.computeScreenshotBounds();
            this.forceRender();
        });
        return screenshotFuture;
    }

    protected abstract Dimension getPreviewSize();

    public void paint(@NotNull Graphics g, int lineHeight) {
        if (g == null) {
            PreviewViewControllerBase.$$$reportNull$$$0(0);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Rectangle clip = g2d.getClipBounds();
        this.computeScreenshotBounds();
        if (this.screenshotBounds == null || !clip.intersects(this.screenshotBounds)) {
            return;
        }
        Screenshot latestScreenshot = this.getScreenshotNow();
        int imageWidth = this.screenshotBounds.width;
        int imageHeight = this.screenshotBounds.height;
        if (this.drawBackground) {
            int SHADOW_HEIGHT = 5;
            for (int h = 1; h < 5; ++h) {
                g2d.setColor(new Color(43, 43, 43, 100 - h * 20));
                g2d.fillRect(this.screenshotBounds.x - h + 1, this.screenshotBounds.y + Math.min(this.screenshotBounds.height, imageHeight) + h, Math.min(this.screenshotBounds.width, imageWidth) + h - 1, 1);
                g2d.fillRect(this.screenshotBounds.x - h + 1, this.screenshotBounds.y - h, Math.min(this.screenshotBounds.width, imageWidth) + h - 1, 1);
                g2d.fillRect(this.screenshotBounds.x - h, this.screenshotBounds.y - h, 1, imageHeight + 2 * h);
            }
        }
        g2d.clip(this.screenshotBounds);
        Font font = UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.MINI, (Font)UIUtil.getTreeFont());
        g2d.setFont(font);
        g2d.setColor((Color)(this.isSelected ? JBColor.GRAY : JBColor.LIGHT_GRAY));
        if (latestScreenshot != null) {
            g2d.clip(this.getScreenshotBoundsTight());
            g2d.drawImage(latestScreenshot.image, new AffineTransform(1.0 / this.getDPI(), 0.0, 0.0, 1.0 / this.getDPI(), (double)this.screenshotBounds.x, (double)(this.screenshotBounds.y + this.extraHeight)), null);
            ArrayList<DiagnosticsNode> nodesToHighlight = this.getNodesToHighlight();
            if (nodesToHighlight != null && !nodesToHighlight.isEmpty()) {
                boolean first = true;
                for (DiagnosticsNode box : nodesToHighlight) {
                    TransformedRect transform = box.getTransformToRoot();
                    if (transform != null) {
                        Matrix4 matrix = this.buildTransformToScreenshot(latestScreenshot);
                        matrix.multiply(transform.getTransform());
                        Rectangle2D rect = transform.getRectangle();
                        Vector3[] points = new Vector3[]{matrix.perspectiveTransform(new Vector3(new double[]{rect.getMinX(), rect.getMinY(), 0.0})), matrix.perspectiveTransform(new Vector3(new double[]{rect.getMaxX(), rect.getMinY(), 0.0})), matrix.perspectiveTransform(new Vector3(new double[]{rect.getMaxX(), rect.getMaxY(), 0.0})), matrix.perspectiveTransform(new Vector3(new double[]{rect.getMinX(), rect.getMaxY(), 0.0}))};
                        Polygon polygon = new Polygon();
                        for (Vector3 point : points) {
                            polygon.addPoint((int)Math.round(point.getX()), (int)Math.round(point.getY()));
                        }
                        if (first && !this.elements.isEmpty() && !Objects.equals(box.getValueRef(), ((DiagnosticsNode)this.elements.get(0)).getValueRef())) {
                            g2d.setColor(FlutterEditorColors.HIGHLIGHTED_RENDER_OBJECT_BORDER_COLOR);
                            g2d.fillPolygon(polygon);
                        }
                        g2d.setStroke(SOLID_STROKE);
                        g2d.setColor(FlutterEditorColors.HIGHLIGHTED_RENDER_OBJECT_BORDER_COLOR);
                        g2d.drawPolygon(polygon);
                    }
                    first = false;
                }
            }
        } else {
            if (this.drawBackground) {
                g2d.setColor((Color)(this.isSelected ? JBColor.GRAY : JBColor.LIGHT_GRAY));
                g2d.fillRect(this.screenshotBounds.x, this.screenshotBounds.y, this.screenshotBounds.width, this.screenshotBounds.height);
                g2d.setColor((Color)FlutterEditorColors.SHADOW_GRAY);
            }
            g2d.setColor((Color)JBColor.BLACK);
            this.drawMultilineString(g2d, this.getNoScreenshotMessage(), this.screenshotBounds.x + 4, this.screenshotBounds.y + lineHeight - 4, lineHeight);
        }
        g2d.setClip(clip);
        g2d.dispose();
    }

    String getNoScreenshotMessage() {
        return this.getInspectorService() == null ? "Run the application to\nactivate device mirror." : "Loading...";
    }

    protected void drawMultilineString(Graphics g, String s, int x, int y, int lineHeight) {
        for (String line : s.split("\n")) {
            g.drawString(line, x, y);
            y += lineHeight;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "io/flutter/editor/PreviewViewControllerBase", "paint"));
    }
}

