/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Disposer;
import io.flutter.editor.EditorMouseEventService;
import io.flutter.editor.InlinePreviewViewController;
import io.flutter.editor.InlineWidgetViewModelData;
import io.flutter.editor.PreviewViewControllerBase;
import io.flutter.editor.WidgetEditingContext;
import io.flutter.editor.WidgetIndentGuideDescriptor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class PreviewsForEditor
implements CustomHighlighterRenderer {
    static final boolean showOverallPreview = false;
    private final EditorEx editor;
    private final Disposable parentDisposable;
    private final WidgetEditingContext data;
    private final InlinePreviewViewController overallPreview;
    private ArrayList<InlinePreviewViewController> previews;

    public PreviewsForEditor(WidgetEditingContext data, EditorMouseEventService editorEventService, EditorEx editor, Disposable parentDisposable) {
        this.data = data;
        this.editor = editor;
        this.parentDisposable = parentDisposable;
        this.previews = new ArrayList();
        this.overallPreview = null;
        editorEventService.addListener(editor, new EditorMouseEventService.Listener(){

            @Override
            public void onMouseMoved(MouseEvent event) {
                for (PreviewViewControllerBase previewViewControllerBase : PreviewsForEditor.this.getAllPreviews(false)) {
                    if (event.isConsumed()) {
                        previewViewControllerBase.onMouseExited(event);
                        continue;
                    }
                    previewViewControllerBase.onMouseMoved(event);
                }
            }

            @Override
            public void onMousePressed(MouseEvent event) {
                for (PreviewViewControllerBase previewViewControllerBase : PreviewsForEditor.this.getAllPreviews(false)) {
                    previewViewControllerBase.onMousePressed(event);
                    if (!event.isConsumed()) continue;
                    break;
                }
            }

            @Override
            public void onMouseReleased(MouseEvent event) {
                for (PreviewViewControllerBase previewViewControllerBase : PreviewsForEditor.this.getAllPreviews(false)) {
                    previewViewControllerBase.onMouseReleased(event);
                    if (!event.isConsumed()) continue;
                    break;
                }
            }

            @Override
            public void onMouseEntered(MouseEvent event) {
                for (PreviewViewControllerBase previewViewControllerBase : PreviewsForEditor.this.getAllPreviews(false)) {
                    if (event.isConsumed()) {
                        previewViewControllerBase.onMouseExited(event);
                        continue;
                    }
                    previewViewControllerBase.onMouseEntered(event);
                }
            }

            @Override
            public void onMouseExited(MouseEvent event) {
                for (PreviewViewControllerBase previewViewControllerBase : PreviewsForEditor.this.getAllPreviews(false)) {
                    previewViewControllerBase.onMouseExited(event);
                }
            }
        }, parentDisposable);
    }

    public void outlinesChanged(Iterable<WidgetIndentGuideDescriptor> newDescriptors) {
        ArrayList<InlinePreviewViewController> newPreviews = new ArrayList<InlinePreviewViewController>();
        int i = 0;
        for (WidgetIndentGuideDescriptor descriptor : newDescriptors) {
            if (descriptor.parent != null) continue;
            if (i >= this.previews.size() || !descriptor.equals(this.previews.get(i).getDescriptor())) {
                newPreviews.add(new InlinePreviewViewController(new InlineWidgetViewModelData(descriptor, this.editor, this.data), true, this.parentDisposable));
                continue;
            }
            newPreviews.add(this.previews.get(i));
            ++i;
        }
        while (i < this.previews.size()) {
            Disposer.dispose((Disposable)this.previews.get(i));
            ++i;
        }
        this.previews = newPreviews;
    }

    protected Iterable<InlinePreviewViewController> getAllPreviews(boolean paintOrder) {
        ArrayList<InlinePreviewViewController> all = new ArrayList<InlinePreviewViewController>();
        if (this.overallPreview != null) {
            all.add(this.overallPreview);
        }
        all.addAll(this.previews);
        if (paintOrder) {
            all.sort(Comparator.comparingInt(InlinePreviewViewController::getPriority));
        } else {
            all.sort((a, b) -> Integer.compare(b.getPriority(), a.getPriority()));
        }
        return all;
    }

    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics graphics) {
        if (editor == null) {
            PreviewsForEditor.$$$reportNull$$$0(0);
        }
        if (highlighter == null) {
            PreviewsForEditor.$$$reportNull$$$0(1);
        }
        if (graphics == null) {
            PreviewsForEditor.$$$reportNull$$$0(2);
        }
        for (InlinePreviewViewController preview : this.getAllPreviews(true)) {
            if (!preview.visible) continue;
            preview.paint(editor, highlighter, graphics);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "highlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "graphics";
                break;
            }
        }
        objectArray[1] = "io/flutter/editor/PreviewsForEditor";
        objectArray[2] = "paint";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

