/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.PositionTracker;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;

class PropertyBalloonPositionTracker
extends PositionTracker<Balloon> {
    private final Editor myEditor;
    private final TextRange myRange;

    PropertyBalloonPositionTracker(Editor editor, TextRange range) {
        super((Component)editor.getContentComponent());
        this.myEditor = editor;
        this.myRange = range;
    }

    static boolean insideVisibleArea(Editor e, TextRange r) {
        int textLength = e.getDocument().getTextLength();
        if (r.getStartOffset() > textLength) {
            return false;
        }
        if (r.getEndOffset() > textLength) {
            return false;
        }
        Rectangle visibleArea = e.getScrollingModel().getVisibleArea();
        Point point = e.logicalPositionToXY(e.offsetToLogicalPosition(r.getStartOffset()));
        return visibleArea.contains(point);
    }

    public RelativePoint recalculateLocation(Balloon balloon) {
        int startOffset = this.myRange.getStartOffset();
        int endOffset = this.myRange.getEndOffset();
        Point startPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(startOffset));
        Point endPoint = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(endOffset));
        Point point = new Point((startPoint.x + endPoint.x) / 2, startPoint.y + this.myEditor.getLineHeight());
        return new RelativePoint((Component)this.myEditor.getContentComponent(), point);
    }
}

