/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.google.common.base.Joiner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.PositionTracker;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import io.flutter.FlutterMessages;
import io.flutter.dart.FlutterDartAnalysisServer;
import io.flutter.editor.ColorField;
import io.flutter.editor.EnumValueWrapper;
import io.flutter.editor.PropertyBalloonPositionTracker;
import io.flutter.editor.PropertyBalloonPositionTrackerScreenshot;
import io.flutter.editor.PropertyEnumComboBoxModel;
import io.flutter.hotui.StableWidgetTracker;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.InspectorGroupManagerService;
import io.flutter.inspector.InspectorObjectGroupManager;
import io.flutter.inspector.InspectorService;
import io.flutter.preview.OutlineOffsetConverter;
import io.flutter.preview.WidgetEditToolbar;
import io.flutter.run.FlutterReloadManager;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.AsyncRateLimiter;
import io.flutter.utils.AsyncUtils;
import io.flutter.utils.EventStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.dartlang.analysis.server.protocol.FlutterWidgetProperty;
import org.dartlang.analysis.server.protocol.FlutterWidgetPropertyEditor;
import org.dartlang.analysis.server.protocol.FlutterWidgetPropertyValue;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyEditorPanel
extends SimpleToolWindowPanel {
    protected final AsyncRateLimiter retryLookupPropertiesRateLimiter;
    private final boolean fixedWidth;
    private final InspectorGroupManagerService.Client inspectorStateServiceClient;
    private final FlutterDartAnalysisServer flutterDartAnalysisService;
    @Nullable
    private final Project project;
    private final boolean showWidgetEditToolbar;
    private final Map<String, JComponent> fields = new HashMap<String, JComponent>();
    private final Map<String, FlutterWidgetProperty> propertyMap = new HashMap<String, FlutterWidgetProperty>();
    private final Map<String, String> currentExpressionMap = new HashMap<String, String>();
    private final ArrayList<FlutterWidgetProperty> properties = new ArrayList();
    private final Disposable parentDisposable;
    int numFailures;
    String previouslyFocusedProperty = null;
    private DiagnosticsNode node;
    private FlutterOutline outline;
    private EventStream<VirtualFile> activeFile;
    private boolean pendingHotReload;
    private boolean needHotReload;
    private CompletableFuture<List<FlutterWidgetProperty>> propertyFuture;

    public PropertyEditorPanel(@Nullable InspectorGroupManagerService inspectorGroupManagerService, @Nullable Project project, FlutterDartAnalysisServer flutterDartAnalysisService, boolean showWidgetEditToolbar, boolean fixedWidth, Disposable parentDisposable) {
        super(true, true);
        this.setFocusable(true);
        this.fixedWidth = fixedWidth;
        this.parentDisposable = parentDisposable;
        this.inspectorStateServiceClient = new InspectorGroupManagerService.Client(parentDisposable){

            @Override
            public void onInspectorAvailabilityChanged() {
                PropertyEditorPanel.this.pendingHotReload = false;
            }

            @Override
            public void notifyAppReloaded() {
                PropertyEditorPanel.this.pendingHotReload = false;
            }

            @Override
            public void notifyAppRestarted() {
                PropertyEditorPanel.this.pendingHotReload = false;
            }
        };
        this.retryLookupPropertiesRateLimiter = new AsyncRateLimiter(10.0, () -> {
            this.maybeLoadProperties();
            return CompletableFuture.completedFuture(null);
        }, parentDisposable);
        inspectorGroupManagerService.addListener(this.inspectorStateServiceClient, parentDisposable);
        this.project = project;
        this.flutterDartAnalysisService = flutterDartAnalysisService;
        this.showWidgetEditToolbar = showWidgetEditToolbar;
    }

    public static Balloon showPopup(InspectorGroupManagerService inspectorGroupManagerService, EditorEx editor, DiagnosticsNode node, @NotNull InspectorService.Location location, FlutterDartAnalysisServer service, Point point) {
        if (location == null) {
            PropertyEditorPanel.$$$reportNull$$$0(0);
        }
        Balloon balloon = PropertyEditorPanel.showPopupHelper(inspectorGroupManagerService, editor.getProject(), node, location, service);
        if (point != null) {
            balloon.show((PositionTracker)new PropertyBalloonPositionTrackerScreenshot((Editor)editor, point), Balloon.Position.below);
        } else {
            int offset = location.getOffset();
            TextRange textRange = new TextRange(offset, offset + 1);
            balloon.show((PositionTracker)new PropertyBalloonPositionTracker((Editor)editor, textRange), Balloon.Position.below);
        }
        return balloon;
    }

    public static Balloon showPopup(InspectorGroupManagerService inspectorGroupManagerService, Project project, Component component, @Nullable DiagnosticsNode node, @NonNls InspectorService.Location location, FlutterDartAnalysisServer service, Point point) {
        Balloon balloon = PropertyEditorPanel.showPopupHelper(inspectorGroupManagerService, project, node, location, service);
        balloon.show(new RelativePoint(component, point), Balloon.Position.above);
        return balloon;
    }

    public static Balloon showPopupHelper(InspectorGroupManagerService inspectorService, Project project, @Nullable DiagnosticsNode node, @NotNull InspectorService.Location location, FlutterDartAnalysisServer service) {
        if (location == null) {
            PropertyEditorPanel.$$$reportNull$$$0(1);
        }
        JBColor GRAPHITE_COLOR = new JBColor(new Color(236, 236, 236, 215), new Color(60, 63, 65, 215));
        Disposable panelDisposable = Disposer.newDisposable();
        PropertyEditorPanel panel2 = new PropertyEditorPanel(inspectorService, project, service, true, true, panelDisposable);
        StableWidgetTracker tracker = new StableWidgetTracker(location, service, project, panelDisposable);
        EventStream<VirtualFile> activeFile = new EventStream<VirtualFile>(location.getFile());
        panel2.initalize(node, tracker.getCurrentOutlines(), activeFile);
        panel2.setBackground((Color)GRAPHITE_COLOR);
        panel2.setOpaque(false);
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)((Object)panel2));
        balloonBuilder.setFadeoutTime(0L);
        balloonBuilder.setFillColor((Color)GRAPHITE_COLOR);
        balloonBuilder.setAnimationCycle(0);
        balloonBuilder.setHideOnClickOutside(true);
        balloonBuilder.setHideOnKeyOutside(false);
        balloonBuilder.setHideOnAction(false);
        balloonBuilder.setCloseButtonEnabled(false);
        balloonBuilder.setBlockClicksThroughBalloon(true);
        balloonBuilder.setRequestFocus(true);
        balloonBuilder.setShadow(true);
        Balloon balloon = balloonBuilder.createBalloon();
        Disposer.register((Disposable)balloon, (Disposable)panelDisposable);
        return balloon;
    }

    InspectorObjectGroupManager getGroupManager() {
        return this.inspectorStateServiceClient.getGroupManager();
    }

    int getOffset() {
        if (this.outline == null) {
            return -1;
        }
        VirtualFile file = this.activeFile.getValue();
        if (file == null) {
            return -1;
        }
        OutlineOffsetConverter converter = new OutlineOffsetConverter(this.project, file);
        return converter.getConvertedOutlineOffset(this.outline);
    }

    InspectorService.Location getInspectorLocation() {
        VirtualFile file = this.activeFile.getValue();
        if (file == null || this.outline == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        return InspectorService.Location.outlineToLocation(this.project, this.activeFile.getValue(), this.outline, document);
    }

    void updateWidgetDescription() {
        VirtualFile file = this.activeFile.getValue();
        int offset = this.getOffset();
        if (file == null || offset < 0 || this.outline == null || this.outline.getClassName() == null || !"NEW_INSTANCE".equals(this.outline.getKind())) {
            if (!this.properties.isEmpty()) {
                this.properties.clear();
                this.rebuildUi();
            }
            return;
        }
        CompletableFuture<List<FlutterWidgetProperty>> future = this.flutterDartAnalysisService.getWidgetDescription(file, offset);
        this.propertyFuture = future;
        if (this.propertyFuture == null) {
            return;
        }
        AsyncUtils.whenCompleteUiThread(this.propertyFuture, (updatedProperties, throwable) -> {
            if (this.propertyFuture != future || updatedProperties == null || throwable != null) {
                return;
            }
            if (offset != this.getOffset() || !file.equals(this.activeFile.getValue())) {
                return;
            }
            this.properties.clear();
            this.properties.addAll((Collection<FlutterWidgetProperty>)updatedProperties);
            this.propertyMap.clear();
            this.currentExpressionMap.clear();
            for (FlutterWidgetProperty property : updatedProperties) {
                String name = property.getName();
                this.propertyMap.put(name, property);
                this.currentExpressionMap.put(name, property.getExpression());
            }
            if (this.propertyMap.isEmpty()) {
                ++this.numFailures;
                if (this.numFailures < 3) {
                    this.retryLookupPropertiesRateLimiter.scheduleRequest();
                }
                return;
            }
            this.numFailures = 0;
            this.rebuildUi();
        });
    }

    public void outlinesChanged(List<FlutterOutline> outlines) {
        FlutterOutline nextOutline;
        FlutterOutline flutterOutline = nextOutline = outlines.isEmpty() ? null : outlines.get(0);
        if (nextOutline == this.outline) {
            return;
        }
        this.outline = nextOutline;
        this.maybeLoadProperties();
        this.lookupMatchingElements();
    }

    public void lookupMatchingElements() {
        InspectorObjectGroupManager groupManager = this.getGroupManager();
        if (groupManager == null || this.outline == null) {
            return;
        }
        groupManager.cancelNext();
        this.node = null;
        InspectorService.ObjectGroup group = groupManager.getNext();
        InspectorService.Location location = this.getInspectorLocation();
        group.safeWhenComplete(group.getElementsAtLocation(location, 10), (elements, error) -> {
            if (elements == null || error != null) {
                return;
            }
            this.node = elements.isEmpty() ? null : (DiagnosticsNode)elements.get(0);
            groupManager.promoteNext();
        });
    }

    public DiagnosticsNode getNode() {
        return this.node;
    }

    void maybeLoadProperties() {
        this.updateWidgetDescription();
    }

    public void initalize(DiagnosticsNode node, EventStream<List<FlutterOutline>> currentOutlines, EventStream<VirtualFile> activeFile) {
        this.node = node;
        this.activeFile = activeFile;
        currentOutlines.listen(this::outlinesChanged, true);
        if (this.showWidgetEditToolbar) {
            WidgetEditToolbar widgetEditToolbar = new WidgetEditToolbar(true, currentOutlines, activeFile, this.project, this.flutterDartAnalysisService);
            ActionToolbar toolbar = widgetEditToolbar.getToolbar();
            toolbar.setShowSeparatorTitles(true);
            this.setToolbar(toolbar.getComponent());
        }
        this.rebuildUi();
    }

    protected void rebuildUi() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null) {
            if (this.isAncestorOf(focusOwner)) {
                for (Map.Entry<String, JComponent> entry : this.fields.entrySet()) {
                    if (!entry.getValue().isAncestorOf(focusOwner) && entry.getValue() != focusOwner) continue;
                    this.previouslyFocusedProperty = entry.getKey();
                    break;
                }
            } else {
                this.previouslyFocusedProperty = null;
            }
        }
        this.removeAll();
        MigLayout manager = new MigLayout("insets 3", this.fixedWidth ? "[::120]5[:20:400]" : "[::120]5[grow]", "[23]4[23]");
        this.setLayout((LayoutManager)manager);
        int added = 0;
        for (FlutterWidgetProperty property : this.properties) {
            JTextField field;
            String name = property.getName();
            if (name.equals("child") || name.equals("children")) continue;
            if (name.equals("Container")) {
                List<FlutterWidgetProperty> containerProperties = property.getChildren();
                continue;
            }
            String documentation = property.getDocumentation();
            if (property.getEditor() == null) {
                boolean colorProperty = name.equals("color");
                String colorPropertyName = name;
                if (colorProperty) {
                    field = this.buildColorProperty(name, property);
                } else {
                    String expression = property.getExpression();
                    if (expression == null) {
                        expression = "";
                    }
                    JBTextField textField = new JBTextField(expression);
                    textField.setCaretPosition(0);
                    this.addTextFieldListeners(name, textField);
                    field = textField;
                }
            } else {
                FlutterWidgetPropertyEditor editor = property.getEditor();
                if (editor.getEnumItems() != null) {
                    ComboBox comboBox = new ComboBox();
                    comboBox.setEditable(true);
                    comboBox.setModel((ComboBoxModel)new PropertyEnumComboBoxModel(property));
                    field = comboBox;
                    comboBox.addItemListener(e -> {
                        if (e.getStateChange() == 1) {
                            EnumValueWrapper wrapper = (EnumValueWrapper)e.getItem();
                            if (wrapper.item != null) {
                                this.setParsedPropertyValue(name, new FlutterWidgetPropertyValue(null, null, null, null, wrapper.item, null), false);
                            } else {
                                this.setPropertyValue(name, wrapper.expression);
                            }
                        }
                    });
                } else {
                    String kind = property.getEditor().getKind();
                    if (Objects.equals(kind, "BOOL")) {
                        // empty if block
                    }
                    JBTextField textField = new JBTextField(property.getExpression());
                    textField.setCaretPosition(0);
                    field = textField;
                    this.addTextFieldListeners(name, textField);
                }
            }
            if (name.equals("data")) {
                if (documentation != null) {
                    field.setToolTipText(documentation);
                } else {
                    field.setToolTipText("data");
                }
                this.add(field, "span, growx");
            } else {
                String propertyName = property.getName();
                JBLabel label = new JBLabel(propertyName);
                this.add((Component)label, "right, wmax 120px");
                ArrayList<Object> tooltipBlocks = new ArrayList<Object>();
                tooltipBlocks.add("<strong>" + propertyName + "</strong>");
                if (documentation != null) {
                    tooltipBlocks.add(documentation);
                }
                label.setToolTipText(Joiner.on((String)"\n\n").join(tooltipBlocks));
                this.add(field, "wrap, growx");
            }
            if (documentation != null) {
                field.setToolTipText(documentation);
            }
            if (!this.fixedWidth) {
                this.setPreferredFieldSize(field);
            }
            this.fields.put(name, field);
            ++added;
        }
        if (this.previouslyFocusedProperty != null && this.fields.containsKey(this.previouslyFocusedProperty)) {
            this.fields.get(this.previouslyFocusedProperty).requestFocus();
        }
        if (added == 0) {
            this.add((Component)new JBLabel("No editable properties"));
        }
        this.revalidate();
        this.repaint();
    }

    private JTextField buildColorProperty(String name, FlutterWidgetProperty property) {
        return new ColorField(this, name, property, this.parentDisposable);
    }

    public void addTextFieldListeners(final String name, final JBTextField field) {
        final FlutterOutline matchingOutline = this.outline;
        field.addActionListener(e -> this.setPropertyValue(name, field.getText()));
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (PropertyEditorPanel.this.outline != matchingOutline) {
                    return;
                }
                PropertyEditorPanel.this.setPropertyValue(name, field.getText());
            }
        });
    }

    private void setPreferredFieldSize(JComponent field) {
        field.setPreferredSize(new Dimension(20, (int)field.getPreferredSize().getHeight()));
    }

    public String getDescription() {
        ArrayList<String> parts = new ArrayList<String>();
        if (this.outline != null && this.outline.getClassName() != null) {
            parts.add(this.outline.getClassName());
        }
        parts.add("Properties");
        return Joiner.on((String)" ").join(parts);
    }

    void setPropertyValue(String propertyName, String expression) {
        this.setPropertyValue(propertyName, expression, false);
    }

    void setPropertyValue(String propertyName, String expression, boolean force) {
        this.setParsedPropertyValue(propertyName, new FlutterWidgetPropertyValue(null, null, null, null, null, expression), force);
    }

    private void setParsedPropertyValue(String propertyName, FlutterWidgetPropertyValue value, boolean force) {
        boolean updated = this.setParsedPropertyValueHelper(propertyName, value);
        if (!updated && force) {
            this.hotReload();
        }
    }

    private boolean setParsedPropertyValueHelper(String propertyName, FlutterWidgetPropertyValue value) {
        SourceChange change;
        String lastExpression;
        FlutterWidgetPropertyValue emptyValue = new FlutterWidgetPropertyValue(null, null, null, null, null, null);
        FlutterWidgetProperty property = this.propertyMap.get(propertyName);
        if (property == null) {
            return false;
        }
        if (property.getExpression() != null && property.getExpression().equals(value.getExpression())) {
            return false;
        }
        if (value != null && Objects.equals(value.getExpression(), "") || emptyValue.equals(value)) {
            value = null;
        }
        if ((lastExpression = this.currentExpressionMap.get(propertyName)) != null && value != null && lastExpression.equals(value.getExpression())) {
            return false;
        }
        this.currentExpressionMap.put(propertyName, value != null ? value.getExpression() : null);
        FlutterWidgetPropertyEditor editor = property.getEditor();
        if (editor != null && value != null && value.getExpression() != null) {
            String kind;
            String expression = value.getExpression();
            switch (kind = editor.getKind()) {
                case "BOOL": {
                    if (expression.equals("true")) {
                        value = new FlutterWidgetPropertyValue(true, null, null, null, null, null);
                        break;
                    }
                    if (!expression.equals("false")) break;
                    value = new FlutterWidgetPropertyValue(false, null, null, null, null, null);
                    break;
                }
                case "STRING": {
                    if (expression.length() < 2 || (!expression.startsWith("'") || !expression.endsWith("'")) && (!expression.startsWith("\"") || !expression.endsWith("\""))) break;
                    value = new FlutterWidgetPropertyValue(null, null, null, expression.substring(1, expression.length() - 1), null, null);
                    break;
                }
                case "DOUBLE": {
                    try {
                        double doubleValue = Double.parseDouble(expression);
                        if ((double)((int)doubleValue) == doubleValue) {
                            value = new FlutterWidgetPropertyValue(null, null, (int)doubleValue, null, null, null);
                            break;
                        }
                        value = new FlutterWidgetPropertyValue(null, doubleValue, null, null, null, null);
                    }
                    catch (NumberFormatException doubleValue) {}
                    break;
                }
                case "INT": {
                    try {
                        int intValue = Integer.parseInt(expression);
                        value = new FlutterWidgetPropertyValue(null, null, intValue, null, null, null);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (Objects.equals(property.getValue(), value)) {
            return false;
        }
        try {
            change = this.flutterDartAnalysisService.setWidgetPropertyValue(property.getId(), value);
        }
        catch (Exception e) {
            if (value != null && value.getExpression() != null) {
                FlutterMessages.showInfo("Invalid property value", value.getExpression(), this.project);
            } else {
                FlutterMessages.showError("Unable to set propery value", e.getMessage(), this.project);
            }
            return false;
        }
        if (change != null && change.getEdits() != null && !change.getEdits().isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    AssistUtils.applySourceChange((Project)this.project, (SourceChange)change, (boolean)false);
                    this.hotReload();
                }
                catch (DartSourceEditException exception) {
                    FlutterMessages.showInfo("Failed to apply code change", exception.getMessage(), this.project);
                }
            });
            return true;
        }
        return false;
    }

    private void hotReload() {
        FlutterApp app = this.inspectorStateServiceClient.getApp();
        if (app != null) {
            ArrayList<FlutterApp> apps = new ArrayList<FlutterApp>();
            apps.add(app);
            if (this.pendingHotReload) {
                this.needHotReload = true;
            } else {
                this.pendingHotReload = true;
                this.needHotReload = false;
                FlutterReloadManager.getInstance(this.project).saveAllAndReloadAll(apps, "Property Editor");
            }
        }
    }

    public FlutterOutline getCurrentOutline() {
        return this.outline;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "location";
        objectArray2[1] = "io/flutter/editor/PropertyEditorPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showPopup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showPopupHelper";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

