/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import io.flutter.editor.EnumValueWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.dartlang.analysis.server.protocol.FlutterWidgetProperty;
import org.dartlang.analysis.server.protocol.FlutterWidgetPropertyEditor;
import org.dartlang.analysis.server.protocol.FlutterWidgetPropertyValue;
import org.dartlang.analysis.server.protocol.FlutterWidgetPropertyValueEnumItem;

class PropertyEnumComboBoxModel
extends AbstractListModel<EnumValueWrapper>
implements ComboBoxModel<EnumValueWrapper> {
    private final List<EnumValueWrapper> myList;
    private EnumValueWrapper mySelected;
    private String expression;

    public PropertyEnumComboBoxModel(FlutterWidgetProperty property) {
        FlutterWidgetPropertyEditor editor = property.getEditor();
        assert (editor != null);
        this.myList = new ArrayList<EnumValueWrapper>();
        for (FlutterWidgetPropertyValueEnumItem item : editor.getEnumItems()) {
            this.myList.add(new EnumValueWrapper(item));
        }
        String expression = property.getExpression();
        if (expression == null) {
            this.mySelected = null;
            return;
        }
        if (property.getValue() != null) {
            FlutterWidgetPropertyValue value = property.getValue();
            FlutterWidgetPropertyValueEnumItem enumValue = value.getEnumValue();
            if (enumValue != null) {
                for (EnumValueWrapper e : this.myList) {
                    if (e == null || e.item == null || !Objects.equals(e.item.getName(), enumValue.getName())) continue;
                    this.mySelected = e;
                }
            }
        } else {
            EnumValueWrapper newItem = new EnumValueWrapper(expression);
            this.myList.add(newItem);
            this.mySelected = newItem;
        }
        String kind = editor.getKind();
    }

    @Override
    public int getSize() {
        return this.myList.size();
    }

    @Override
    public EnumValueWrapper getElementAt(int index) {
        return this.myList.get(index);
    }

    @Override
    public EnumValueWrapper getSelectedItem() {
        return this.mySelected;
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item instanceof String) {
            String expression = (String)item;
            for (EnumValueWrapper e : this.myList) {
                if (!Objects.equals(e.expression, expression)) continue;
                this.mySelected = e;
                return;
            }
            EnumValueWrapper wrapper = new EnumValueWrapper(expression);
            this.myList.add(wrapper);
            this.fireIntervalAdded(this, this.myList.size() - 1, this.myList.size());
            this.setSelectedItem(wrapper);
            return;
        }
        this.setSelectedItem((EnumValueWrapper)item);
    }

    public void setSelectedItem(EnumValueWrapper item) {
        this.mySelected = item;
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

