/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.Nullable;

class TextRangeTracker {
    private final TextRange rawRange;
    private RangeMarker marker;
    private String endingWord;

    TextRangeTracker(int offset, int endOffset) {
        this.rawRange = new TextRange(offset, endOffset);
    }

    void track(Document document) {
        if (this.marker != null) {
            assert (document == this.marker.getDocument());
            return;
        }
        int docLength = document.getTextLength();
        int startOffset = Math.min(this.rawRange.getStartOffset(), docLength);
        int endOffset = Math.min(this.rawRange.getEndOffset(), docLength);
        this.endingWord = TextRangeTracker.getCurrentWord(document, endOffset - 1);
        this.marker = document.createRangeMarker(startOffset, endOffset);
    }

    @Nullable
    TextRange getRange() {
        if (this.marker == null) {
            return this.rawRange;
        }
        if (!this.marker.isValid()) {
            return null;
        }
        return new TextRange(this.marker.getStartOffset(), this.marker.getEndOffset());
    }

    void dispose() {
        if (this.marker != null) {
            this.marker.dispose();
        }
        this.marker = null;
    }

    public boolean isTracking() {
        return this.marker != null && this.marker.isValid();
    }

    public static String getCurrentWord(Document document, int offset) {
        int end;
        int documentLength = document.getTextLength();
        if ((offset = Math.max(0, offset)) < 0 || offset >= documentLength) {
            return "";
        }
        CharSequence chars = document.getCharsSequence();
        int maxWordEnd = Math.min(documentLength, offset + 20);
        for (end = offset; end < maxWordEnd && Character.isAlphabetic(chars.charAt(end)); ++end) {
        }
        if (offset == end) {
            return "";
        }
        return chars.subSequence(offset, end).toString();
    }

    public boolean isConsistentEndingWord() {
        if (this.marker == null) {
            return true;
        }
        if (!this.marker.isValid()) {
            return false;
        }
        return this.endingWord.equals(TextRangeTracker.getCurrentWord(this.marker.getDocument(), this.marker.getEndOffset() - 1));
    }
}

