/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import io.flutter.editor.OutlineLocation;
import java.util.ArrayList;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.dartlang.analysis.server.protocol.FlutterOutlineAttribute;
import org.dartlang.analysis.server.protocol.Location;

public class WidgetIndentGuideDescriptor {
    public final WidgetIndentGuideDescriptor parent;
    public final ArrayList<OutlineLocation> childLines;
    public final OutlineLocation widget;
    public final int indentLevel;
    public final int startLine;
    public final int endLine;
    public final FlutterOutline outlineNode;
    boolean tracked = false;

    public WidgetIndentGuideDescriptor(WidgetIndentGuideDescriptor parent, int indentLevel, int startLine, int endLine, ArrayList<OutlineLocation> childLines, OutlineLocation widget, FlutterOutline outlineNode) {
        this.parent = parent;
        this.childLines = childLines;
        this.widget = widget;
        this.indentLevel = indentLevel;
        this.startLine = startLine;
        this.endLine = endLine;
        this.outlineNode = outlineNode;
    }

    void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
        }
        if (this.childLines == null) {
            return;
        }
        for (OutlineLocation childLine : this.childLines) {
            childLine.dispose();
        }
        this.childLines.clear();
    }

    public void trackLocations(Document document) {
        if (this.tracked) {
            return;
        }
        this.tracked = true;
        if (this.widget != null) {
            this.widget.track(document);
        }
        if (this.childLines == null) {
            return;
        }
        for (OutlineLocation childLine : this.childLines) {
            childLine.track(document);
        }
    }

    public TextRange getMarker() {
        return this.widget.getFullRange();
    }

    public int hashCode() {
        int result = this.indentLevel;
        result = 31 * result + this.startLine;
        result = 31 * result + this.endLine;
        if (this.childLines != null) {
            for (OutlineLocation location : this.childLines) {
                result = 31 * result + location.hashCode();
            }
        }
        if (this.widget != null) {
            result = 31 * result + this.widget.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WidgetIndentGuideDescriptor that = (WidgetIndentGuideDescriptor)o;
        if (this.endLine != that.endLine) {
            return false;
        }
        if (this.indentLevel != that.indentLevel) {
            return false;
        }
        if (this.startLine != that.startLine) {
            return false;
        }
        if (this.childLines == null || that.childLines == null) {
            return this.childLines == that.childLines;
        }
        if (this.childLines.size() != that.childLines.size()) {
            return false;
        }
        for (int i = 0; i < this.childLines.size(); ++i) {
            if (this.childLines.get(i).equals(that.childLines.get(i))) continue;
            return false;
        }
        return true;
    }

    public int compareTo(WidgetIndentGuideDescriptor that) {
        int answer = this.endLine - that.endLine;
        if (answer != 0) {
            return answer;
        }
        answer = this.indentLevel - that.indentLevel;
        if (answer != 0) {
            return answer;
        }
        answer = this.startLine - that.startLine;
        if (answer != 0) {
            return answer;
        }
        if (this.childLines == that.childLines) {
            return 0;
        }
        if (this.childLines == null || that.childLines == null) {
            return this.childLines == null ? -1 : 1;
        }
        answer = this.childLines.size() - that.childLines.size();
        if (answer != 0) {
            return answer;
        }
        for (int i = 0; i < this.childLines.size(); ++i) {
            answer = this.childLines.get(i).compareTo(that.childLines.get(i));
            if (answer == 0) continue;
            return answer;
        }
        return 0;
    }

    public static class WidgetPropertyDescriptor {
        private RangeMarker marker;
        private final FlutterOutlineAttribute attribute;

        WidgetPropertyDescriptor(FlutterOutlineAttribute attribute) {
            this.attribute = attribute;
        }

        public String getName() {
            return this.attribute.getName();
        }

        public FlutterOutlineAttribute getAttribute() {
            return this.attribute;
        }

        public int getEndOffset() {
            if (this.marker == null) {
                Location location = this.attribute.getValueLocation();
                int startOffset = location.getOffset();
                int endOffset = startOffset + location.getLength();
                return endOffset;
            }
            return this.marker.getEndOffset();
        }

        public void track(Document document) {
            if (this.marker != null) {
                assert (this.marker.getDocument() == document);
                return;
            }
            int docLength = document.getTextLength();
            Location location = this.attribute.getValueLocation();
            int startOffset = Math.min(location.getOffset(), docLength);
            int endOffset = Math.min(startOffset + location.getLength(), docLength);
            this.marker = document.createRangeMarker(startOffset, endOffset);
        }

        public void dispose() {
            if (this.marker != null) {
                this.marker.dispose();
            }
        }
    }
}

