/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.editor.Document;
import io.flutter.editor.LineRange;
import io.flutter.editor.WidgetIndentGuideDescriptor;
import java.util.Arrays;
import java.util.List;

public class WidgetIndentHitTester {
    private final boolean[] lines;

    WidgetIndentHitTester(List<WidgetIndentGuideDescriptor> descriptors, Document document) {
        int lineCount = document.getLineCount();
        this.lines = new boolean[lineCount];
        for (WidgetIndentGuideDescriptor descriptor : descriptors) {
            int last = Math.min(this.lines.length, descriptor.endLine + 1);
            for (int i = Math.max(descriptor.startLine - 1, 0); i < last; ++i) {
                this.lines[i] = true;
            }
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.lines);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WidgetIndentHitTester)) {
            return false;
        }
        WidgetIndentHitTester other = (WidgetIndentHitTester)o;
        return Arrays.equals(this.lines, other.lines);
    }

    public boolean intersects(LineRange lineRange) {
        int last = Math.min(this.lines.length, lineRange.endLine + 1);
        for (int i = Math.max(lineRange.startLine - 1, 0); i < last; ++i) {
            if (!this.lines[i]) continue;
            return true;
        }
        return false;
    }
}

