/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import io.flutter.dart.FlutterDartAnalysisServer;
import io.flutter.editor.EditorMouseEventService;
import io.flutter.editor.EditorPositionService;
import io.flutter.editor.FilteredIndentsHighlightingPass;
import io.flutter.editor.LineRange;
import io.flutter.editor.OutlineLocation;
import io.flutter.editor.PreviewsForEditor;
import io.flutter.editor.TextRangeDescriptorPair;
import io.flutter.editor.WidgetEditingContext;
import io.flutter.editor.WidgetIndentGuideDescriptor;
import io.flutter.editor.WidgetIndentHitTester;
import io.flutter.editor.WidgetIndentsPassData;
import io.flutter.inspector.InspectorGroupManagerService;
import io.flutter.settings.FlutterSettings;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.NotNull;

public class WidgetIndentsHighlightingPass {
    private static final Logger LOG = Logger.getInstance(WidgetIndentsHighlightingPass.class);
    public static int INDENT_GUIDE_DELTA = -2;
    private static final Stroke SOLID_STROKE = new BasicStroke(1.0f);
    private static final JBColor VERY_LIGHT_GRAY = new JBColor((Color)Gray._224, (Color)Gray._80);
    private static final JBColor SHADOW_GRAY = new JBColor((Color)Gray._192, (Color)Gray._100);
    private static final JBColor OUTLINE_LINE_COLOR = new JBColor((Color)Gray._128, (Color)Gray._128);
    private static final JBColor OUTLINE_LINE_COLOR_PAST_BLOCK = new JBColor(new Color(128, 128, 128, 65), new Color(128, 128, 128, 65));
    private static final Key<WidgetIndentsPassData> INDENTS_PASS_DATA_KEY = Key.create((String)"INDENTS_PASS_DATA_KEY");
    private static final boolean DEBUG_WIDGET_INDENTS = false;
    private final EditorEx myEditor;
    private final Document myDocument;
    private final Project myProject;
    private final VirtualFile myFile;
    private final boolean convertOffsets;
    private final PsiFile psiFile;
    private final EditorMouseEventService editorEventService;
    private final WidgetEditingContext context;

    WidgetIndentsHighlightingPass(@NotNull Project project, @NotNull EditorEx editor, boolean convertOffsets, FlutterDartAnalysisServer flutterDartAnalysisService, InspectorGroupManagerService inspectorGroupManagerService, EditorMouseEventService editorEventService, EditorPositionService editorPositionService) {
        if (project == null) {
            WidgetIndentsHighlightingPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            WidgetIndentsHighlightingPass.$$$reportNull$$$0(1);
        }
        this.myDocument = editor.getDocument();
        this.myEditor = editor;
        this.myProject = project;
        this.myFile = editor.getVirtualFile();
        this.convertOffsets = convertOffsets;
        this.editorEventService = editorEventService;
        this.context = new WidgetEditingContext(project, flutterDartAnalysisService, inspectorGroupManagerService, editorPositionService);
        this.psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
        WidgetIndentsPassData data = this.getIndentsPassData();
        WidgetIndentsHighlightingPass.setIndentsPassData((Editor)editor, data);
    }

    private static void drawVerticalLineHelper(Graphics2D g, Color lineColor, int x, double yStart, double yEnd, ArrayList<OutlineLocation> childLines) {
        g.setColor(lineColor);
        g.drawLine(x + INDENT_GUIDE_DELTA, (int)yStart, x + INDENT_GUIDE_DELTA, (int)yEnd + 1);
    }

    public static int compare(@NotNull TextRangeDescriptorPair r, @NotNull RangeHighlighter h) {
        int answer;
        if (r == null) {
            WidgetIndentsHighlightingPass.$$$reportNull$$$0(2);
        }
        if (h == null) {
            WidgetIndentsHighlightingPass.$$$reportNull$$$0(3);
        }
        if ((answer = r.range.getStartOffset() - h.getStartOffset()) != 0) {
            return answer;
        }
        answer = r.range.getEndOffset() - h.getEndOffset();
        if (answer != 0) {
            return answer;
        }
        CustomHighlighterRenderer renderer = h.getCustomRenderer();
        if (renderer instanceof WidgetCustomHighlighterRenderer) {
            WidgetCustomHighlighterRenderer widgetRenderer = (WidgetCustomHighlighterRenderer)renderer;
            return widgetRenderer.descriptor.compareTo(r.descriptor);
        }
        return -1;
    }

    public static boolean isIndentGuideHidden(@NotNull Editor editor, @NotNull LineRange lineRange) {
        WidgetIndentsPassData data;
        if (editor == null) {
            WidgetIndentsHighlightingPass.$$$reportNull$$$0(4);
        }
        if (lineRange == null) {
            WidgetIndentsHighlightingPass.$$$reportNull$$$0(5);
        }
        return (data = WidgetIndentsHighlightingPass.getIndentsPassData(editor)) != null && WidgetIndentsHighlightingPass.isIndentGuideHidden(data.hitTester, lineRange);
    }

    public static boolean isIndentGuideHidden(WidgetIndentHitTester hitTester, @NotNull LineRange lineRange) {
        if (lineRange == null) {
            WidgetIndentsHighlightingPass.$$$reportNull$$$0(6);
        }
        return hitTester != null && hitTester.intersects(lineRange);
    }

    public static void onCaretPositionChanged(EditorEx editor, Caret caret) {
        WidgetIndentsPassData data = WidgetIndentsHighlightingPass.getIndentsPassData((Editor)editor);
        if (data == null || data.highlighters == null) {
            return;
        }
        for (RangeHighlighter h : data.highlighters) {
            WidgetCustomHighlighterRenderer renderer;
            boolean changed;
            if (!(h.getCustomRenderer() instanceof WidgetCustomHighlighterRenderer) || !(changed = (renderer = (WidgetCustomHighlighterRenderer)h.getCustomRenderer()).updateSelected((Editor)editor, h, caret))) continue;
            editor.repaint(h.getStartOffset(), h.getEndOffset());
        }
    }

    private static WidgetIndentsPassData getIndentsPassData(Editor editor) {
        if (editor == null) {
            return null;
        }
        return (WidgetIndentsPassData)editor.getUserData(INDENTS_PASS_DATA_KEY);
    }

    public static void disposeHighlighter(RangeHighlighter highlighter) {
        CustomHighlighterRenderer renderer = highlighter.getCustomRenderer();
        if (renderer instanceof WidgetCustomHighlighterRenderer) {
            ((WidgetCustomHighlighterRenderer)renderer).dispose();
        }
        highlighter.dispose();
    }

    public static void cleanupHighlighters(Editor editor) {
        WidgetIndentsPassData data = WidgetIndentsHighlightingPass.getIndentsPassData(editor);
        if (data == null) {
            return;
        }
        List<RangeHighlighter> oldHighlighters = data.highlighters;
        if (oldHighlighters != null) {
            for (RangeHighlighter highlighter : oldHighlighters) {
                WidgetIndentsHighlightingPass.disposeHighlighter(highlighter);
            }
        }
        WidgetIndentsHighlightingPass.setIndentsPassData(editor, null);
    }

    public static void run(@NotNull Project project, @NotNull EditorEx editor, @NotNull FlutterOutline outline, FlutterDartAnalysisServer flutterDartAnalysisService, InspectorGroupManagerService inspectorGroupManagerService, EditorMouseEventService editorEventService, EditorPositionService editorPositionService, boolean convertOffsets) {
        if (project == null) {
            WidgetIndentsHighlightingPass.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            WidgetIndentsHighlightingPass.$$$reportNull$$$0(8);
        }
        if (outline == null) {
            WidgetIndentsHighlightingPass.$$$reportNull$$$0(9);
        }
        WidgetIndentsHighlightingPass widgetIndentsHighlightingPass = new WidgetIndentsHighlightingPass(project, editor, convertOffsets, flutterDartAnalysisService, inspectorGroupManagerService, editorEventService, editorPositionService);
        widgetIndentsHighlightingPass.setOutline(outline);
    }

    public void setOutline(FlutterOutline outline) {
        assert (outline != null);
        WidgetIndentsPassData data = this.getIndentsPassData();
        if (data.outline == outline) {
            return;
        }
        ArrayList<WidgetIndentGuideDescriptor> descriptors = new ArrayList<WidgetIndentGuideDescriptor>();
        this.buildWidgetDescriptors(descriptors, outline, null);
        this.updateHitTester(new WidgetIndentHitTester(descriptors, this.myDocument), data);
        data.myDescriptors = descriptors;
        this.doCollectInformationUpdateOutline(data);
        this.doApplyIndentInformationToEditor(data);
        this.setIndentsPassData(data);
        this.updatePreviewHighlighter((MarkupModel)this.myEditor.getMarkupModel(), data);
    }

    private void updateHitTester(WidgetIndentHitTester hitTester, WidgetIndentsPassData data) {
        if (Objects.equals(data.hitTester, hitTester)) {
            return;
        }
        FilteredIndentsHighlightingPass.onWidgetIndentsChanged(this.myEditor, data.hitTester, hitTester);
        data.hitTester = hitTester;
    }

    private WidgetIndentsPassData getIndentsPassData() {
        WidgetIndentsPassData data = WidgetIndentsHighlightingPass.getIndentsPassData((Editor)this.myEditor);
        if (data == null) {
            data = new WidgetIndentsPassData();
        }
        return data;
    }

    static void setIndentsPassData(Editor editor, WidgetIndentsPassData data) {
        editor.putUserData(INDENTS_PASS_DATA_KEY, (Object)data);
    }

    void setIndentsPassData(WidgetIndentsPassData data) {
        WidgetIndentsHighlightingPass.setIndentsPassData((Editor)this.myEditor, data);
    }

    public void doCollectInformationUpdateOutline(WidgetIndentsPassData data) {
        assert (this.myDocument != null);
        if (data.myDescriptors != null) {
            ArrayList<TextRangeDescriptorPair> ranges = new ArrayList<TextRangeDescriptorPair>();
            for (WidgetIndentGuideDescriptor descriptor : data.myDescriptors) {
                TextRange range;
                ProgressManager.checkCanceled();
                if (descriptor.widget != null) {
                    range = descriptor.widget.getFullRange();
                } else {
                    int endOffset = descriptor.endLine < this.myDocument.getLineCount() ? this.myDocument.getLineStartOffset(descriptor.endLine) : this.myDocument.getTextLength();
                    range = new TextRange(this.myDocument.getLineStartOffset(descriptor.startLine), endOffset);
                }
                descriptor.trackLocations(this.myDocument);
                ranges.add(new TextRangeDescriptorPair(range, descriptor));
            }
            ranges.sort((a, b) -> Segment.BY_START_OFFSET_THEN_END_OFFSET.compare(a.range, b.range));
            data.myRangesWidgets = ranges;
        }
    }

    public void doApplyIndentInformationToEditor(WidgetIndentsPassData data) {
        MarkupModelEx mm = this.myEditor.getMarkupModel();
        List<RangeHighlighter> oldHighlighters = data.highlighters;
        ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>();
        int curRange = 0;
        List<TextRangeDescriptorPair> ranges = data.myRangesWidgets;
        if (oldHighlighters != null) {
            RangeHighlighter highlighter;
            oldHighlighters.sort(Comparator.comparing(h -> !h.isValid()).thenComparing(Segment.BY_START_OFFSET_THEN_END_OFFSET));
            int curHighlight = 0;
            while (curRange < ranges.size() && curHighlight < oldHighlighters.size()) {
                TextRangeDescriptorPair entry = ranges.get(curRange);
                RangeHighlighter highlighter2 = oldHighlighters.get(curHighlight);
                if (!highlighter2.isValid()) break;
                int cmp = WidgetIndentsHighlightingPass.compare(entry, highlighter2);
                if (cmp < 0) {
                    newHighlighters.add(this.createHighlighter((MarkupModel)mm, entry, data));
                    ++curRange;
                    continue;
                }
                if (cmp > 0) {
                    WidgetIndentsHighlightingPass.disposeHighlighter(highlighter2);
                    ++curHighlight;
                    continue;
                }
                newHighlighters.add(highlighter2);
                ++curHighlight;
                ++curRange;
            }
            while (curHighlight < oldHighlighters.size() && (highlighter = oldHighlighters.get(curHighlight)).isValid()) {
                WidgetIndentsHighlightingPass.disposeHighlighter(highlighter);
                ++curHighlight;
            }
        }
        int startRangeIndex = curRange;
        assert (this.myDocument != null);
        DocumentUtil.executeInBulk((Document)this.myDocument, (ranges.size() > 10000 ? 1 : 0) != 0, () -> this.lambda$doApplyIndentInformationToEditor$2(startRangeIndex, ranges, newHighlighters, (MarkupModel)mm, data));
        data.highlighters = newHighlighters;
    }

    private DartAnalysisServerService getAnalysisService() {
        return DartAnalysisServerService.getInstance((Project)this.myProject);
    }

    int getConvertedOffset(FlutterOutline node) {
        return this.getConvertedOffset(node.getOffset());
    }

    int getConvertedOffset(int offset) {
        return this.convertOffsets ? this.getAnalysisService().getConvertedOffset(this.myFile, offset) : offset;
    }

    private OutlineLocation computeLocation(FlutterOutline node) {
        int indent;
        assert (this.myDocument != null);
        int documentLength = this.myDocument.getTextLength();
        int rawOffset = this.getConvertedOffset(node);
        int nodeOffset = Math.min(rawOffset, documentLength);
        int line = this.myDocument.getLineNumber(nodeOffset);
        int lineStartOffset = this.myDocument.getLineStartOffset(line);
        int column = nodeOffset - lineStartOffset;
        CharSequence chars = this.myDocument.getCharsSequence();
        for (indent = 0; indent < column && Character.isWhitespace(chars.charAt(lineStartOffset + indent)); ++indent) {
        }
        return new OutlineLocation(node, line, column, indent, this.myFile, this);
    }

    DartCallExpression getCallExpression(PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof DartCallExpression) {
            return (DartCallExpression)element;
        }
        return this.getCallExpression(element.getParent());
    }

    private void buildWidgetDescriptors(List<WidgetIndentGuideDescriptor> widgetDescriptors, FlutterOutline outlineNode, WidgetIndentGuideDescriptor parent) {
        if (outlineNode == null) {
            return;
        }
        String kind = outlineNode.getKind();
        boolean widgetConstructor = "NEW_INSTANCE".equals(kind) || parent != null && "VARIABLE".equals(kind);
        List<FlutterOutline> children = outlineNode.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        if (widgetConstructor) {
            OutlineLocation location = this.computeLocation(outlineNode);
            int minChildIndent = Integer.MAX_VALUE;
            ArrayList<OutlineLocation> childrenLocations = new ArrayList<OutlineLocation>();
            int endLine = location.getLine();
            for (FlutterOutline flutterOutline : children) {
                OutlineLocation childLocation = this.computeLocation(flutterOutline);
                if (childLocation.getLine() <= location.getLine()) continue;
                minChildIndent = Math.min(minChildIndent, childLocation.getIndent());
                endLine = Math.max(endLine, childLocation.getLine());
                childrenLocations.add(childLocation);
            }
            HashSet<Integer> childrenOffsets = new HashSet<Integer>();
            for (OutlineLocation childLocation : childrenLocations) {
                childrenOffsets.add(childLocation.getGuideOffset());
            }
            PsiElement psiElement = this.psiFile.findElementAt(location.getGuideOffset());
            if (!childrenLocations.isEmpty()) {
                int lineIndent = location.getIndent();
                WidgetIndentGuideDescriptor descriptor = new WidgetIndentGuideDescriptor(parent, lineIndent, location.getLine(), endLine + 1, childrenLocations, location, outlineNode);
                if (!descriptor.childLines.isEmpty()) {
                    widgetDescriptors.add(descriptor);
                    parent = descriptor;
                }
            }
        }
        for (FlutterOutline child : children) {
            this.buildWidgetDescriptors(widgetDescriptors, child, parent);
        }
    }

    @NotNull
    private RangeHighlighter createHighlighter(MarkupModel mm, TextRangeDescriptorPair entry, WidgetIndentsPassData data) {
        TextRange range = entry.range;
        FlutterSettings settings = FlutterSettings.getInstance();
        if (range.getEndOffset() >= this.myDocument.getTextLength()) {
            // empty if block
        }
        RangeHighlighter highlighter = mm.addRangeHighlighter(Math.max(range.getStartOffset(), 0), Math.min(range.getEndOffset(), this.myDocument.getTextLength()), 1000, null, HighlighterTargetArea.EXACT_RANGE);
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new WidgetCustomHighlighterRenderer(entry.descriptor, this.myDocument));
        RangeHighlighter rangeHighlighter = highlighter;
        if (rangeHighlighter == null) {
            WidgetIndentsHighlightingPass.$$$reportNull$$$0(10);
        }
        return rangeHighlighter;
    }

    private void updatePreviewHighlighter(MarkupModel mm, WidgetIndentsPassData data) {
        FlutterSettings settings = FlutterSettings.getInstance();
        if (!settings.isEnableHotUiInCodeEditor()) {
            return;
        }
        if (data.previewsForEditor == null && this.myEditor instanceof EditorImpl) {
            Disposable parentDisposable = ((EditorImpl)this.myEditor).getDisposable();
            TextRange range = new TextRange(0, Integer.MAX_VALUE);
            RangeHighlighter highlighter = mm.addRangeHighlighter(0, this.myDocument.getTextLength(), 1000, null, HighlighterTargetArea.LINES_IN_RANGE);
            data.previewsForEditor = new PreviewsForEditor(this.context, this.editorEventService, this.myEditor, parentDisposable);
            highlighter.setCustomRenderer((CustomHighlighterRenderer)data.previewsForEditor);
        }
        if (data.previewsForEditor != null) {
            data.previewsForEditor.outlinesChanged(data.myDescriptors);
        }
    }

    private /* synthetic */ void lambda$doApplyIndentInformationToEditor$2(int startRangeIndex, List ranges, List newHighlighters, MarkupModel mm, WidgetIndentsPassData data) {
        for (int i = startRangeIndex; i < ranges.size(); ++i) {
            newHighlighters.add(this.createHighlighter(mm, (TextRangeDescriptorPair)ranges.get(i), data));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineRange";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outline";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/editor/WidgetIndentsHighlightingPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/editor/WidgetIndentsHighlightingPass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isIndentGuideHidden";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }

    private static class WidgetCustomHighlighterRenderer
    implements CustomHighlighterRenderer {
        @NotNull
        private final WidgetIndentGuideDescriptor descriptor;
        @NotNull
        private final Document document;
        private boolean isSelected;

        WidgetCustomHighlighterRenderer(@NotNull WidgetIndentGuideDescriptor descriptor, @NotNull Document document) {
            if (descriptor == null) {
                WidgetCustomHighlighterRenderer.$$$reportNull$$$0(0);
            }
            if (document == null) {
                WidgetCustomHighlighterRenderer.$$$reportNull$$$0(1);
            }
            this.isSelected = false;
            this.descriptor = descriptor;
            this.document = document;
            descriptor.trackLocations(document);
        }

        void dispose() {
            this.descriptor.dispose();
        }

        boolean setSelection(boolean value) {
            if (value == this.isSelected) {
                return false;
            }
            this.isSelected = value;
            return true;
        }

        boolean updateSelected(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, Caret carat) {
            int off;
            if (editor == null) {
                WidgetCustomHighlighterRenderer.$$$reportNull$$$0(2);
            }
            if (highlighter == null) {
                WidgetCustomHighlighterRenderer.$$$reportNull$$$0(3);
            }
            if (carat == null) {
                return this.setSelection(false);
            }
            CaretModel caretModel = editor.getCaretModel();
            int startOffset = highlighter.getStartOffset();
            Document doc = highlighter.getDocument();
            int caretOffset = carat.getOffset();
            if (startOffset < 0 || startOffset >= doc.getTextLength()) {
                return this.setSelection(false);
            }
            int endOffset = highlighter.getEndOffset();
            int startLine = doc.getLineNumber(startOffset);
            CharSequence chars = doc.getCharsSequence();
            do {
                int start = doc.getLineStartOffset(startLine);
                int end = doc.getLineEndOffset(startLine);
                off = CharArrayUtil.shiftForward((CharSequence)chars, (int)start, (int)end, (String)" \t");
            } while (--startLine > 1 && off < doc.getTextLength() && chars.charAt(off) == '\n');
            VisualPosition startPosition = editor.offsetToVisualPosition(off);
            int indentColumn = startPosition.column;
            LogicalPosition logicalPosition = caretModel.getLogicalPosition();
            if (logicalPosition.line == startLine + 1 && this.descriptor.widget != null) {
                return this.setSelection(caretModel.getLogicalPosition().column >= indentColumn);
            }
            return this.setSelection(caretOffset >= off && caretOffset < endOffset && caretModel.getLogicalPosition().column == indentColumn);
        }

        public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
            Rectangle clip;
            int off;
            if (editor == null) {
                WidgetCustomHighlighterRenderer.$$$reportNull$$$0(4);
            }
            if (highlighter == null) {
                WidgetCustomHighlighterRenderer.$$$reportNull$$$0(5);
            }
            if (g == null) {
                WidgetCustomHighlighterRenderer.$$$reportNull$$$0(6);
            }
            if (!highlighter.isValid()) {
                return;
            }
            if (!this.descriptor.widget.isValid()) {
                return;
            }
            FlutterSettings settings = FlutterSettings.getInstance();
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            int startOffset = highlighter.getStartOffset();
            Document doc = highlighter.getDocument();
            int textLength = doc.getTextLength();
            if (startOffset >= textLength) {
                return;
            }
            int endOffset = Math.min(highlighter.getEndOffset(), textLength);
            int startLine = doc.getLineNumber(startOffset);
            CharSequence chars = doc.getCharsSequence();
            do {
                int start = doc.getLineStartOffset(startLine);
                int end = doc.getLineEndOffset(startLine);
                off = CharArrayUtil.shiftForward((CharSequence)chars, (int)start, (int)end, (String)" \t");
            } while (--startLine > 1 && off < doc.getTextLength() && chars.charAt(off) == '\n');
            VisualPosition startPosition = editor.offsetToVisualPosition(off);
            int indentColumn = startPosition.column;
            int lineShift = 1;
            if (indentColumn <= 0) {
                indentColumn = this.descriptor.indentLevel;
                lineShift = 0;
            }
            if (indentColumn <= 0) {
                return;
            }
            FoldingModel foldingModel = editor.getFoldingModel();
            if (foldingModel.isOffsetCollapsed(off)) {
                return;
            }
            FoldRegion headerRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineEndOffset(doc.getLineNumber(off)));
            FoldRegion tailRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineStartOffset(doc.getLineNumber(endOffset)));
            if (tailRegion != null && tailRegion == headerRegion) {
                return;
            }
            CaretModel caretModel = editor.getCaretModel();
            int caretOffset = caretModel.getOffset();
            boolean selected = this.isSelected;
            Point start = editor.visualPositionToXY(new VisualPosition(startPosition.line + lineShift, indentColumn));
            VisualPosition endPosition = editor.offsetToVisualPosition(endOffset);
            ArrayList<OutlineLocation> childLines = this.descriptor.childLines;
            Point end = editor.visualPositionToXY(endPosition);
            double splitY = -1.0;
            int maxY = end.y;
            boolean includeLastLine = false;
            if (endPosition.line == editor.offsetToVisualPosition((int)doc.getTextLength()).line) {
                includeLastLine = true;
            }
            int endLine = doc.getLineNumber(endOffset);
            if (childLines != null && !childLines.isEmpty()) {
                VisualPosition endPositionLastChild = editor.offsetToVisualPosition(childLines.get(childLines.size() - 1).getGuideOffset());
                if (endPositionLastChild.line == endPosition.line) {
                    includeLastLine = true;
                    if (endLine + 1 < this.document.getLineCount()) {
                        ++endLine;
                    }
                }
            }
            if (includeLastLine) {
                maxY += editor.getLineHeight();
            }
            if ((clip = g2d.getClipBounds()) != null) {
                if (clip.y > maxY || clip.y + clip.height < start.y) {
                    return;
                }
                maxY = Math.min(maxY, clip.y + clip.height);
            }
            EditorColorsScheme scheme = editor.getColorsScheme();
            JBColor lineColor = selected ? JBColor.BLUE : OUTLINE_LINE_COLOR;
            g2d.setColor((Color)lineColor);
            JBColor pastBlockColor = selected ? scheme.getColor(EditorColors.SELECTED_INDENT_GUIDE_COLOR) : OUTLINE_LINE_COLOR_PAST_BLOCK;
            int y = start.y;
            int newY = start.y;
            int maxYWithChildren = y;
            SoftWrapModel softWrapModel = editor.getSoftWrapModel();
            int lineHeight = editor.getLineHeight();
            int iChildLine = 0;
            for (int i = Math.max(0, startLine + lineShift); i < endLine && newY < maxY; ++i) {
                FoldRegion foldRegion;
                OutlineLocation childLine = null;
                if (childLines != null) {
                    while (iChildLine < childLines.size()) {
                        OutlineLocation currentChildLine = childLines.get(iChildLine);
                        if (currentChildLine.isValid()) {
                            if (currentChildLine.getLine() > i) break;
                            if (currentChildLine.getLine() == i) {
                                childLine = currentChildLine;
                                if (++iChildLine < childLines.size()) break;
                                splitY = (double)newY + (double)lineHeight * 0.5;
                                break;
                            }
                        }
                        ++iChildLine;
                    }
                    if (childLine != null) {
                        int childIndent = childLine.getIndent();
                        GuidelineOffsetDetail guidelineOffsetDetail = this.getGuidelineOffsetDetail(childLine, editor, doc, chars);
                        VisualPosition widgetVisualPosition = editor.offsetToVisualPosition(guidelineOffsetDetail.textStartOffset);
                        Point widgetPoint = editor.visualPositionToXY(widgetVisualPosition);
                        int deltaX = widgetPoint.x - start.x;
                        int padding = Math.max(Math.min(Math.abs(deltaX) / 3, 6), 2);
                        if (deltaX > 0) {
                            LinePainter2D.paint((Graphics2D)g2d, (double)(start.x + INDENT_GUIDE_DELTA), (double)((double)newY + (double)lineHeight * 0.5), (double)(widgetPoint.x - padding), (double)((double)newY + (double)lineHeight * 0.5));
                        } else {
                            if (guidelineOffsetDetail.textStartOffset != guidelineOffsetDetail.offset) {
                                return;
                            }
                            int loopBackLength = 6;
                            int endX = widgetPoint.x - padding;
                            LinePainter2D.paint((Graphics2D)g2d, (double)(start.x + INDENT_GUIDE_DELTA), (double)newY, (double)endX, (double)newY);
                            LinePainter2D.paint((Graphics2D)g2d, (double)endX, (double)newY, (double)endX, (double)((double)newY + (double)lineHeight * 0.5));
                            LinePainter2D.paint((Graphics2D)g2d, (double)endX, (double)((double)newY + (double)lineHeight * 0.5), (double)(endX + 6), (double)((double)newY + (double)lineHeight * 0.5));
                        }
                    }
                }
                if ((foldRegion = foldingModel.getCollapsedRegionAtOffset(doc.getLineEndOffset(i))) != null && foldRegion.getEndOffset() < doc.getTextLength()) {
                    i = doc.getLineNumber(foldRegion.getEndOffset()) - 1;
                    continue;
                }
                List softWraps = softWrapModel.getSoftWrapsForLine(i);
                int logicalLineHeight = softWraps.size() * lineHeight;
                if (i > startLine + lineShift) {
                    logicalLineHeight += lineHeight;
                }
                if (!softWraps.isEmpty() && ((SoftWrap)softWraps.get(0)).getIndentInColumns() < indentColumn) {
                    if (y < newY || i > startLine + lineShift) {
                        WidgetIndentsHighlightingPass.drawVerticalLineHelper(g2d, (Color)lineColor, start.x, y, newY + lineHeight, childLines);
                    }
                    y = newY += logicalLineHeight;
                    continue;
                }
                newY += logicalLineHeight;
            }
            if (childLines != null && iChildLine < childLines.size() && splitY == -1.0) {
                splitY = maxY;
            }
            if (y < maxY) {
                if (splitY != -1.0) {
                    WidgetIndentsHighlightingPass.drawVerticalLineHelper(g2d, (Color)lineColor, start.x, y, splitY, childLines);
                    g2d.setColor((Color)pastBlockColor);
                    g2d.drawLine(start.x + INDENT_GUIDE_DELTA, (int)splitY + 1, start.x + INDENT_GUIDE_DELTA, maxY);
                } else {
                    g2d.setColor((Color)pastBlockColor);
                    g2d.drawLine(start.x + INDENT_GUIDE_DELTA, y, start.x + INDENT_GUIDE_DELTA, maxY);
                }
            }
            g2d.dispose();
        }

        private GuidelineOffsetDetail getGuidelineOffsetDetail(OutlineLocation childLine, Editor editor, Document doc, CharSequence chars) {
            int startIndex = doc.getLineStartOffset(childLine.getLine());
            int endIndex = doc.getLineEndOffset(childLine.getLine());
            int firstCharPosition = 0;
            while (startIndex + firstCharPosition < endIndex && Character.isWhitespace(chars.charAt(startIndex + firstCharPosition))) {
                ++firstCharPosition;
            }
            return new GuidelineOffsetDetail(childLine.getGuideOffset(), editor.logicalPositionToOffset(new LogicalPosition(childLine.getLine(), firstCharPosition)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/editor/WidgetIndentsHighlightingPass$WidgetCustomHighlighterRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateSelected";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class GuidelineOffsetDetail {
            final int offset;
            final int textStartOffset;

            GuidelineOffsetDetail(int offset, int textStartOffset) {
                this.offset = offset;
                this.textStartOffset = textStartOffset;
            }
        }
    }
}

