/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.application.options.editor.EditorOptionsListener;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.EdtInvocationManager;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import io.flutter.FlutterUtils;
import io.flutter.dart.FlutterDartAnalysisServer;
import io.flutter.editor.ActiveEditorsOutlineService;
import io.flutter.editor.EditorMouseEventService;
import io.flutter.editor.EditorPositionService;
import io.flutter.editor.FilteredIndentsHighlightingPass;
import io.flutter.editor.WidgetIndentsHighlightingPass;
import io.flutter.inspector.InspectorGroupManagerService;
import io.flutter.inspector.InspectorService;
import io.flutter.settings.FlutterSettings;
import java.util.Objects;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetIndentsHighlightingPassFactory
implements TextEditorHighlightingPassFactory,
Disposable,
DumbAware {
    private static final boolean SIMULATE_SLOW_ANALYSIS_UPDATES = false;
    @NotNull
    private final Project project;
    private final FlutterSettings.Listener settingsListener;
    private final ActiveEditorsOutlineService.Listener outlineListener;
    protected InspectorService inspectorService;
    private boolean isShowBuildMethodGuides;
    private boolean isIndentGuidesShown;

    @Nullable
    public static WidgetIndentsHighlightingPassFactory getInstance(Project project) {
        return (WidgetIndentsHighlightingPassFactory)project.getService(WidgetIndentsHighlightingPassFactory.class);
    }

    public WidgetIndentsHighlightingPassFactory(final @NotNull Project project) {
        if (project == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(0);
        }
        this.project = project;
        this.settingsListener = this::onSettingsChanged;
        this.outlineListener = this::updateEditor;
        this.syncSettings(FlutterSettings.getInstance());
        FlutterSettings.getInstance().addListener(this.settingsListener);
        this.isIndentGuidesShown = EditorSettingsExternalizable.getInstance().isIndentGuidesShown();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(EditorOptionsListener.APPEARANCE_CONFIGURABLE_TOPIC, () -> {
            boolean newValue = EditorSettingsExternalizable.getInstance().isIndentGuidesShown();
            if (this.isIndentGuidesShown != newValue) {
                this.isIndentGuidesShown = newValue;
                this.updateAllEditors();
            }
        });
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Editor editor;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((editor = event.getEditor()).getProject() != project) {
                    return;
                }
                if (editor.isDisposed() || project.isDisposed()) {
                    return;
                }
                if (!(editor instanceof EditorEx)) {
                    return;
                }
                EditorEx editorEx = (EditorEx)editor;
                WidgetIndentsHighlightingPass.onCaretPositionChanged(editorEx, event.getCaret());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/editor/WidgetIndentsHighlightingPassFactory$1", "caretPositionChanged"));
            }
        }, (Disposable)this);
        this.getEditorOutlineService().addListener(this.outlineListener);
    }

    @NotNull
    private FlutterDartAnalysisServer getAnalysisService() {
        FlutterDartAnalysisServer flutterDartAnalysisServer = FlutterDartAnalysisServer.getInstance(this.project);
        if (flutterDartAnalysisServer == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(1);
        }
        return flutterDartAnalysisServer;
    }

    @NotNull
    private InspectorGroupManagerService getInspectorGroupManagerService() {
        InspectorGroupManagerService inspectorGroupManagerService = InspectorGroupManagerService.getInstance(this.project);
        if (inspectorGroupManagerService == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(2);
        }
        return inspectorGroupManagerService;
    }

    @NotNull
    private EditorMouseEventService getEditorEventService() {
        EditorMouseEventService editorMouseEventService = EditorMouseEventService.getInstance(this.project);
        if (editorMouseEventService == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(3);
        }
        return editorMouseEventService;
    }

    @NotNull
    private EditorPositionService getEditorPositionService() {
        EditorPositionService editorPositionService = EditorPositionService.getInstance(this.project);
        if (editorPositionService == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(4);
        }
        return editorPositionService;
    }

    @NotNull
    private ActiveEditorsOutlineService getEditorOutlineService() {
        ActiveEditorsOutlineService activeEditorsOutlineService = ActiveEditorsOutlineService.getInstance(this.project);
        if (activeEditorsOutlineService == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(5);
        }
        return activeEditorsOutlineService;
    }

    private void syncSettings(FlutterSettings settings) {
        if (this.isShowBuildMethodGuides != settings.isShowBuildMethodGuides()) {
            this.isShowBuildMethodGuides = settings.isShowBuildMethodGuides();
            this.updateAllEditors();
        }
    }

    private void updateEditor(@NotNull String path, @Nullable FlutterOutline outline) {
        if (path == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.project.isDisposed()) {
                return;
            }
            for (EditorEx editor : this.getEditorOutlineService().getActiveDartEditors()) {
                String filePath = editor.getVirtualFile().getCanonicalPath();
                if (editor.isDisposed() || !Objects.equals(filePath, path)) continue;
                this.runWidgetIndentsPass(editor, outline);
            }
        });
    }

    private void updateAllEditors() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.project.isDisposed()) {
                return;
            }
            for (EditorEx editor : this.getEditorOutlineService().getActiveDartEditors()) {
                if (editor.isDisposed()) continue;
                this.runWidgetIndentsPass(editor, this.getEditorOutlineService().getOutline(editor.getVirtualFile().getCanonicalPath()));
            }
        });
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor e) {
        FilteredIndentsHighlightingPass highlightingPass;
        if (file == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(7);
        }
        if (e == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(8);
        }
        if (file.getVirtualFile() == null) {
            return null;
        }
        if (!FlutterUtils.isDartFile(file.getVirtualFile())) {
            return null;
        }
        if (!this.isShowBuildMethodGuides) {
            ApplicationManager.getApplication().invokeLater(() -> {
                e.getSettings().setIndentGuidesShown(this.isIndentGuidesShown);
                FilteredIndentsHighlightingPass.cleanupHighlighters(e);
            });
            return null;
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            e.getSettings().setIndentGuidesShown(false);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!e.isDisposed()) {
                    e.getSettings().setIndentGuidesShown(false);
                }
            });
        }
        if (this.isIndentGuidesShown) {
            highlightingPass = new FilteredIndentsHighlightingPass(this.project, e, file);
        } else {
            highlightingPass = null;
            FilteredIndentsHighlightingPass.cleanupHighlighters(e);
        }
        if (!(e instanceof EditorEx)) {
            return highlightingPass;
        }
        EditorEx editor = (EditorEx)e;
        VirtualFile virtualFile = editor.getVirtualFile();
        if (!FlutterUtils.couldContainWidgets(virtualFile)) {
            return highlightingPass;
        }
        FlutterOutline outline = this.getEditorOutlineService().getOutline(virtualFile.getCanonicalPath());
        if (outline != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.runWidgetIndentsPass(editor, outline));
        }
        return highlightingPass;
    }

    void runWidgetIndentsPass(EditorEx editor, FlutterOutline outline) {
        int outlineLength;
        if (editor.isDisposed() || this.project.isDisposed()) {
            return;
        }
        if (!this.isShowBuildMethodGuides || outline == null) {
            WidgetIndentsHighlightingPass.cleanupHighlighters((Editor)editor);
            return;
        }
        VirtualFile file = editor.getVirtualFile();
        if (!FlutterUtils.couldContainWidgets(file)) {
            return;
        }
        DocumentEx document = editor.getDocument();
        int documentLength = document.getTextLength();
        if (documentLength != (outlineLength = outline.getLength()) && documentLength != DartAnalysisServerService.getInstance((Project)this.project).getConvertedOffset(file, outlineLength)) {
            return;
        }
        boolean convertOffsets = documentLength != outlineLength;
        WidgetIndentsHighlightingPass.run(this.project, editor, outline, this.getAnalysisService(), this.getInspectorGroupManagerService(), this.getEditorEventService(), this.getEditorPositionService(), convertOffsets);
    }

    public void dispose() {
        FlutterSettings.getInstance().removeListener(this.settingsListener);
        this.getEditorOutlineService().removeListener(this.outlineListener);
    }

    void onSettingsChanged() {
        if (this.project.isDisposed()) {
            return;
        }
        FlutterSettings settings = FlutterSettings.getInstance();
        if (this.isShowBuildMethodGuides == settings.isShowBuildMethodGuides()) {
            return;
        }
        this.syncSettings(settings);
    }

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar) {
        if (registrar == null) {
            WidgetIndentsHighlightingPassFactory.$$$reportNull$$$0(9);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.AFTER, 1, false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/editor/WidgetIndentsHighlightingPassFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/editor/WidgetIndentsHighlightingPassFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalysisService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorGroupManagerService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorEventService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorPositionService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorOutlineService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateEditor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightingPass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlightingPassFactory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

