/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import io.flutter.editor.EditorMouseEventService;
import io.flutter.editor.WidgetViewModelData;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.InspectorGroupManagerService;
import io.flutter.inspector.InspectorObjectGroupManager;
import io.flutter.inspector.InspectorService;
import io.flutter.run.daemon.FlutterApp;
import java.awt.Rectangle;
import java.util.ArrayList;

public abstract class WidgetViewController
implements EditorMouseEventService.Listener,
Disposable {
    protected boolean isSelected = false;
    protected final WidgetViewModelData data;
    protected boolean visible = false;
    Rectangle visibleRect;
    DiagnosticsNode inspectorSelection;
    final InspectorGroupManagerService.Client groupClient;
    public ArrayList<DiagnosticsNode> elements;
    public int activeIndex = 0;

    protected abstract void onFlutterFrame();

    public InspectorObjectGroupManager getGroupManagner() {
        return this.groupClient.getGroupManager();
    }

    public FlutterApp getApp() {
        return this.groupClient.getApp();
    }

    InspectorObjectGroupManager getGroups() {
        return this.groupClient.getGroupManager();
    }

    WidgetViewController(WidgetViewModelData data, Disposable parent) {
        this.data = data;
        Disposer.register((Disposable)parent, (Disposable)this);
        this.groupClient = new InspectorGroupManagerService.Client(this){

            @Override
            public void onInspectorAvailabilityChanged() {
                WidgetViewController.this.onInspectorAvailabilityChanged();
            }

            @Override
            public void requestRepaint(boolean force) {
                this.onFlutterFrame();
            }

            @Override
            public void onFlutterFrame() {
                WidgetViewController.this.onFlutterFrame();
            }

            @Override
            public void onSelectionChanged(DiagnosticsNode selection) {
                WidgetViewController.this.onSelectionChanged(selection);
            }
        };
        data.context.inspectorGroupManagerService.addListener(this.groupClient, parent);
    }

    public void onVisibleChanged() {
    }

    public boolean updateVisiblityLocked(Rectangle newRectangle) {
        return false;
    }

    public void onInspectorAvailabilityChanged() {
        this.setElements(null);
        this.inspectorSelection = null;
        this.onVisibleChanged();
        this.forceRender();
    }

    public abstract void forceRender();

    public InspectorService getInspectorService() {
        return this.groupClient.getInspectorService();
    }

    public void dispose() {
    }

    public void onSelectionChanged(DiagnosticsNode selection) {
        InspectorObjectGroupManager manager = this.getGroups();
        if (manager != null) {
            manager.cancelNext();
        }
    }

    abstract InspectorService.Location getLocation();

    public boolean isElementsEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }

    public void setElements(ArrayList<DiagnosticsNode> elements) {
        this.elements = elements;
    }

    public void onActiveElementsChanged() {
        if (this.isElementsEmpty()) {
            return;
        }
        InspectorObjectGroupManager manager = this.getGroups();
        if (manager == null) {
            return;
        }
        if (this.isSelected) {
            manager.getCurrent().setSelection(this.getSelectedElement().getValueRef(), false, true);
        }
    }

    public DiagnosticsNode getSelectedElement() {
        if (this.isElementsEmpty()) {
            return null;
        }
        return this.elements.get(0);
    }
}

