/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.font;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.ide.index.DartLibraryIndex;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.resolve.ClassNameScopeProcessor;
import com.jetbrains.lang.dart.resolve.DartPsiScopeProcessor;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import io.flutter.FlutterBundle;
import io.flutter.editor.FlutterIconLineMarkerProvider;
import io.flutter.settings.FlutterSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontPreviewProcessor {
    public static final String PACKAGE_SEPARATORS = "[,\r\n]";
    public static final Map<String, String> UNSUPPORTED_PACKAGES = new THashMap();
    private static final Pattern EXPORT_STATEMENT_PATTERN = Pattern.compile("^\\s*export\\s+[\"']([-_. $A-Za-z0-9/]+\\.dart)[\"'].*");
    private static final Pattern IMPORT_STATEMENT_PATTERN = Pattern.compile("^\\s*import\\s+[\"']([-_. $A-Za-z0-9/]+\\.dart)[\"'].*");
    private static final Map<String, Set<String>> ANALYZED_PROJECT_FILES = new THashMap();
    private static final Map<String, WorkItem> WORK_ITEMS = new THashMap();
    private static Logger LOG = Logger.getInstance(FontPreviewProcessor.class);

    public static void analyze(@NotNull Project project) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(0);
        }
        FontPreviewProcessor service = (FontPreviewProcessor)ApplicationManager.getApplication().getService(FontPreviewProcessor.class);
        service.generate(project);
    }

    public static void reanalyze(@NotNull Project project) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(1);
        }
        FontPreviewProcessor.clearProjectCaches(project);
        FontPreviewProcessor.analyze(project);
    }

    public void generate(@NotNull Project project) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(2);
        }
        if (ANALYZED_PROJECT_FILES.containsKey(project.getBasePath())) {
            return;
        }
        LOG = FlutterSettings.getInstance().isVerboseLogging() ? Logger.getInstance(FontPreviewProcessor.class) : null;
        FontPreviewProcessor.log("Analyzing project ", project.getName());
        ANALYZED_PROJECT_FILES.put(project.getBasePath(), (Set<String>)new THashSet());
        ProjectManager.getInstance().addProjectManagerListener(project, new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                FontPreviewProcessor.clearProjectCaches(project);
                super.projectClosed(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "io/flutter/font/FontPreviewProcessor$1", "projectClosed"));
            }
        });
        String projectPath = project.getBasePath();
        WorkItem item = new WorkItem(projectPath);
        WORK_ITEMS.put(projectPath, item);
        String packagesText = FlutterSettings.getInstance().getFontPackages();
        String[] packages = packagesText.split(PACKAGE_SEPARATORS);
        item.addPackages(Arrays.stream(packages).map(String::trim).filter(each -> !each.isEmpty() || UNSUPPORTED_PACKAGES.get(each) != null).collect(Collectors.toList()));
        this.processItems(project);
    }

    void processItems(final @NotNull Project project) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(3);
        }
        Task.Backgroundable task = new Task.Backgroundable(project, FlutterBundle.message("icon.preview.analysis", new Object[0]), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                AtomicBoolean isRunning = new AtomicBoolean(true);
                long startTime = System.currentTimeMillis();
                while (isRunning.get()) {
                    String path = project.getBasePath();
                    WorkItem item = WORK_ITEMS.get(path);
                    if (FontPreviewProcessor.this.processNextItem(project, item)) continue;
                    if (item.filesWithNoClasses.isEmpty()) {
                        2 var7_6 = this;
                        synchronized (var7_6) {
                            if (item == WORK_ITEMS.get(path)) {
                                WORK_ITEMS.remove(path);
                            }
                            isRunning.set(false);
                            if (System.currentTimeMillis() - startTime > 1000L) {
                                DaemonCodeAnalyzer.getInstance((Project)project).restart();
                            }
                            continue;
                        }
                    }
                    for (String key : item.filesWithNoClasses.keySet()) {
                        PathInfo info = item.filesWithNoClasses.get(key);
                        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(info.filePath);
                        if (virtualFile == null) continue;
                        item.addFileToCheck(info.packageName, info.filePath, virtualFile);
                    }
                    item.filesWithNoClasses.clear();
                }
            }

            public void onCancel() {
                if (project.isDisposed()) {
                    return;
                }
                FontPreviewProcessor.clearProjectCaches(project);
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "io/flutter/font/FontPreviewProcessor$2", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    boolean processNextItem(@NotNull Project project, @NotNull WorkItem item) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(4);
        }
        if (item == null) {
            FontPreviewProcessor.$$$reportNull$$$0(5);
        }
        if (item.isCancelled) {
            return false;
        }
        Application app = ApplicationManager.getApplication();
        if (item.hasFilesToRewrite()) {
            app.invokeLater(() -> this.rewriteNextFile(project, item));
            return true;
        }
        if (item.hasClasses()) {
            this.analyzeNextClass(project, item);
            return true;
        }
        if (item.hasFilesToAnalyze()) {
            this.analyzeNextFile(project, item);
            return true;
        }
        if (item.hasPackages()) {
            this.analyzeNextPackage(project, item);
            return true;
        }
        if (item.hasFilesToCheck()) {
            this.checkNextFile(project, item);
            return true;
        }
        if (item.hasFilesToDelete()) {
            app.invokeLater(() -> this.deleteNextFile(project, item));
            return true;
        }
        return false;
    }

    private void analyzeNextPackage(@NotNull Project project, @NotNull WorkItem item) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(6);
        }
        if (item == null) {
            FontPreviewProcessor.$$$reportNull$$$0(7);
        }
        if (project.isDisposed() || item.isCancelled) {
            return;
        }
        String info = item.getPackage();
        if (info == null) {
            return;
        }
        this.findFontFiles(project, info, item);
        item.removePackage();
    }

    private void rewriteNextFile(@NotNull Project project, @NotNull WorkItem item) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(8);
        }
        if (item == null) {
            FontPreviewProcessor.$$$reportNull$$$0(9);
        }
        if (project.isDisposed() || item.isCancelled) {
            return;
        }
        FileInfo info = item.getFileToRewrite();
        if (info == null) {
            return;
        }
        VirtualFile file = info.file;
        String packageName = info.packageName;
        String path = file.getPath();
        int packageIndex = path.indexOf(packageName);
        if (ANALYZED_PROJECT_FILES.get(item.projectPath).contains(path)) {
            item.removeFileToRewrite();
            return;
        }
        FontPreviewProcessor.log("Rewriting file ", file.getName(), " in ", packageName);
        VirtualFile filteredFile = this.filterImports(file);
        if (filteredFile == null) {
            FontPreviewProcessor.log("Cannot filter imports in ", file.getName());
            return;
        }
        item.filesWithNoClasses.put(path, new PathInfo(packageName, path));
        item.addFileToAnalyze(packageName, path, filteredFile);
        item.addFileToDelete(filteredFile);
        item.removeFileToRewrite();
    }

    private void analyzeNextFile(@NotNull Project project, @NotNull WorkItem item) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(10);
        }
        if (item == null) {
            FontPreviewProcessor.$$$reportNull$$$0(11);
        }
        if (project.isDisposed() || item.isCancelled) {
            return;
        }
        FileInfo info = item.getFileToAnalyze();
        if (info == null) {
            return;
        }
        String packageName = info.packageName;
        String path = info.originalPath;
        VirtualFile file = info.file;
        Set<String> analyzedProjectFiles = ANALYZED_PROJECT_FILES.get(item.projectPath);
        if (analyzedProjectFiles.contains(path)) {
            item.removeFileToAnalyze();
            return;
        }
        FontPreviewProcessor.log("Analyzing file ", file.getPath(), " path ", path);
        analyzedProjectFiles.add(path);
        PsiFile psiFile = (PsiFile)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> PsiManager.getInstance((Project)project).findFile(file));
        if (psiFile == null) {
            FontPreviewProcessor.log("Cannot get PSI file for ", file.getName());
            return;
        }
        THashSet classNames = new THashSet();
        ClassNameScopeProcessor processor = new ClassNameScopeProcessor((Set)classNames);
        boolean success = (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> FontPreviewProcessor.lambda$analyzeNextFile$4(psiFile, (DartPsiScopeProcessor)processor, file, (Set)classNames));
        if (success) {
            FontPreviewProcessor.log("Queueing ", String.valueOf(classNames.size()), " classes for ", path);
            item.addClasses(packageName, path, (Set<DartComponentName>)classNames);
        } else {
            FontPreviewProcessor.log("Resolution failed for ", path);
        }
        item.removeFileToAnalyze();
    }

    private void analyzeNextClass(@NotNull Project project, @NotNull WorkItem item) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(12);
        }
        if (item == null) {
            FontPreviewProcessor.$$$reportNull$$$0(13);
        }
        if (project.isDisposed() || item.isCancelled) {
            return;
        }
        ClassInfo info = item.getClassToCheck();
        if (info == null) {
            return;
        }
        String packageName = info.packageName;
        String path = info.filePath;
        PsiFile psiFile = (PsiFile)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> ((DartComponentName)info.name).getContainingFile());
        if (path.contains(packageName)) {
            String name = (String)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> ((DartComponentName)info.name).getName());
            FontPreviewProcessor.log("Adding ", name, " -> ", path);
            Set<String> knownPaths = FlutterIconLineMarkerProvider.KnownPaths.get(name);
            if (knownPaths == null) {
                FlutterIconLineMarkerProvider.KnownPaths.put(name, (Set<String>)new THashSet(Collections.singleton(path)));
            } else {
                knownPaths.add(path);
            }
            item.filesWithNoClasses.remove(path);
        }
        item.removeClassToCheck();
    }

    private void checkNextFile(@NotNull Project project, @NotNull WorkItem item) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(14);
        }
        if (item == null) {
            FontPreviewProcessor.$$$reportNull$$$0(15);
        }
        if (project.isDisposed() || item.isCancelled) {
            return;
        }
        try {
            String line;
            FileInfo info = item.getFileToCheck();
            if (info == null) {
                return;
            }
            VirtualFile file = info.file;
            FontPreviewProcessor.log("Checking for exports in ", file.getPath(), " path ", info.originalPath);
            String packageName = info.packageName;
            String source = new String(file.contentsToByteArray());
            BufferedReader reader = new BufferedReader(new StringReader(source));
            while ((line = reader.readLine()) != null) {
                String nextPath;
                VirtualFile next;
                String name;
                Matcher matcher = EXPORT_STATEMENT_PATTERN.matcher(line);
                if (!matcher.matches() || (name = matcher.group(1)) == null || (next = LocalFileSystem.getInstance().findFileByNioFile(Paths.get(file.getParent().getPath(), name))) == null || FontPreviewProcessor.isInSdk(nextPath = next.getPath()) || ANALYZED_PROJECT_FILES.get(project.getBasePath()).contains(nextPath)) continue;
                item.addFileToAnalyze(packageName, nextPath, next);
            }
            item.removeFileToCheck();
        }
        catch (IOException e) {
            FontPreviewProcessor.log("IOException", e);
        }
    }

    private void deleteNextFile(Project project, WorkItem item) {
        VirtualFile filteredFile = item.getFileToDelete();
        if (filteredFile != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    FontPreviewProcessor.log("Deleting file ", filteredFile.getName());
                    filteredFile.delete((Object)this);
                    item.removeFileToDelete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    private static void clearProjectCaches(@NotNull Project project) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(16);
        }
        ANALYZED_PROJECT_FILES.remove(project.getBasePath());
        WORK_ITEMS.remove(project.getBasePath());
        FlutterIconLineMarkerProvider.initialize();
    }

    private void findFontFiles(@NotNull Project project, @NotNull String packageName, @NotNull WorkItem item) {
        if (project == null) {
            FontPreviewProcessor.$$$reportNull$$$0(17);
        }
        if (packageName == null) {
            FontPreviewProcessor.$$$reportNull$$$0(18);
        }
        if (item == null) {
            FontPreviewProcessor.$$$reportNull$$$0(19);
        }
        if (packageName.isEmpty() || UNSUPPORTED_PACKAGES.get(packageName) != null) {
            return;
        }
        FontPreviewProcessor.log("Analyzing package ", packageName);
        Application application = ApplicationManager.getApplication();
        ProjectAndLibrariesScope projectScope = new ProjectAndLibrariesScope(project);
        Collection files = (Collection)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> FontPreviewProcessor.lambda$findFontFiles$6((GlobalSearchScope)projectScope, packageName));
        if (files.isEmpty()) {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            files = (Collection)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> FileTypeIndex.getFiles((FileType)DartFileType.INSTANCE, (GlobalSearchScope)scope));
        }
        item.addFilesToRewrite(packageName, files);
    }

    private VirtualFile filterImports(VirtualFile file) {
        StringBuilder newSource = new StringBuilder();
        try {
            String line;
            String source = new String(file.contentsToByteArray());
            BufferedReader reader = new BufferedReader(new StringReader(source));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = IMPORT_STATEMENT_PATTERN.matcher(line);
                if (matcher.matches()) continue;
                newSource.append(line);
                newSource.append('\n');
            }
            File ioFile = FileUtil.createTempFile((String)file.getNameWithoutExtension(), (String)".dart");
            VirtualFile newFile = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
            if (newFile == null) {
                return null;
            }
            Application app = ApplicationManager.getApplication();
            app.invokeAndWait(() -> app.runWriteAction(() -> {
                try {
                    newFile.setBinaryContent(newSource.toString().getBytes(StandardCharsets.UTF_8));
                    newFile.setCharset(StandardCharsets.UTF_8);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }));
            return newFile;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static boolean isInSdk(String path) {
        return path.contains("flutter/packages/flutter/lib") || path.contains("flutter/bin/cache/dart-sdk");
    }

    private static void log(String msg, String ... msgs) {
        if (LOG != null) {
            StringBuilder b = new StringBuilder("ICONS -- ");
            b.append(msg);
            for (String s : msgs) {
                b.append(" ").append(s);
            }
            LOG.info(b.toString());
        }
    }

    private static void log(String msg, Exception ex) {
        if (LOG != null) {
            LOG.info("ICONS--" + msg, (Throwable)ex);
        }
    }

    private static /* synthetic */ Collection lambda$findFontFiles$6(GlobalSearchScope projectScope, String packageName) {
        return DartLibraryIndex.getFilesByLibName((GlobalSearchScope)projectScope, (String)packageName);
    }

    private static /* synthetic */ Boolean lambda$analyzeNextFile$4(PsiFile psiFile, DartPsiScopeProcessor processor, VirtualFile file, Set classNames) {
        boolean result = DartResolveUtil.processTopLevelDeclarations((PsiElement)psiFile, (DartPsiScopeProcessor)processor, (VirtualFile)file, null);
        if (result) {
            THashSet keep = new THashSet();
            for (DartComponentName name : classNames) {
                if (!file.equals(name.getContainingFile().getVirtualFile())) continue;
                keep.add(name);
            }
            classNames.clear();
            classNames.addAll(keep);
        }
        return result;
    }

    static {
        UNSUPPORTED_PACKAGES.put("flutter_icons", FlutterBundle.message("icon.preview.disallow.flutter_icons", new Object[0]));
        UNSUPPORTED_PACKAGES.put("flutter_vector_icons", FlutterBundle.message("icon.preview.disallow.flutter_vector_icons", new Object[0]));
        UNSUPPORTED_PACKAGES.put("material_design_icons_flutter", FlutterBundle.message("icon.preview.disallow.material_design_icons_flutter", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "io/flutter/font/FontPreviewProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "analyze";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reanalyze";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "generate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processItems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processNextItem";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeNextPackage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "rewriteNextFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeNextFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeNextClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNextFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "clearProjectCaches";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "findFontFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class WorkItem {
        final Queue<String> packagesToAnalyze = new LinkedList<String>();
        final Queue<FileInfo> filesToAnalyze = new LinkedList<FileInfo>();
        final Queue<VirtualFile> filesToDelete = new LinkedList<VirtualFile>();
        final Queue<FileInfo> filesToRewrite = new LinkedList<FileInfo>();
        final Queue<ClassInfo> classesToAnalyze = new LinkedList<ClassInfo>();
        final Queue<FileInfo> filesToCheck = new LinkedList<FileInfo>();
        final Map<String, PathInfo> filesWithNoClasses = new THashMap();
        final String projectPath;
        boolean isCancelled = false;

        WorkItem(String packageName) {
            this.projectPath = packageName;
        }

        boolean hasClasses() {
            return !this.classesToAnalyze.isEmpty();
        }

        boolean hasFilesToAnalyze() {
            return !this.filesToAnalyze.isEmpty();
        }

        boolean hasFilesToCheck() {
            return !this.filesToCheck.isEmpty();
        }

        boolean hasFilesToDelete() {
            return !this.filesToDelete.isEmpty();
        }

        boolean hasFilesToRewrite() {
            return !this.filesToRewrite.isEmpty();
        }

        boolean hasPackages() {
            return !this.packagesToAnalyze.isEmpty();
        }

        void addFileToAnalyze(@NotNull String packageName, @NotNull String path, @NotNull VirtualFile name) {
            if (packageName == null) {
                WorkItem.$$$reportNull$$$0(0);
            }
            if (path == null) {
                WorkItem.$$$reportNull$$$0(1);
            }
            if (name == null) {
                WorkItem.$$$reportNull$$$0(2);
            }
            this.filesToAnalyze.add(new FileInfo(packageName, path, name));
        }

        void addFileToCheck(@NotNull String packageName, @NotNull String path, @NotNull VirtualFile name) {
            if (packageName == null) {
                WorkItem.$$$reportNull$$$0(3);
            }
            if (path == null) {
                WorkItem.$$$reportNull$$$0(4);
            }
            if (name == null) {
                WorkItem.$$$reportNull$$$0(5);
            }
            this.filesToCheck.add(new FileInfo(packageName, path, name));
        }

        public void addFileToDelete(@NotNull VirtualFile file) {
            if (file == null) {
                WorkItem.$$$reportNull$$$0(6);
            }
            this.filesToDelete.add(file);
        }

        void addFileToRewrite(@NotNull String packageName, @NotNull String path, @NotNull VirtualFile name) {
            if (packageName == null) {
                WorkItem.$$$reportNull$$$0(7);
            }
            if (path == null) {
                WorkItem.$$$reportNull$$$0(8);
            }
            if (name == null) {
                WorkItem.$$$reportNull$$$0(9);
            }
            this.filesToRewrite.add(new FileInfo(packageName, path, name));
        }

        @Nullable
        FileInfo getFileToAnalyze() {
            return this.filesToAnalyze.peek();
        }

        @Nullable
        ClassInfo getClassToCheck() {
            return this.classesToAnalyze.peek();
        }

        void removeClassToCheck() {
            this.classesToAnalyze.remove();
        }

        void removeFileToAnalyze() {
            this.filesToAnalyze.remove();
        }

        @Nullable
        FileInfo getFileToCheck() {
            return this.filesToCheck.peek();
        }

        void removeFileToCheck() {
            this.filesToCheck.remove();
        }

        @Nullable
        FileInfo getFileToRewrite() {
            return this.filesToRewrite.peek();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeFileToRewrite() {
            WorkItem workItem = this;
            synchronized (workItem) {
                if (!this.filesToRewrite.isEmpty()) {
                    this.filesToRewrite.remove();
                }
            }
        }

        @Nullable
        VirtualFile getFileToDelete() {
            return this.filesToDelete.peek();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeFileToDelete() {
            WorkItem workItem = this;
            synchronized (workItem) {
                if (!this.filesToDelete.isEmpty()) {
                    this.filesToDelete.remove();
                }
            }
        }

        @Nullable
        String getPackage() {
            return this.packagesToAnalyze.peek();
        }

        void removePackage() {
            this.packagesToAnalyze.remove();
        }

        void addPackages(@NotNull List<String> packages) {
            if (packages == null) {
                WorkItem.$$$reportNull$$$0(10);
            }
            this.packagesToAnalyze.addAll(packages);
        }

        public void addClasses(@NotNull String packageName, @NotNull String filePath, @NotNull Set<DartComponentName> names) {
            if (packageName == null) {
                WorkItem.$$$reportNull$$$0(11);
            }
            if (filePath == null) {
                WorkItem.$$$reportNull$$$0(12);
            }
            if (names == null) {
                WorkItem.$$$reportNull$$$0(13);
            }
            this.classesToAnalyze.addAll(names.stream().map(each -> new ClassInfo(packageName, filePath, (DartComponentName)each)).collect(Collectors.toList()));
        }

        void addFilesToRewrite(@NotNull String packageName, @NotNull Collection<VirtualFile> files) {
            if (packageName == null) {
                WorkItem.$$$reportNull$$$0(14);
            }
            if (files == null) {
                WorkItem.$$$reportNull$$$0(15);
            }
            this.filesToRewrite.addAll(files.stream().filter(each -> {
                String path = each.getPath();
                int packageIndex = path.indexOf(packageName);
                return packageIndex >= 0 && !FontPreviewProcessor.isInSdk(path);
            }).map(each -> new FileInfo(packageName, each.getPath(), (VirtualFile)each)).collect(Collectors.toList()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 1: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packages";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/font/FontPreviewProcessor$WorkItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addFileToAnalyze";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addFileToCheck";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addFileToDelete";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addFileToRewrite";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addPackages";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addClasses";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addFilesToRewrite";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class FileInfo {
        private final String packageName;
        private final String originalPath;
        private final VirtualFile file;

        FileInfo(String packageName, String path, VirtualFile file) {
            this.packageName = packageName;
            this.originalPath = path;
            this.file = file;
        }
    }

    static class PathInfo {
        private final String packageName;
        private final String filePath;

        PathInfo(String packageName, String filePath) {
            this.packageName = packageName;
            this.filePath = filePath;
        }
    }

    static class ClassInfo {
        private final String packageName;
        private final String filePath;
        private final DartComponentName name;

        ClassInfo(String packageName, String filePath, DartComponentName name) {
            this.packageName = packageName;
            this.filePath = filePath;
            this.name = name;
        }
    }
}

