/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.hotui;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import io.flutter.dart.FlutterDartAnalysisServer;
import io.flutter.dart.FlutterOutlineListener;
import io.flutter.inspector.InspectorService;
import io.flutter.preview.OutlineOffsetConverter;
import io.flutter.utils.EventStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StableWidgetTracker
implements Disposable {
    private final String currentFilePath;
    private final InspectorService.Location initialLocation;
    private final FlutterDartAnalysisServer flutterAnalysisServer;
    private final OutlineOffsetConverter converter;
    private ArrayList<FlutterOutline> lastPath;
    FlutterOutline root;
    private final FlutterOutlineListener outlineListener = new FlutterOutlineListener(){

        @Override
        public void outlineUpdated(@NotNull String filePath, @NotNull FlutterOutline outline, @Nullable String instrumentedCode) {
            if (filePath == null) {
                1.$$$reportNull$$$0(0);
            }
            if (outline == null) {
                1.$$$reportNull$$$0(1);
            }
            if (Objects.equals(StableWidgetTracker.this.currentFilePath, filePath)) {
                ApplicationManager.getApplication().invokeLater(() -> StableWidgetTracker.this.outlineChanged(outline));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outline";
                    break;
                }
            }
            objectArray[1] = "io/flutter/hotui/StableWidgetTracker$1";
            objectArray[2] = "outlineUpdated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final EventStream<List<FlutterOutline>> currentOutlines;

    private void outlineChanged(FlutterOutline outline) {
        this.root = outline;
        if (this.lastPath == null) {
            this.lastPath = new ArrayList();
            this.findOutlineAtOffset(this.root, this.initialLocation.getOffset(), this.lastPath);
        } else {
            this.lastPath = this.findSimilarPath(this.root, this.lastPath);
        }
        this.currentOutlines.setValue((List<FlutterOutline>)(this.lastPath.isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)this.lastPath.get(this.lastPath.size() - 1))));
    }

    private static int findChildIndex(FlutterOutline node, FlutterOutline child) {
        List<FlutterOutline> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) != child) continue;
            return i;
        }
        return -1;
    }

    private ArrayList<FlutterOutline> findSimilarPath(FlutterOutline root, ArrayList<FlutterOutline> lastPath) {
        ArrayList<FlutterOutline> path = new ArrayList<FlutterOutline>();
        FlutterOutline node = root;
        path.add(node);
        for (int i = 1; i < lastPath.size() && node != null && !node.getChildren().isEmpty(); ++i) {
            FlutterOutline child;
            int index;
            FlutterOutline oldChild = lastPath.get(i);
            int expectedIndex = StableWidgetTracker.findChildIndex(lastPath.get(i - 1), oldChild);
            assert (expectedIndex != -1);
            List<FlutterOutline> children = node.getChildren();
            if (!Objects.equals((node = children.get(index = Math.min(Math.max(0, expectedIndex), children.size()))).getClassName(), oldChild.getClassName()) && node.getChildren().size() == 1 && Objects.equals((child = node.getChildren().get(0)).getClassName(), oldChild.getClassName())) {
                path.add(node);
                node = child;
            }
            path.add(node);
        }
        return path;
    }

    private boolean findOutlineAtOffset(FlutterOutline outline, int offset, ArrayList<FlutterOutline> path) {
        if (outline == null) {
            return false;
        }
        path.add(outline);
        if (this.converter.getConvertedOutlineOffset(outline) <= offset && offset <= this.converter.getConvertedOutlineEnd(outline)) {
            List<FlutterOutline> children = outline.getChildren();
            if (children != null) {
                for (FlutterOutline child : children) {
                    boolean foundChild = this.findOutlineAtOffset(child, offset, path);
                    if (!foundChild) continue;
                    return true;
                }
            }
            return true;
        }
        path.remove(path.size() - 1);
        return false;
    }

    public EventStream<List<FlutterOutline>> getCurrentOutlines() {
        return this.currentOutlines;
    }

    public StableWidgetTracker(InspectorService.Location initialLocation, FlutterDartAnalysisServer flutterAnalysisServer, Project project, Disposable parentDisposable) {
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.converter = new OutlineOffsetConverter(project, initialLocation.getFile());
        this.currentOutlines = new EventStream<ImmutableList>(ImmutableList.of());
        this.flutterAnalysisServer = flutterAnalysisServer;
        this.initialLocation = initialLocation;
        DartAnalysisServerService analysisServerService = DartAnalysisServerService.getInstance((Project)project);
        this.currentFilePath = FileUtil.toSystemDependentName((String)initialLocation.getFile().getPath());
        flutterAnalysisServer.addOutlineListener(this.currentFilePath, this.outlineListener);
    }

    public void dispose() {
        this.flutterAnalysisServer.removeOutlineListener(this.currentFilePath, this.outlineListener);
    }

    public boolean isValid() {
        return !this.getCurrentOutlines().getValue().isEmpty();
    }

    public int getOffset() {
        List<FlutterOutline> outlines = this.getCurrentOutlines().getValue();
        if (outlines.isEmpty()) {
            return 0;
        }
        FlutterOutline outline = outlines.get(0);
        return this.converter.getConvertedOutlineOffset(outline);
    }
}

