/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspections;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.psi.DartFile;
import gnu.trove.THashSet;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.dart.DartPlugin;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRootCache;
import io.flutter.sdk.FlutterSdk;
import io.flutter.utils.FlutterModuleUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterDependencyInspection
extends LocalInspectionTool {
    private final Set<String> myIgnoredPubspecPaths = new THashSet();

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiFile == null) {
            FlutterDependencyInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            FlutterDependencyInspection.$$$reportNull$$$0(1);
        }
        if (!isOnTheFly) {
            return null;
        }
        if (!(psiFile instanceof DartFile)) {
            return null;
        }
        if (DartPlugin.isPubActionInProgress()) {
            return null;
        }
        VirtualFile file = FlutterUtils.getRealVirtualFile(psiFile);
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        Project project = psiFile.getProject();
        if (WorkspaceCache.getInstance(project).isBazel()) {
            return null;
        }
        if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file)) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (!FlutterModuleUtils.isFlutterModule(module)) {
            return null;
        }
        PubRoot root = PubRootCache.getInstance(project).getRoot(psiFile);
        if (root == null || this.myIgnoredPubspecPaths.contains(root.getPubspec().getPath())) {
            return null;
        }
        if (!root.declaresFlutter()) {
            return null;
        }
        if (root.getPackagesFile() == null && root.getPackageConfigFile() == null) {
            return this.createProblemDescriptors(manager, psiFile, root, FlutterBundle.message("pub.get.not.run", new Object[0]));
        }
        if (!root.hasUpToDatePackages()) {
            return this.createProblemDescriptors(manager, psiFile, root, FlutterBundle.message("pubspec.edited", new Object[0]));
        }
        return null;
    }

    @NotNull
    private ProblemDescriptor[] createProblemDescriptors(@NotNull InspectionManager manager, @NotNull PsiFile psiFile, @NotNull PubRoot root, @NotNull String errorMessage) {
        if (manager == null) {
            FlutterDependencyInspection.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            FlutterDependencyInspection.$$$reportNull$$$0(3);
        }
        if (root == null) {
            FlutterDependencyInspection.$$$reportNull$$$0(4);
        }
        if (errorMessage == null) {
            FlutterDependencyInspection.$$$reportNull$$$0(5);
        }
        LocalQuickFix[] fixes = new LocalQuickFix[]{new PackageUpdateFix(FlutterBundle.message("get.dependencies", new Object[0]), FlutterSdk::startPubGet), new PackageUpdateFix(FlutterBundle.message("upgrade.dependencies", new Object[0]), FlutterSdk::startPubUpgrade), new IgnoreWarningFix(this.myIgnoredPubspecPaths, root.getPubspec().getPath())};
        ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)psiFile, errorMessage, true, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
        if (problemDescriptorArray == null) {
            FlutterDependencyInspection.$$$reportNull$$$0(6);
        }
        return problemDescriptorArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/inspections/FlutterDependencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/inspections/FlutterDependencyInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptors";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static class PackageUpdateFix
    extends IntentionAndQuickFixAction {
        private final String myFixName;
        private final SdkAction mySdkAction;

        private PackageUpdateFix(@NotNull String fixName, @NotNull SdkAction action) {
            if (fixName == null) {
                PackageUpdateFix.$$$reportNull$$$0(0);
            }
            if (action == null) {
                PackageUpdateFix.$$$reportNull$$$0(1);
            }
            this.myFixName = fixName;
            this.mySdkAction = action;
        }

        @NotNull
        public String getName() {
            String string = this.myFixName;
            if (string == null) {
                PackageUpdateFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                PackageUpdateFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            FlutterSdk sdk;
            if (project == null) {
                PackageUpdateFix.$$$reportNull$$$0(4);
            }
            if (psiFile == null) {
                PackageUpdateFix.$$$reportNull$$$0(5);
            }
            if ((sdk = FlutterSdk.getFlutterSdk(project)) == null) {
                return;
            }
            PubRoot root = PubRoot.forPsiFile(psiFile);
            if (root == null) {
                return;
            }
            this.mySdkAction.run(sdk, root, project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/inspections/FlutterDependencyInspection$PackageUpdateFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/inspections/FlutterDependencyInspection$PackageUpdateFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static interface SdkAction {
        public void run(FlutterSdk var1, @NotNull PubRoot var2, @NotNull Project var3);
    }

    private static class IgnoreWarningFix
    extends IntentionAndQuickFixAction {
        @NotNull
        private final Set<String> myIgnoredPubspecPaths;
        @NotNull
        private final String myPubspecPath;

        public IgnoreWarningFix(@NotNull Set<String> ignoredPubspecPaths, @NotNull String pubspecPath) {
            if (ignoredPubspecPaths == null) {
                IgnoreWarningFix.$$$reportNull$$$0(0);
            }
            if (pubspecPath == null) {
                IgnoreWarningFix.$$$reportNull$$$0(1);
            }
            this.myIgnoredPubspecPaths = ignoredPubspecPaths;
            this.myPubspecPath = pubspecPath;
        }

        @NotNull
        public String getName() {
            String string = FlutterBundle.message("ignore.warning", new Object[0]);
            if (string == null) {
                IgnoreWarningFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                IgnoreWarningFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            if (project == null) {
                IgnoreWarningFix.$$$reportNull$$$0(4);
            }
            if (psiFile == null) {
                IgnoreWarningFix.$$$reportNull$$$0(5);
            }
            this.myIgnoredPubspecPaths.add(this.myPubspecPath);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignoredPubspecPaths";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pubspecPath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/inspections/FlutterDependencyInspection$IgnoreWarningFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/inspections/FlutterDependencyInspection$IgnoreWarningFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

