/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspections;

import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.lang.dart.DartLanguage;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.dart.DartPlugin;
import io.flutter.utils.FlutterModuleUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncompatibleDartPluginNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"IncompatibleDartPluginNotificationProvider");
    private final Project project;

    public IncompatibleDartPluginNotificationProvider(@NotNull Project project) {
        if (project == null) {
            IncompatibleDartPluginNotificationProvider.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    @Nullable
    private static EditorNotificationPanel createUpdateDartPanel(@NotNull Project project, @Nullable Module module, @NotNull String currentVersion, @NotNull String minimumVersion) {
        if (project == null) {
            IncompatibleDartPluginNotificationProvider.$$$reportNull$$$0(1);
        }
        if (currentVersion == null) {
            IncompatibleDartPluginNotificationProvider.$$$reportNull$$$0(2);
        }
        if (minimumVersion == null) {
            IncompatibleDartPluginNotificationProvider.$$$reportNull$$$0(3);
        }
        if (module == null) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(FlutterBundle.message("flutter.incompatible.dart.plugin.warning", minimumVersion, currentVersion));
        panel2.createActionLabel(FlutterBundle.message("dart.plugin.update.action.label", new Object[0]), () -> ShowSettingsUtil.getInstance().showSettingsDialog(project, PluginManagerConfigurable.class));
        return panel2;
    }

    private static String getPrintableRequiredDartVersion() {
        return DartPlugin.getInstance().getMinimumVersion().toCompactString();
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            IncompatibleDartPluginNotificationProvider.$$$reportNull$$$0(4);
        }
        return key;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            IncompatibleDartPluginNotificationProvider.$$$reportNull$$$0(5);
        }
        if (fileEditor == null) {
            IncompatibleDartPluginNotificationProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            IncompatibleDartPluginNotificationProvider.$$$reportNull$$$0(7);
        }
        if (!FlutterUtils.isFlutteryFile(file)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        if (psiFile.getLanguage() != DartLanguage.INSTANCE) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            return null;
        }
        if (!FlutterModuleUtils.isFlutterModule(module)) {
            return null;
        }
        Version minimumVersion = DartPlugin.getInstance().getMinimumVersion();
        Version dartVersion = DartPlugin.getInstance().getVersion();
        if (dartVersion.minor == 0 && dartVersion.bugfix == 0) {
            return null;
        }
        return dartVersion.compareTo(minimumVersion) < 0 ? IncompatibleDartPluginNotificationProvider.createUpdateDartPanel(project, module, dartVersion.toCompactString(), IncompatibleDartPluginNotificationProvider.getPrintableRequiredDartVersion()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentVersion";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimumVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/inspections/IncompatibleDartPluginNotificationProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/inspections/IncompatibleDartPluginNotificationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateDartPanel";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

