/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.DartLanguage;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterUtils;
import io.flutter.sdk.FlutterSdk;
import io.flutter.settings.FlutterUIConfig;
import io.flutter.utils.FlutterModuleUtils;
import org.jetbrains.annotations.NotNull;

public class SdkConfigurationNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"FlutterWrongDartSdkNotification");
    private static final Logger LOG = Logger.getInstance(SdkConfigurationNotificationProvider.class);
    @NotNull
    private final Project project;

    public SdkConfigurationNotificationProvider(@NotNull Project project) {
        if (project == null) {
            SdkConfigurationNotificationProvider.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    private static EditorNotificationPanel createNoFlutterSdkPanel(Project project) {
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.icon(FlutterIcons.Flutter);
        panel2.setText(FlutterBundle.message("flutter.no.sdk.warning", new Object[0]));
        panel2.createActionLabel("Dismiss", () -> panel2.setVisible(false));
        panel2.createActionLabel("Open Flutter settings", () -> FlutterUtils.openFlutterSettings(project));
        return panel2;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            SdkConfigurationNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            SdkConfigurationNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            SdkConfigurationNotificationProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            SdkConfigurationNotificationProvider.$$$reportNull$$$0(4);
        }
        if (FlutterModuleUtils.isFlutterBazelProject(project)) {
            return null;
        }
        if (file.getFileType() != DartFileType.INSTANCE) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null || psiFile.getLanguage() != DartLanguage.INSTANCE) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (!FlutterModuleUtils.isFlutterModule(module)) {
            return null;
        }
        FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
        if (flutterSdk == null) {
            return SdkConfigurationNotificationProvider.createNoFlutterSdkPanel(project);
        }
        if (!flutterSdk.getVersion().isMinRecommendedSupported()) {
            return this.createOutOfDateFlutterSdkPanel(flutterSdk);
        }
        return null;
    }

    private EditorNotificationPanel createOutOfDateFlutterSdkPanel(@NotNull FlutterSdk sdk) {
        FlutterUIConfig settings;
        if (sdk == null) {
            SdkConfigurationNotificationProvider.$$$reportNull$$$0(5);
        }
        if ((settings = FlutterUIConfig.getInstance()).shouldIgnoreOutOfDateFlutterSdks()) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.icon(FlutterIcons.Flutter);
        panel2.setText(FlutterBundle.message("flutter.old.sdk.warning", new Object[0]));
        panel2.createActionLabel("Dismiss", () -> {
            settings.setIgnoreOutOfDateFlutterSdks();
            panel2.setVisible(false);
        });
        return panel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/inspections/SdkConfigurationNotificationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/inspections/SdkConfigurationNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createOutOfDateFlutterSdkPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

