/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.google.gson.JsonObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Alarm;
import com.intellij.xdebugger.XSourcePosition;
import io.flutter.inspector.EvalException;
import io.flutter.inspector.InspectorService;
import io.flutter.utils.StreamSubscription;
import io.flutter.vmService.DartVmServiceDebugProcess;
import io.flutter.vmService.VMServiceManager;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.EvaluateConsumer;
import org.dartlang.vm.service.consumer.GetIsolateConsumer;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.consumer.ServiceExtensionConsumer;
import org.dartlang.vm.service.element.ClassObj;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.ErrorRef;
import org.dartlang.vm.service.element.Func;
import org.dartlang.vm.service.element.FuncRef;
import org.dartlang.vm.service.element.Instance;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.Library;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.ObjRef;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.ScriptRef;
import org.dartlang.vm.service.element.Sentinel;
import org.jetbrains.annotations.NotNull;

public class EvalOnDartLibrary
implements Disposable {
    private static final Logger LOG = Logger.getInstance(EvalOnDartLibrary.class);
    private final StreamSubscription<IsolateRef> subscription;
    private final ScheduledThreadPoolExecutor delayer;
    private String isolateId;
    private final VmService vmService;
    private final VMServiceManager vmServiceManager;
    private final Set<String> libraryNames;
    CompletableFuture<LibraryRef> libraryRef;
    private final Alarm myRequestsScheduler;
    static final int DEFAULT_REQUEST_TIMEOUT_SECONDS = 10;
    private CompletableFuture<?> allPendingRequestsDone;
    private final Object pendingRequestLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> CompletableFuture<T> addRequest(InspectorService.ObjectGroup isAlive, String requestName, Supplier<CompletableFuture<T>> request) {
        if (isAlive != null && isAlive.isDisposed()) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.myRequestsScheduler.isDisposed()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture response = new CompletableFuture();
        Runnable wrappedRequest = () -> {
            if (isAlive != null && isAlive.isDisposed()) {
                response.complete(null);
                return;
            }
            try {
                this.timeoutAfter(response, 10L, TimeUnit.SECONDS, requestName);
            }
            catch (CompletionException ex) {
                response.completeExceptionally(ex);
            }
            CompletableFuture future = (CompletableFuture)request.get();
            future.whenCompleteAsync((v, t) -> {
                if (t != null) {
                    response.completeExceptionally((Throwable)t);
                } else {
                    response.complete(v);
                }
            });
        };
        Object object = this.pendingRequestLock;
        synchronized (object) {
            if (this.allPendingRequestsDone == null || this.allPendingRequestsDone.isDone()) {
                this.allPendingRequestsDone = response;
                this.myRequestsScheduler.addRequest(wrappedRequest, 0);
            } else {
                CompletableFuture<?> previousDone = this.allPendingRequestsDone;
                this.allPendingRequestsDone = response;
                previousDone.whenCompleteAsync((v, error) -> {
                    if (this.myRequestsScheduler.isDisposed()) {
                        response.complete(null);
                    } else {
                        this.myRequestsScheduler.addRequest(wrappedRequest, 0);
                    }
                });
            }
        }
        return response;
    }

    public EvalOnDartLibrary(Set<String> libraryNames, VmService vmService, VMServiceManager vmServiceManager) {
        this.libraryNames = libraryNames;
        this.vmService = vmService;
        this.vmServiceManager = vmServiceManager;
        this.myRequestsScheduler = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.libraryRef = new CompletableFuture();
        this.subscription = vmServiceManager.getCurrentFlutterIsolate(isolate -> {
            if (this.libraryRef.isDone()) {
                this.libraryRef = new CompletableFuture();
            }
            if (isolate != null) {
                this.initialize(isolate.getId());
            }
        }, true);
        this.delayer = new ScheduledThreadPoolExecutor(1);
    }

    public String getIsolateId() {
        return this.isolateId;
    }

    CompletableFuture<LibraryRef> getLibraryRef() {
        return this.libraryRef;
    }

    public void dispose() {
        this.subscription.dispose();
    }

    public CompletableFuture<JsonObject> invokeServiceMethod(String method, JsonObject params) {
        final CompletableFuture<JsonObject> ret = new CompletableFuture<JsonObject>();
        this.timeoutAfter(ret, 10L, TimeUnit.SECONDS, "service method " + method);
        this.vmService.callServiceExtension(this.isolateId, method, params, new ServiceExtensionConsumer(){

            @Override
            public void onError(RPCError error) {
                ret.completeExceptionally(new RuntimeException(error.getMessage()));
            }

            @Override
            public void received(JsonObject object) {
                ret.complete(object);
            }
        });
        return ret;
    }

    private void timeoutAfter(CompletableFuture<?> future, long timeout, TimeUnit unit, String operationName) {
        TimeoutException timeoutException = new TimeoutException(operationName);
        this.delayer.schedule(() -> future.completeExceptionally(timeoutException), timeout, unit);
    }

    public CompletableFuture<InstanceRef> eval(final String expression, Map<String, String> scope, InspectorService.ObjectGroup isAlive) {
        return this.addRequest(isAlive, "evaluate", () -> {
            final CompletableFuture future = new CompletableFuture();
            this.libraryRef.thenAcceptAsync(ref -> this.vmService.evaluate(this.getIsolateId(), ref.getId(), expression, scope, true, new EvaluateConsumer(){

                @Override
                public void onError(RPCError error) {
                    future.completeExceptionally(new EvalException(expression, Integer.toString(error.getCode()), error.getMessage()));
                }

                @Override
                public void received(ErrorRef response) {
                    future.completeExceptionally(new EvalException(expression, response.getKind().name(), response.getMessage()));
                }

                @Override
                public void received(InstanceRef response) {
                    future.complete(response);
                }

                @Override
                public void received(Sentinel response) {
                    future.completeExceptionally(new EvalException(expression, "Sentinel", response.getValueAsString()));
                }
            }));
            return future;
        });
    }

    public <T extends Obj> CompletableFuture<T> getObjectHelper(ObjRef instance, InspectorService.ObjectGroup isAlive) {
        return this.addRequest(isAlive, "getObject", () -> {
            final CompletableFuture future = new CompletableFuture();
            this.vmService.getObject(this.getIsolateId(), instance.getId(), new GetObjectConsumer(){

                @Override
                public void onError(RPCError error) {
                    future.completeExceptionally(new RuntimeException("RPCError calling getObject: " + error.toString()));
                }

                @Override
                public void received(Obj response) {
                    future.complete(response);
                }

                @Override
                public void received(Sentinel response) {
                    future.completeExceptionally(new RuntimeException("Sentinel calling getObject: " + response.toString()));
                }
            });
            return future;
        });
    }

    @NotNull
    public CompletableFuture<XSourcePosition> getSourcePosition(DartVmServiceDebugProcess debugProcess, ScriptRef script, int tokenPos, InspectorService.ObjectGroup isAlive) {
        CompletableFuture<XSourcePosition> completableFuture = this.addRequest(isAlive, "getSourcePosition", () -> CompletableFuture.completedFuture(debugProcess.getSourcePosition(this.isolateId, script, tokenPos)));
        if (completableFuture == null) {
            EvalOnDartLibrary.$$$reportNull$$$0(0);
        }
        return completableFuture;
    }

    public CompletableFuture<Instance> getInstance(InstanceRef instance, InspectorService.ObjectGroup isAlive) {
        return this.getObjectHelper(instance, isAlive);
    }

    public CompletableFuture<Library> getLibrary(LibraryRef instance, InspectorService.ObjectGroup isAlive) {
        return this.getObjectHelper(instance, isAlive);
    }

    public CompletableFuture<ClassObj> getClass(ClassRef instance, InspectorService.ObjectGroup isAlive) {
        return this.getObjectHelper(instance, isAlive);
    }

    public CompletableFuture<Func> getFunc(FuncRef instance, InspectorService.ObjectGroup isAlive) {
        return this.getObjectHelper(instance, isAlive);
    }

    public CompletableFuture<Instance> getInstance(CompletableFuture<InstanceRef> instanceFuture, InspectorService.ObjectGroup isAlive) {
        return instanceFuture.thenComposeAsync(instance -> this.getInstance((InstanceRef)instance, isAlive));
    }

    private JsonObject convertMapToJsonObject(Map<String, String> map) {
        JsonObject obj = new JsonObject();
        for (String key : map.keySet()) {
            obj.addProperty(key, map.get(key));
        }
        return obj;
    }

    private void initialize(String isolateId) {
        this.isolateId = isolateId;
        this.vmService.getIsolate(isolateId, new GetIsolateConsumer(){

            @Override
            public void received(Isolate response) {
                for (LibraryRef library : response.getLibraries()) {
                    if (!EvalOnDartLibrary.this.libraryNames.contains(library.getUri())) continue;
                    EvalOnDartLibrary.this.libraryRef.complete(library);
                    return;
                }
                EvalOnDartLibrary.this.libraryRef.completeExceptionally(new RuntimeException("No library matching " + String.valueOf(EvalOnDartLibrary.this.libraryNames) + " found."));
            }

            @Override
            public void onError(RPCError error) {
                EvalOnDartLibrary.this.libraryRef.completeExceptionally(new RuntimeException("RPCError calling getIsolate:" + error.toString()));
            }

            @Override
            public void received(Sentinel response) {
                EvalOnDartLibrary.this.libraryRef.completeExceptionally(new RuntimeException("Sentinel calling getIsolate:" + response.toString()));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/inspector/EvalOnDartLibrary", "getSourcePosition"));
    }
}

