/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import io.flutter.inspector.HeapSamples;
import io.flutter.vmService.HeapMonitor;
import java.text.DecimalFormat;
import java.util.List;
import org.dartlang.vm.service.element.MemoryUsage;

public class HeapState {
    private static final DecimalFormat df = new DecimalFormat();
    private int heapMaxInBytes;
    private final HeapSamples samples;

    public HeapState(int maxSampleSizeMs) {
        this.samples = new HeapSamples(maxSampleSizeMs);
    }

    public int getMaxSampleSizeMs() {
        return this.samples.maxSampleSizeMs;
    }

    public List<HeapMonitor.HeapSample> getSamples() {
        return this.samples.samples;
    }

    public int getCapacity() {
        int max = this.heapMaxInBytes;
        for (HeapMonitor.HeapSample sample : this.samples.samples) {
            max = Math.max(max, sample.getBytes());
        }
        return max;
    }

    private static String printMb(int bytes) {
        return df.format((double)bytes / 1048576.0) + "MB";
    }

    public String getHeapSummary() {
        return HeapState.printMb(this.samples.samples.getLast().getBytes()) + " of " + HeapState.printMb(this.heapMaxInBytes);
    }

    void addSample(HeapMonitor.HeapSample sample) {
        this.samples.addSample(sample);
    }

    public void handleMemoryUsage(List<MemoryUsage> memoryUsages) {
        int current = 0;
        int total = 0;
        int external = 0;
        for (MemoryUsage usage : memoryUsages) {
            current += usage.getHeapUsage();
            total += usage.getHeapCapacity();
            external += usage.getExternalUsage();
        }
        this.heapMaxInBytes = total;
        this.addSample(new HeapMonitor.HeapSample(current, external));
    }

    static {
        df.setMaximumFractionDigits(1);
    }
}

