/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.InspectorObjectGroupManager;
import io.flutter.inspector.InspectorService;
import io.flutter.run.FlutterAppManager;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.AsyncUtils;
import io.flutter.utils.StreamSubscription;
import io.flutter.vmService.ServiceExtensions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.dartlang.vm.service.VmService;
import org.jetbrains.annotations.NotNull;

public class InspectorGroupManagerService
implements Disposable {
    private final Set<Listener> listeners = new HashSet<Listener>();
    boolean started = false;
    private CompletableFuture<InspectorService> inspectorServiceFuture;
    private FlutterApp app;
    private FlutterApp.FlutterAppListener appListener;
    private DiagnosticsNode selection;
    private InspectorService inspectorService;
    private InspectorObjectGroupManager selectionGroups;
    private StreamSubscription<Boolean> onStructuredErrorsStream;

    public InspectorGroupManagerService(Project project) {
        FlutterAppManager.getInstance(project).getActiveAppAsStream().listen(this::updateActiveApp, true);
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @NotNull
    public static InspectorGroupManagerService getInstance(@NotNull Project project) {
        if (project == null) {
            InspectorGroupManagerService.$$$reportNull$$$0(0);
        }
        InspectorGroupManagerService inspectorGroupManagerService = Objects.requireNonNull((InspectorGroupManagerService)project.getService(InspectorGroupManagerService.class));
        if (inspectorGroupManagerService == null) {
            InspectorGroupManagerService.$$$reportNull$$$0(1);
        }
        return inspectorGroupManagerService;
    }

    public InspectorService getInspectorService() {
        return this.inspectorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull Listener listener, Disposable disposable) {
        if (listener == null) {
            InspectorGroupManagerService.$$$reportNull$$$0(2);
        }
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
        if (this.inspectorService != null) {
            listener.onInspectorAvailable(this.inspectorService);
        }
        if (this.selection != null) {
            listener.onSelectionChanged(this.selection);
        }
        Disposer.register((Disposable)disposable, () -> this.removeListener(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            InspectorGroupManagerService.$$$reportNull$$$0(3);
        }
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    private void loadSelection() {
        this.selectionGroups.cancelNext();
        CompletableFuture<DiagnosticsNode> pendingSelectionFuture = this.selectionGroups.getNext().getSelection(null, InspectorService.FlutterTreeType.widget, true);
        this.selectionGroups.getNext().safeWhenComplete(pendingSelectionFuture, (selection, error) -> {
            if (error != null) {
                this.selectionGroups.cancelNext();
                return;
            }
            this.selectionGroups.promoteNext();
            this.invokeOnAllListeners(listener -> listener.onSelectionChanged((DiagnosticsNode)selection));
        });
    }

    private void requestRepaint(boolean force) {
        this.invokeOnAllListeners(listener -> listener.requestRepaint(force));
    }

    private void updateActiveApp(final FlutterApp app) {
        if (app == this.app) {
            return;
        }
        this.selection = null;
        if (this.app != null && this.appListener != null) {
            this.app.removeStateListener(this.appListener);
            this.appListener = null;
        }
        this.app = app;
        if (app == null) {
            return;
        }
        this.started = false;
        this.appListener = new FlutterApp.FlutterAppListener(){

            @Override
            public void stateChanged(FlutterApp.State newState) {
                if (!InspectorGroupManagerService.this.started && app.isStarted()) {
                    InspectorGroupManagerService.this.started = true;
                    InspectorGroupManagerService.this.requestRepaint(false);
                }
                if (newState == FlutterApp.State.TERMINATING) {
                    InspectorGroupManagerService.this.inspectorService = null;
                    InspectorGroupManagerService.this.invokeOnAllListeners(listener -> listener.onInspectorAvailable(InspectorGroupManagerService.this.inspectorService));
                }
            }

            @Override
            public void notifyAppReloaded() {
                InspectorGroupManagerService.this.invokeOnAllListeners(Listener::notifyAppReloaded);
                InspectorGroupManagerService.this.requestRepaint(true);
            }

            @Override
            public void notifyAppRestarted() {
                InspectorGroupManagerService.this.invokeOnAllListeners(Listener::notifyAppRestarted);
                InspectorGroupManagerService.this.requestRepaint(true);
            }

            @Override
            public void notifyVmServiceAvailable(VmService vmService) {
                assert (app.getFlutterDebugProcess() != null);
                InspectorGroupManagerService.this.inspectorServiceFuture = app.getFlutterDebugProcess().getInspectorService();
                AsyncUtils.whenCompleteUiThread(InspectorGroupManagerService.this.inspectorServiceFuture, (service, error) -> {
                    InspectorGroupManagerService.this.invokeOnAllListeners(listener -> listener.onInspectorAvailable((InspectorService)service));
                    if (InspectorGroupManagerService.this.inspectorServiceFuture == null || InspectorGroupManagerService.this.inspectorServiceFuture.getNow(null) != service) {
                        return;
                    }
                    InspectorGroupManagerService.this.inspectorService = service;
                    InspectorGroupManagerService.this.selection = null;
                    InspectorGroupManagerService.this.selectionGroups = new InspectorObjectGroupManager(InspectorGroupManagerService.this.inspectorService, "selection");
                    if (InspectorGroupManagerService.this.onStructuredErrorsStream != null) {
                        Disposer.dispose(InspectorGroupManagerService.this.onStructuredErrorsStream);
                    }
                    InspectorGroupManagerService.this.onStructuredErrorsStream = app.getVMServiceManager().hasServiceExtension(ServiceExtensions.toggleShowStructuredErrors.getExtension(), hasData -> {
                        if (hasData.booleanValue()) {
                            InspectorGroupManagerService.this.loadSelection();
                            if (app != InspectorGroupManagerService.this.app) {
                                return;
                            }
                            service.addClient(new InspectorService.InspectorServiceClient(){

                                @Override
                                public void onInspectorSelectionChanged(boolean uiAlreadyUpdated, boolean textEditorUpdated) {
                                    InspectorGroupManagerService.this.loadSelection();
                                }

                                @Override
                                public void onFlutterFrame() {
                                    InspectorGroupManagerService.this.invokeOnAllListeners(Listener::onFlutterFrame);
                                }

                                @Override
                                public CompletableFuture<?> onForceRefresh() {
                                    InspectorGroupManagerService.this.requestRepaint(true);
                                    return null;
                                }
                            });
                        }
                    });
                });
            }
        };
        app.addStateListener(this.appListener);
        if (app.getFlutterDebugProcess() != null) {
            this.appListener.notifyVmServiceAvailable(null);
        }
    }

    private void invokeOnAllListeners(InvokeListener callback) {
        AsyncUtils.invokeLater(() -> {
            ArrayList cachedListeners;
            Set<Listener> set = this.listeners;
            synchronized (set) {
                cachedListeners = Lists.newArrayList(this.listeners);
            }
            for (Listener listener : cachedListeners) {
                callback.run(listener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.clear();
        }
        if (this.app != null) {
            this.app.removeStateListener(this.appListener);
        }
        this.app = null;
        this.appListener = null;
        if (this.onStructuredErrorsStream != null) {
            Disposer.dispose(this.onStructuredErrorsStream);
            this.onStructuredErrorsStream = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/inspector/InspectorGroupManagerService";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/inspector/InspectorGroupManagerService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static interface Listener {
        public void onInspectorAvailable(InspectorService var1);

        default public void requestRepaint(boolean force) {
        }

        default public void onFlutterFrame() {
        }

        default public void notifyAppReloaded() {
        }

        default public void notifyAppRestarted() {
        }

        default public void onSelectionChanged(DiagnosticsNode selection) {
        }
    }

    private static interface InvokeListener {
        public void run(Listener var1);
    }

    public static class Client
    implements Listener {
        private InspectorService service;
        private InspectorObjectGroupManager groupManager;

        public Client(Disposable parent) {
            Disposer.register((Disposable)parent, () -> {
                if (this.groupManager != null) {
                    this.groupManager.clear(false);
                }
            });
        }

        public InspectorObjectGroupManager getGroupManager() {
            if (this.groupManager == null && this.service != null) {
                this.groupManager = new InspectorObjectGroupManager(this.service, "client");
            }
            return this.groupManager;
        }

        public FlutterApp getApp() {
            if (this.service == null) {
                return null;
            }
            return this.service.getApp();
        }

        public InspectorService getInspectorService() {
            return this.service;
        }

        @Override
        public void onInspectorAvailable(InspectorService service) {
            if (this.service == service) {
                return;
            }
            if (this.groupManager != null) {
                this.groupManager.clear(service == null);
            }
            this.service = service;
            this.groupManager = null;
            this.onInspectorAvailabilityChanged();
        }

        public void onInspectorAvailabilityChanged() {
        }

        public InspectorService.ObjectGroup getCurrentObjectGroup() {
            this.groupManager = this.getGroupManager();
            if (this.groupManager == null) {
                return null;
            }
            return this.groupManager.getCurrent();
        }
    }
}

