/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import io.flutter.inspector.InspectorService;
import java.util.concurrent.CompletableFuture;

public class InspectorObjectGroupManager {
    private final InspectorService inspectorService;
    private final String debugName;
    private InspectorService.ObjectGroup current;
    private InspectorService.ObjectGroup next;
    private CompletableFuture<Void> pendingNextFuture;

    public InspectorService getInspectorService() {
        return this.inspectorService;
    }

    public InspectorObjectGroupManager(InspectorService inspectorService, String debugName) {
        this.inspectorService = inspectorService;
        this.debugName = debugName;
    }

    public CompletableFuture<?> getPendingUpdateDone() {
        if (this.pendingNextFuture != null) {
            return this.pendingNextFuture;
        }
        if (this.next == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.pendingNextFuture = new CompletableFuture();
        return this.pendingNextFuture;
    }

    public InspectorService.ObjectGroup getCurrent() {
        if (this.current == null) {
            this.current = this.inspectorService.createObjectGroup(this.debugName);
        }
        return this.current;
    }

    public InspectorService.ObjectGroup getNext() {
        if (this.next == null) {
            this.next = this.inspectorService.createObjectGroup(this.debugName);
        }
        return this.next;
    }

    public void clear(boolean isolateStopped) {
        if (isolateStopped) {
            this.current = null;
            this.setNextNull();
        } else {
            this.clearCurrent();
            this.cancelNext();
        }
    }

    public void promoteNext() {
        this.clearCurrent();
        this.current = this.next;
        this.setNextNull();
    }

    private void clearCurrent() {
        if (this.current != null) {
            this.current.dispose();
            this.current = null;
        }
    }

    public void cancelNext() {
        if (this.next != null) {
            this.next.dispose();
            this.setNextNull();
        }
    }

    private void setNextNull() {
        this.next = null;
        if (this.pendingNextFuture != null) {
            this.pendingNextFuture.complete(null);
            this.pendingNextFuture = null;
        }
    }
}

