/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.google.common.base.Joiner;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import io.flutter.bazel.Workspace;
import io.flutter.bazel.WorkspaceCache;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.DiagnosticsPathNode;
import io.flutter.inspector.EvalOnDartLibrary;
import io.flutter.inspector.InspectorInstanceRef;
import io.flutter.inspector.Screenshot;
import io.flutter.inspector.TransformedRect;
import io.flutter.pub.PubRoot;
import io.flutter.run.FlutterDebugProcess;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.JsonUtils;
import io.flutter.utils.StreamSubscription;
import io.flutter.utils.VmServiceListenerAdapter;
import io.flutter.vmService.VmServiceConsumers;
import io.flutter.vmService.frame.DartVmServiceValue;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.ServiceExtensionConsumer;
import org.dartlang.vm.service.element.ClassRef;
import org.dartlang.vm.service.element.Element;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.FieldRef;
import org.dartlang.vm.service.element.FuncRef;
import org.dartlang.vm.service.element.Instance;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.LibraryRef;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.SourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectorService
implements Disposable {
    private static int nextGroupId = 0;
    @NotNull
    private final FlutterApp app;
    @NotNull
    private final FlutterDebugProcess debugProcess;
    @NotNull
    private final VmService vmService;
    @NotNull
    private final Set<InspectorServiceClient> clients;
    @NotNull
    private final EvalOnDartLibrary inspectorLibrary;
    @NotNull
    private final Set<String> supportedServiceMethods;
    private final StreamSubscription<Boolean> setPubRootDirectoriesSubscription;

    public static CompletableFuture<ObjectGroup> createGroup(@NotNull FlutterApp app, @NotNull FlutterDebugProcess debugProcess, @NotNull VmService vmService, String groupName) {
        if (app == null) {
            InspectorService.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            InspectorService.$$$reportNull$$$0(1);
        }
        if (vmService == null) {
            InspectorService.$$$reportNull$$$0(2);
        }
        return InspectorService.create(app, debugProcess, vmService).thenApplyAsync(service -> service.createObjectGroup(groupName));
    }

    public static CompletableFuture<InspectorService> create(@NotNull FlutterApp app, @NotNull FlutterDebugProcess debugProcess, @NotNull VmService vmService) {
        if (app == null) {
            InspectorService.$$$reportNull$$$0(3);
        }
        if (debugProcess == null) {
            InspectorService.$$$reportNull$$$0(4);
        }
        if (vmService == null) {
            InspectorService.$$$reportNull$$$0(5);
        }
        assert (app.getVMServiceManager() != null);
        HashSet<String> inspectorLibraryNames = new HashSet<String>();
        inspectorLibraryNames.add("package:flutter/src/widgets/widget_inspector.dart");
        EvalOnDartLibrary inspectorLibrary = new EvalOnDartLibrary(inspectorLibraryNames, vmService, app.getVMServiceManager());
        CompletionStage libraryFuture = inspectorLibrary.libraryRef.thenComposeAsync(library -> inspectorLibrary.getLibrary((LibraryRef)library, null));
        return ((CompletableFuture)((CompletableFuture)libraryFuture).thenComposeAsync(library -> {
            for (ClassRef classRef : library.getClasses()) {
                if (!"WidgetInspectorService".equals(classRef.getName())) continue;
                return inspectorLibrary.getClass(classRef, null).thenApplyAsync(classObj -> {
                    HashSet<String> functionNames = new HashSet<String>();
                    for (FuncRef funcRef : classObj.getFunctions()) {
                        functionNames.add(funcRef.getName());
                    }
                    return functionNames;
                });
            }
            throw new RuntimeException("WidgetInspectorService class not found");
        })).thenApplyAsync(supportedServiceMethods -> new InspectorService(app, debugProcess, vmService, inspectorLibrary, (Set<String>)supportedServiceMethods));
    }

    private InspectorService(@NotNull FlutterApp app, @NotNull FlutterDebugProcess debugProcess, @NotNull VmService vmService, @NotNull EvalOnDartLibrary inspectorLibrary, @NotNull Set<String> supportedServiceMethods) {
        if (app == null) {
            InspectorService.$$$reportNull$$$0(6);
        }
        if (debugProcess == null) {
            InspectorService.$$$reportNull$$$0(7);
        }
        if (vmService == null) {
            InspectorService.$$$reportNull$$$0(8);
        }
        if (inspectorLibrary == null) {
            InspectorService.$$$reportNull$$$0(9);
        }
        if (supportedServiceMethods == null) {
            InspectorService.$$$reportNull$$$0(10);
        }
        this.vmService = vmService;
        this.app = app;
        this.debugProcess = debugProcess;
        this.inspectorLibrary = inspectorLibrary;
        this.supportedServiceMethods = supportedServiceMethods;
        this.clients = new HashSet<InspectorServiceClient>();
        vmService.addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                InspectorService.this.onVmServiceReceived(streamId, event);
            }

            @Override
            public void connectionClosed() {
            }
        });
        vmService.streamListen("Extension", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        assert (app.getVMServiceManager() != null);
        this.setPubRootDirectoriesSubscription = app.getVMServiceManager().hasServiceExtension("ext.flutter.inspector.setPubRootDirectories", available -> {
            if (!available.booleanValue()) {
                return;
            }
            Workspace workspace = WorkspaceCache.getInstance(app.getProject()).get();
            ArrayList<String> rootDirectories = new ArrayList<String>();
            if (workspace != null) {
                for (VirtualFile root : InspectorService.rootsForProject(app.getProject())) {
                    String relativePath = workspace.getRelativePath(root);
                    if (relativePath == null) continue;
                    rootDirectories.add("google3:///" + relativePath);
                }
            } else {
                for (PubRoot root : app.getPubRoots()) {
                    Object path = root.getRoot().getCanonicalPath();
                    if (SystemInfo.isWindows) {
                        path = "file:///" + (String)path;
                    }
                    rootDirectories.add((String)path);
                }
            }
            this.setPubRootDirectories(rootDirectories);
        });
    }

    @NotNull
    private static List<VirtualFile> rootsForProject(@NotNull Project project) {
        if (project == null) {
            InspectorService.$$$reportNull$$$0(11);
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Collections.addAll(result, ModuleRootManager.getInstance((Module)module).getContentRoots());
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            InspectorService.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private boolean useServiceExtensionApi() {
        return !this.app.isFlutterIsolateSuspended();
    }

    public boolean isDetailsSummaryViewSupported() {
        return this.hasServiceMethod("getSelectedSummaryWidget");
    }

    public boolean isHotUiScreenMirrorSupported() {
        return this.hasServiceMethod("getBoundingBoxes");
    }

    private boolean hasServiceMethod(String methodName) {
        return this.supportedServiceMethods.contains(methodName);
    }

    @NotNull
    public FlutterDebugProcess getDebugProcess() {
        FlutterDebugProcess flutterDebugProcess = this.debugProcess;
        if (flutterDebugProcess == null) {
            InspectorService.$$$reportNull$$$0(13);
        }
        return flutterDebugProcess;
    }

    public FlutterApp getApp() {
        return this.debugProcess.getApp();
    }

    public ObjectGroup createObjectGroup(String debugName) {
        return new ObjectGroup(this, debugName);
    }

    @NotNull
    private EvalOnDartLibrary getInspectorLibrary() {
        EvalOnDartLibrary evalOnDartLibrary = this.inspectorLibrary;
        if (evalOnDartLibrary == null) {
            InspectorService.$$$reportNull$$$0(14);
        }
        return evalOnDartLibrary;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.inspectorLibrary);
        Disposer.dispose(this.setPubRootDirectoriesSubscription);
    }

    public CompletableFuture<?> forceRefresh() {
        ArrayList futures = new ArrayList();
        for (InspectorServiceClient client : this.clients) {
            CompletableFuture<?> future = client.onForceRefresh();
            if (future == null || future.isDone()) continue;
            futures.add(future);
        }
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private void notifySelectionChanged(boolean uiAlreadyUpdated, boolean textEditorUpdated) {
        ApplicationManager.getApplication().invokeLater(() -> {
            for (InspectorServiceClient client : this.clients) {
                client.onInspectorSelectionChanged(uiAlreadyUpdated, textEditorUpdated);
            }
        });
    }

    public void addClient(InspectorServiceClient client) {
        this.clients.add(client);
    }

    public void removeClient(InspectorServiceClient client) {
        this.clients.remove(client);
    }

    private void onVmServiceReceived(String streamId, Event event) {
        switch (streamId) {
            case "Debug": {
                if (event.getKind() != EventKind.Inspect) break;
                this.notifySelectionChanged(false, false);
                break;
            }
            case "Extension": {
                if (!"Flutter.Frame".equals(event.getExtensionKind())) break;
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (InspectorServiceClient client : this.clients) {
                        client.onFlutterFrame();
                    }
                });
                break;
            }
            case "ToolEvent": {
                String path;
                Optional<Event> eventOrNull = Optional.ofNullable(event);
                if (!"navigate".equals(eventOrNull.map(Event::getExtensionKind).orElse(null))) break;
                JsonObject json = eventOrNull.map(Event::getExtensionData).map(Element::getJson).orElse(null);
                if (json == null) {
                    return;
                }
                String fileUri = JsonUtils.getStringMember(json, "fileUri");
                if (fileUri == null) {
                    return;
                }
                try {
                    path = new URL(fileUri).getFile();
                }
                catch (MalformedURLException e) {
                    return;
                }
                if (path == null) {
                    return;
                }
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                int line = JsonUtils.getIntMember(json, "line");
                int column = JsonUtils.getIntMember(json, "column");
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (file != null && line >= 0 && column >= 0) {
                        XSourcePositionImpl position = XSourcePositionImpl.create((VirtualFile)file, (int)(line - 1), (int)(column - 1));
                        position.createNavigatable(this.app.getProject()).navigate(false);
                    }
                });
                break;
            }
        }
    }

    public CompletableFuture<Boolean> isWidgetTreeReady() {
        if (this.useServiceExtensionApi()) {
            return this.invokeServiceExtensionNoGroup("isWidgetTreeReady", new JsonObject()).thenApplyAsync(JsonElement::getAsBoolean);
        }
        return this.invokeEvalNoGroup("isWidgetTreeReady").thenApplyAsync(ref -> "true".equals(ref.getValueAsString()));
    }

    CompletableFuture<JsonElement> invokeServiceExtensionNoGroup(String methodName, List<String> args) {
        JsonObject params = new JsonObject();
        for (int i = 0; i < args.size(); ++i) {
            params.addProperty("arg" + i, args.get(i));
        }
        return this.invokeServiceExtensionNoGroup(methodName, params);
    }

    private CompletableFuture<Void> setPubRootDirectories(List<String> rootDirectories) {
        if (this.useServiceExtensionApi()) {
            return this.invokeServiceExtensionNoGroup("setPubRootDirectories", rootDirectories).thenApplyAsync(ignored -> null);
        }
        JsonArray jsonArray = new JsonArray();
        for (String rootDirectory : rootDirectories) {
            jsonArray.add(rootDirectory);
        }
        return this.getInspectorLibrary().eval("WidgetInspectorService.instance.setPubRootDirectories(" + new Gson().toJson((JsonElement)jsonArray) + ")", null, null).thenApplyAsync(instance -> null);
    }

    CompletableFuture<InstanceRef> invokeEvalNoGroup(String methodName) {
        return this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "()", null, null);
    }

    CompletableFuture<JsonElement> invokeServiceExtensionNoGroup(String methodName, JsonObject params) {
        return this.invokeServiceExtensionHelper(methodName, params);
    }

    private CompletableFuture<JsonElement> invokeServiceExtensionHelper(final String methodName, JsonObject params) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (String key : JsonUtils.getKeySet(params)) {
            if (!params.get(key).isJsonNull()) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            params.remove(key);
        }
        final CompletableFuture<JsonElement> ret = new CompletableFuture<JsonElement>();
        this.vmService.callServiceExtension(this.getInspectorLibrary().getIsolateId(), "ext.flutter.inspector." + methodName, params, new ServiceExtensionConsumer(){

            @Override
            public void received(JsonObject object) {
                if (object == null) {
                    ret.complete(null);
                } else {
                    ret.complete(object.get("result"));
                }
            }

            @Override
            public void onError(RPCError error) {
                ret.completeExceptionally(new RuntimeException("RPCError calling " + methodName + ": " + error.getMessage()));
            }
        });
        return ret;
    }

    public static String getFileUriPrefix() {
        return SystemInfo.isWindows ? "file:///" : "file://";
    }

    public static String toSourceLocationUri(String path) {
        return InspectorService.getFileUriPrefix() + path;
    }

    public static String fromSourceLocationUri(String path, Project project) {
        String filePrefix;
        Workspace workspace = WorkspaceCache.getInstance(project).get();
        if (workspace != null) {
            path = workspace.convertPath(path);
        }
        return path.startsWith(filePrefix = InspectorService.getFileUriPrefix()) ? path.substring(filePrefix.length()) : path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectorLibrary";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedServiceMethods";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/inspector/InspectorService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/inspector/InspectorService";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "rootsForProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGroup";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "rootsForProject";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    public class ObjectGroup
    implements Disposable {
        final InspectorService service;
        final String groupName;
        volatile boolean disposed;
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        private ObjectGroup(InspectorService service, String debugName) {
            this.service = service;
            this.groupName = debugName + "_" + nextGroupId;
            ++nextGroupId;
        }

        public InspectorService getInspectorService() {
            return this.service;
        }

        public void dispose() {
            if (this.disposed) {
                return;
            }
            this.lock.writeLock().lock();
            this.invokeVoidServiceMethod("disposeGroup", this.groupName);
            this.disposed = true;
            this.lock.writeLock().unlock();
        }

        private <T> CompletableFuture<T> nullIfDisposed(Supplier<CompletableFuture<T>> supplier) {
            this.lock.readLock().lock();
            if (this.disposed) {
                this.lock.readLock().unlock();
                return CompletableFuture.completedFuture(null);
            }
            try {
                CompletableFuture<T> completableFuture = supplier.get();
                return completableFuture;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private <T> T nullValueIfDisposed(Supplier<T> supplier) {
            this.lock.readLock().lock();
            if (this.disposed) {
                this.lock.readLock().unlock();
                return null;
            }
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private void skipIfDisposed(Runnable runnable) {
            this.lock.readLock().lock();
            if (this.disposed) {
                return;
            }
            try {
                runnable.run();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public CompletableFuture<XSourcePosition> getPropertyLocation(InstanceRef instanceRef, String name) {
            return this.nullIfDisposed(() -> this.getInstance(instanceRef).thenComposeAsync(instance -> this.nullValueIfDisposed(() -> this.getPropertyLocationHelper(instance.getClassRef(), name))));
        }

        public CompletableFuture<XSourcePosition> getPropertyLocationHelper(ClassRef classRef, String name) {
            return this.nullIfDisposed(() -> InspectorService.this.inspectorLibrary.getClass(classRef, this).thenComposeAsync(clazz -> this.nullIfDisposed(() -> {
                for (FuncRef f : clazz.getFunctions()) {
                    if (!f.getName().equals(name)) continue;
                    return InspectorService.this.inspectorLibrary.getFunc(f, this).thenComposeAsync(func -> this.nullIfDisposed(() -> {
                        SourceLocation location = func.getLocation();
                        return InspectorService.this.inspectorLibrary.getSourcePosition(InspectorService.this.debugProcess, location.getScript(), location.getTokenPos(), this);
                    }));
                }
                ClassRef superClass = clazz.getSuperClass();
                return superClass == null ? CompletableFuture.completedFuture(null) : this.getPropertyLocationHelper(superClass, name);
            })));
        }

        public CompletableFuture<DiagnosticsNode> getRoot(FlutterTreeType type) {
            assert (!this.disposed);
            switch (type) {
                case widget: {
                    return this.getRootWidget();
                }
                case renderObject: {
                    return this.getRootRenderObject();
                }
            }
            throw new RuntimeException("Unexpected FlutterTreeType");
        }

        CompletableFuture<InstanceRef> invokeEval(String methodName) {
            return this.nullIfDisposed(() -> this.invokeEval(methodName, this.groupName));
        }

        CompletableFuture<InstanceRef> invokeEval(String methodName, String arg1) {
            return this.nullIfDisposed(() -> InspectorService.this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "(\"" + arg1 + "\")", null, this));
        }

        CompletableFuture<JsonElement> invokeVmServiceExtension(String methodName) {
            return this.invokeVmServiceExtension(methodName, this.groupName);
        }

        CompletableFuture<JsonElement> invokeVmServiceExtension(String methodName, String objectGroup) {
            JsonObject params = new JsonObject();
            params.addProperty("objectGroup", objectGroup);
            return this.invokeVmServiceExtension(methodName, params);
        }

        CompletableFuture<JsonElement> invokeVmServiceExtension(String methodName, String arg, String objectGroup) {
            JsonObject params = new JsonObject();
            params.addProperty("arg", arg);
            params.addProperty("objectGroup", objectGroup);
            return this.invokeVmServiceExtension(methodName, params);
        }

        CompletableFuture<JsonElement> invokeVmServiceExtension(String methodName, JsonObject paramsMap) {
            return InspectorService.this.getInspectorLibrary().addRequest(this, methodName, () -> InspectorService.this.invokeServiceExtensionHelper(methodName, paramsMap));
        }

        CompletableFuture<JsonElement> invokeVmServiceExtension(String methodName, InspectorInstanceRef arg) {
            if (arg == null || arg.getId() == null) {
                return this.invokeVmServiceExtension(methodName, null, this.groupName);
            }
            return this.invokeVmServiceExtension(methodName, arg.getId(), this.groupName);
        }

        private void addLocationToParams(Location location, JsonObject params) {
            if (location == null) {
                return;
            }
            params.addProperty("file", location.getPath());
            params.addProperty("line", (Number)location.getLine());
            params.addProperty("column", (Number)location.getColumn());
        }

        public CompletableFuture<ArrayList<DiagnosticsNode>> getElementsAtLocation(Location location, int count) {
            JsonObject params = new JsonObject();
            this.addLocationToParams(location, params);
            params.addProperty("count", (Number)count);
            params.addProperty("groupName", this.groupName);
            return this.parseDiagnosticsNodesDaemon((CompletableFuture<JsonElement>)InspectorService.this.inspectorLibrary.invokeServiceMethod("ext.flutter.inspector.getElementsAtLocation", params).thenApplyAsync(o -> {
                if (o == null) {
                    return null;
                }
                return o.get("result");
            }), null);
        }

        public CompletableFuture<ArrayList<DiagnosticsNode>> getBoundingBoxes(DiagnosticsNode root, DiagnosticsNode target) {
            JsonObject params = new JsonObject();
            if (root == null || target == null || root.getValueRef() == null || target.getValueRef() == null) {
                return CompletableFuture.completedFuture(new ArrayList());
            }
            params.addProperty("rootId", root.getValueRef().getId());
            params.addProperty("targetId", target.getValueRef().getId());
            params.addProperty("groupName", this.groupName);
            return this.parseDiagnosticsNodesDaemon((CompletableFuture<JsonElement>)InspectorService.this.inspectorLibrary.invokeServiceMethod("ext.flutter.inspector.getBoundingBoxes", params).thenApplyAsync(o -> {
                if (o == null) {
                    return null;
                }
                return o.get("result");
            }), null);
        }

        public CompletableFuture<ArrayList<DiagnosticsNode>> hitTest(DiagnosticsNode root, double dx, double dy, String file, int startLine, int endLine) {
            JsonObject params = new JsonObject();
            if (root == null || root.getValueRef() == null) {
                return CompletableFuture.completedFuture(new ArrayList());
            }
            params.addProperty("id", root.getValueRef().getId());
            params.addProperty("dx", (Number)dx);
            params.addProperty("dy", (Number)dy);
            if (file != null) {
                params.addProperty("file", file);
            }
            if (startLine >= 0 && endLine >= 0) {
                params.addProperty("startLine", (Number)startLine);
                params.addProperty("endLine", (Number)endLine);
            }
            params.addProperty("groupName", this.groupName);
            return this.parseDiagnosticsNodesDaemon((CompletableFuture<JsonElement>)InspectorService.this.inspectorLibrary.invokeServiceMethod("ext.flutter.inspector.hitTest", params).thenApplyAsync(o -> {
                if (o == null) {
                    return null;
                }
                return o.get("result");
            }), null);
        }

        public CompletableFuture<Boolean> setColorProperty(DiagnosticsNode target, Color color) {
            if (target == null || target.getValueRef() == null || color == null) {
                return CompletableFuture.completedFuture(false);
            }
            String command = "final object = WidgetInspectorService.instance.toObject('" + target.getValueRef().getId() + "');if (object is! Element) return false;\nfinal Element element = object;\nfinal color = Color.fromARGB(" + color.getAlpha() + "," + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");\nRenderObject render = element?.renderObject;\n\nif (render is RenderParagraph) {\n  RenderParagraph paragraph = render;\n  final InlineSpan inlineSpan = paragraph.text;\n  if (inlineSpan is! TextSpan) return false;\n  final TextSpan existing = inlineSpan;\n  paragraph.text = TextSpan(text: existing.text,\n    children: existing.children,\n    style: existing.style.copyWith(color: color),\n    recognizer: existing.recognizer,\n    semanticsLabel: existing.semanticsLabel,\n  );\n  return true;\n} else {\n  RenderDecoratedBox findFirstMatching(Element root) {\n    RenderDecoratedBox match = null;\n    void _matchHelper(Element e) {\n      if (match != null || !identical(e, root) && _isLocalCreationLocation(e)) return;\n      final r = e.renderObject;\n      if (r is RenderDecoratedBox) {\n        match = r;\n        return;\n      }\n      e.visitChildElements(_matchHelper);\n    }\n    _matchHelper(root);\n    return match;\n  }\n\n  final RenderDecoratedBox render = findFirstMatching(element);\n  if (render != null) {\n    final BoxDecoration existingDecoration = render.decoration;\n    BoxDecoration decoration;\n    if (existingDecoration is BoxDecoration) {\n      decoration = existingDecoration.copyWith(color: color);\n    } else if (existingDecoration == null) {\n      decoration = BoxDecoration(color: color);\n    }\n    if (decoration != null) {\n      render.decoration = decoration;\n      return true;\n    }\n  }\n}\nreturn false;\n";
            return this.evaluateCustomApiHelper(command, new HashMap<String, String>()).thenApplyAsync(instanceRef -> instanceRef != null && "true".equals(instanceRef.getValueAsString()));
        }

        private CompletableFuture<InstanceRef> evaluateCustomApiHelper(String command, Map<String, String> scope) {
            if (this.isDisposed()) {
                return CompletableFuture.completedFuture(null);
            }
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("((){");
            lines.add("if (SchedulerBinding.instance.schedulerPhase != SchedulerPhase.idle) return null;");
            String[] commandLines = command.split("\n");
            Collections.addAll(lines, commandLines);
            lines.add(")()");
            String expression = Joiner.on((String)"").join(lines);
            return this.evalWithRetry(expression, scope);
        }

        private CompletableFuture<InstanceRef> evalWithRetry(String expression, Map<String, String> scope) {
            if (this.isDisposed()) {
                return CompletableFuture.completedFuture(null);
            }
            return InspectorService.this.inspectorLibrary.eval(expression, scope, this).thenComposeAsync(instanceRef -> {
                if (instanceRef == null) {
                    return CompletableFuture.completedFuture(null);
                }
                if (instanceRef.isNull()) {
                    return this.evalWithRetry(expression, scope);
                }
                return CompletableFuture.completedFuture(instanceRef);
            });
        }

        public CompletableFuture<InteractiveScreenshot> getScreenshotAtLocation(Location location, int count, int width, int height, double maxPixelRatio) {
            JsonObject params = new JsonObject();
            this.addLocationToParams(location, params);
            params.addProperty("count", (Number)count);
            params.addProperty("width", (Number)width);
            params.addProperty("height", (Number)height);
            params.addProperty("maxPixelRatio", (Number)maxPixelRatio);
            params.addProperty("groupName", this.groupName);
            return this.nullIfDisposed(() -> InspectorService.this.inspectorLibrary.invokeServiceMethod("ext.flutter.inspector.screenshotAtLocation", params).thenApplyAsync(response -> {
                if (response == null || response.get("result").isJsonNull()) {
                    return null;
                }
                JsonObject result = response.getAsJsonObject("result");
                Screenshot screenshot = null;
                JsonElement screenshotJson = result.get("screenshot");
                if (screenshotJson != null && !screenshotJson.isJsonNull()) {
                    screenshot = this.getScreenshotFromJson(screenshotJson.getAsJsonObject());
                }
                return new InteractiveScreenshot(screenshot, this.parseDiagnosticsNodesHelper(result.get("boxes"), null), this.parseDiagnosticsNodesHelper(result.get("elements"), null));
            }));
        }

        public CompletableFuture<Screenshot> getScreenshot(InspectorInstanceRef ref, int width, int height, double maxPixelRatio) {
            JsonObject params = new JsonObject();
            params.addProperty("width", (Number)width);
            params.addProperty("height", (Number)height);
            params.addProperty("maxPixelRatio", (Number)maxPixelRatio);
            params.addProperty("id", ref.getId());
            return this.nullIfDisposed(() -> InspectorService.this.inspectorLibrary.invokeServiceMethod("ext.flutter.inspector.screenshot", params).thenApplyAsync(response -> {
                if (response == null || response.get("result").isJsonNull()) {
                    return null;
                }
                JsonObject result = response.getAsJsonObject("result");
                return this.getScreenshotFromJson(result);
            }));
        }

        @NotNull
        private Screenshot getScreenshotFromJson(JsonObject result) {
            BufferedImage image;
            String imageString = result.getAsJsonPrimitive("image").getAsString();
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] imageBytes = decoder.decode(imageString);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(imageBytes);
            try {
                image = ImageIO.read(byteArrayInputStream);
                byteArrayInputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error decoding image: " + e.getMessage());
            }
            TransformedRect transformedRect = new TransformedRect(result.getAsJsonObject("transformedRect"));
            return new Screenshot(image, transformedRect);
        }

        CompletableFuture<InstanceRef> invokeEval(String methodName, InspectorInstanceRef arg) {
            return this.nullIfDisposed(() -> {
                if (arg == null || arg.getId() == null) {
                    return InspectorService.this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "(null, \"" + this.groupName + "\")", null, this);
                }
                return InspectorService.this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "(\"" + arg.getId() + "\", \"" + this.groupName + "\")", null, this);
            });
        }

        CompletableFuture<InstanceRef> invokeServiceMethodOnRefEval(String methodName, InstanceRef arg) {
            return this.nullIfDisposed(() -> {
                HashMap<String, String> scope = new HashMap<String, String>();
                if (arg == null) {
                    return InspectorService.this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "(null, \"" + this.groupName + "\")", scope, this);
                }
                scope.put("arg1", arg.getId());
                return InspectorService.this.getInspectorLibrary().eval("WidgetInspectorService.instance." + methodName + "(arg1, \"" + this.groupName + "\")", scope, this);
            });
        }

        CompletableFuture<DiagnosticsNode> parseDiagnosticsNodeVmService(CompletableFuture<InstanceRef> instanceRefFuture) {
            return this.nullIfDisposed(() -> instanceRefFuture.thenComposeAsync(this::parseDiagnosticsNodeVmService));
        }

        public CompletableFuture<Map<String, InstanceRef>> getDartObjectProperties(InspectorInstanceRef inspectorInstanceRef, String[] propertyNames) {
            return this.nullIfDisposed(() -> this.toVmServiceInstanceRef(inspectorInstanceRef).thenComposeAsync(instanceRef -> this.nullIfDisposed(() -> {
                StringBuilder sb = new StringBuilder();
                ArrayList<CallSite> propertyAccessors = new ArrayList<CallSite>();
                String objectName = "that";
                for (String propertyName : propertyNames) {
                    propertyAccessors.add((CallSite)((Object)("that." + propertyName)));
                }
                sb.append("[");
                sb.append(Joiner.on((char)',').join(propertyAccessors));
                sb.append("]");
                HashMap<String, String> scope = new HashMap<String, String>();
                scope.put("that", instanceRef.getId());
                return this.getInstance(InspectorService.this.inspectorLibrary.eval(sb.toString(), scope, this)).thenApplyAsync(instance -> this.nullValueIfDisposed(() -> {
                    HashMap<String, InstanceRef> properties = new HashMap<String, InstanceRef>();
                    ElementList<InstanceRef> values = instance.getElements();
                    assert (values.size() == propertyNames.length);
                    for (int i = 0; i < propertyNames.length; ++i) {
                        properties.put(propertyNames[i], values.get(i));
                    }
                    return properties;
                }));
            })));
        }

        public CompletableFuture<InstanceRef> toVmServiceInstanceRef(InspectorInstanceRef inspectorInstanceRef) {
            return this.nullIfDisposed(() -> this.invokeEval("toObject", inspectorInstanceRef));
        }

        private CompletableFuture<Instance> getInstance(InstanceRef instanceRef) {
            return this.nullIfDisposed(() -> InspectorService.this.getInspectorLibrary().getInstance(instanceRef, this));
        }

        CompletableFuture<Instance> getInstance(CompletableFuture<InstanceRef> instanceRefFuture) {
            return this.nullIfDisposed(() -> instanceRefFuture.thenComposeAsync(this::getInstance));
        }

        CompletableFuture<DiagnosticsNode> parseDiagnosticsNodeVmService(InstanceRef instanceRef) {
            return this.nullIfDisposed(() -> this.instanceRefToJson(instanceRef).thenApplyAsync(this::parseDiagnosticsNodeHelper));
        }

        CompletableFuture<DiagnosticsNode> parseDiagnosticsNodeDaemon(CompletableFuture<JsonElement> json) {
            return this.nullIfDisposed(() -> json.thenApplyAsync(this::parseDiagnosticsNodeHelper));
        }

        DiagnosticsNode parseDiagnosticsNodeHelper(JsonElement jsonElement) {
            return this.nullValueIfDisposed(() -> {
                if (jsonElement == null || jsonElement.isJsonNull()) {
                    return null;
                }
                return new DiagnosticsNode(jsonElement.getAsJsonObject(), this, false, null);
            });
        }

        CompletableFuture<JsonElement> instanceRefToJson(CompletableFuture<InstanceRef> instanceRefFuture) {
            return this.nullIfDisposed(() -> instanceRefFuture.thenComposeAsync(this::instanceRefToJson));
        }

        CompletableFuture<JsonElement> instanceRefToJson(InstanceRef instanceRef) {
            if (instanceRef.getValueAsString() != null && !instanceRef.getValueAsStringIsTruncated()) {
                JsonElement json = JsonUtils.parseString(instanceRef.getValueAsString());
                return CompletableFuture.completedFuture(json);
            }
            return this.nullIfDisposed(() -> InspectorService.this.getInspectorLibrary().getInstance(instanceRef, this).thenApplyAsync(instance -> this.nullValueIfDisposed(() -> {
                String json = instance.getValueAsString();
                return JsonUtils.parseString(json);
            })));
        }

        CompletableFuture<ArrayList<DiagnosticsNode>> parseDiagnosticsNodesVmService(InstanceRef instanceRef, DiagnosticsNode parent) {
            return this.nullIfDisposed(() -> this.instanceRefToJson(instanceRef).thenApplyAsync(jsonElement -> this.nullValueIfDisposed(() -> {
                JsonArray jsonArray = jsonElement != null ? jsonElement.getAsJsonArray() : null;
                return this.parseDiagnosticsNodesHelper(jsonArray, parent);
            })));
        }

        ArrayList<DiagnosticsNode> parseDiagnosticsNodesHelper(JsonElement jsonObject, DiagnosticsNode parent) {
            return this.parseDiagnosticsNodesHelper(jsonObject != null && !jsonObject.isJsonNull() ? jsonObject.getAsJsonArray() : null, parent);
        }

        ArrayList<DiagnosticsNode> parseDiagnosticsNodesHelper(JsonArray jsonArray, DiagnosticsNode parent) {
            return this.nullValueIfDisposed(() -> {
                if (jsonArray == null) {
                    return null;
                }
                ArrayList<DiagnosticsNode> nodes = new ArrayList<DiagnosticsNode>();
                for (JsonElement element : jsonArray) {
                    nodes.add(new DiagnosticsNode(element.getAsJsonObject(), this, false, parent));
                }
                return nodes;
            });
        }

        public CompletableFuture<DartVmServiceValue> toDartVmServiceValue(InspectorInstanceRef inspectorInstanceRef) {
            return this.invokeEval("toObject", inspectorInstanceRef).thenApplyAsync(instanceRef -> this.nullValueIfDisposed(() -> new DartVmServiceValue(InspectorService.this.debugProcess, InspectorService.this.inspectorLibrary.getIsolateId(), "inspectedObject", (InstanceRef)instanceRef, null, null, false)));
        }

        public CompletableFuture<DartVmServiceValue> toDartVmServiceValueForSourceLocation(InspectorInstanceRef inspectorInstanceRef) {
            return this.invokeEval("toObjectForSourceLocation", inspectorInstanceRef).thenApplyAsync(instanceRef -> this.nullValueIfDisposed(() -> new DartVmServiceValue(InspectorService.this.debugProcess, InspectorService.this.inspectorLibrary.getIsolateId(), "inspectedObject", (InstanceRef)instanceRef, null, null, false)));
        }

        CompletableFuture<ArrayList<DiagnosticsNode>> parseDiagnosticsNodesVmService(CompletableFuture<InstanceRef> instanceRefFuture, DiagnosticsNode parent) {
            return this.nullIfDisposed(() -> instanceRefFuture.thenComposeAsync(instanceRef -> this.parseDiagnosticsNodesVmService((InstanceRef)instanceRef, parent)));
        }

        CompletableFuture<ArrayList<DiagnosticsNode>> parseDiagnosticsNodesDaemon(CompletableFuture<JsonElement> jsonFuture, DiagnosticsNode parent) {
            return this.nullIfDisposed(() -> jsonFuture.thenApplyAsync(json -> this.parseDiagnosticsNodesHelper((JsonElement)json, parent)));
        }

        CompletableFuture<ArrayList<DiagnosticsNode>> getChildren(InspectorInstanceRef instanceRef, boolean summaryTree, DiagnosticsNode parent) {
            if (InspectorService.this.isDetailsSummaryViewSupported()) {
                return this.getListHelper(instanceRef, summaryTree ? "getChildrenSummaryTree" : "getChildrenDetailsSubtree", parent);
            }
            return this.getListHelper(instanceRef, "getChildren", parent);
        }

        CompletableFuture<ArrayList<DiagnosticsNode>> getProperties(InspectorInstanceRef instanceRef) {
            return this.getListHelper(instanceRef, "getProperties", null);
        }

        private CompletableFuture<ArrayList<DiagnosticsNode>> getListHelper(InspectorInstanceRef instanceRef, String methodName, DiagnosticsNode parent) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useServiceExtensionApi()) {
                    return this.parseDiagnosticsNodesDaemon(this.invokeVmServiceExtension(methodName, instanceRef), parent);
                }
                return this.parseDiagnosticsNodesVmService(this.invokeEval(methodName, instanceRef), parent);
            });
        }

        public CompletableFuture<DiagnosticsNode> invokeServiceMethodReturningNode(String methodName) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useServiceExtensionApi()) {
                    return this.parseDiagnosticsNodeDaemon(this.invokeVmServiceExtension(methodName));
                }
                return this.parseDiagnosticsNodeVmService(this.invokeEval(methodName));
            });
        }

        public CompletableFuture<DiagnosticsNode> invokeServiceMethodReturningNode(String methodName, InspectorInstanceRef ref) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useServiceExtensionApi()) {
                    return this.parseDiagnosticsNodeDaemon(this.invokeVmServiceExtension(methodName, ref));
                }
                return this.parseDiagnosticsNodeVmService(this.invokeEval(methodName, ref));
            });
        }

        public CompletableFuture<Void> invokeVoidServiceMethod(String methodName, String arg1) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useServiceExtensionApi()) {
                    return this.invokeVmServiceExtension(methodName, arg1).thenApply(ignored -> null);
                }
                return this.invokeEval(methodName, arg1).thenApply(ignored -> null);
            });
        }

        public CompletableFuture<Void> invokeVoidServiceMethod(String methodName, InspectorInstanceRef ref) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useServiceExtensionApi()) {
                    return this.invokeVmServiceExtension(methodName, ref).thenApply(ignored -> null);
                }
                return this.invokeEval(methodName, ref).thenApply(ignored -> null);
            });
        }

        public CompletableFuture<DiagnosticsNode> getRootWidget() {
            return this.invokeServiceMethodReturningNode(InspectorService.this.isDetailsSummaryViewSupported() ? "getRootWidgetSummaryTree" : "getRootWidget");
        }

        public CompletableFuture<DiagnosticsNode> getElementForScreenshot() {
            return this.invokeServiceMethodReturningNode("getElementForScreenshot");
        }

        public CompletableFuture<DiagnosticsNode> getSummaryTreeWithoutIds() {
            return this.parseDiagnosticsNodeDaemon(this.invokeVmServiceExtension("getRootWidgetSummaryTree", new JsonObject()));
        }

        public CompletableFuture<DiagnosticsNode> getRootRenderObject() {
            assert (!this.disposed);
            return this.invokeServiceMethodReturningNode("getRootRenderObject");
        }

        public CompletableFuture<ArrayList<DiagnosticsPathNode>> getParentChain(DiagnosticsNode target) {
            return this.nullIfDisposed(() -> {
                if (InspectorService.this.useServiceExtensionApi()) {
                    return this.parseDiagnosticsPathDaemon(this.invokeVmServiceExtension("getParentChain", target.getValueRef()));
                }
                return this.parseDiagnosticsPathVmService(this.invokeEval("getParentChain", target.getValueRef()));
            });
        }

        CompletableFuture<ArrayList<DiagnosticsPathNode>> parseDiagnosticsPathVmService(CompletableFuture<InstanceRef> instanceRefFuture) {
            return this.nullIfDisposed(() -> instanceRefFuture.thenComposeAsync(this::parseDiagnosticsPathVmService));
        }

        private CompletableFuture<ArrayList<DiagnosticsPathNode>> parseDiagnosticsPathVmService(InstanceRef pathRef) {
            return this.nullIfDisposed(() -> this.instanceRefToJson(pathRef).thenApplyAsync(this::parseDiagnosticsPathHelper));
        }

        CompletableFuture<ArrayList<DiagnosticsPathNode>> parseDiagnosticsPathDaemon(CompletableFuture<JsonElement> jsonFuture) {
            return this.nullIfDisposed(() -> jsonFuture.thenApplyAsync(this::parseDiagnosticsPathHelper));
        }

        private ArrayList<DiagnosticsPathNode> parseDiagnosticsPathHelper(JsonElement jsonElement) {
            return this.nullValueIfDisposed(() -> {
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                ArrayList<DiagnosticsPathNode> pathNodes = new ArrayList<DiagnosticsPathNode>();
                for (JsonElement element : jsonArray) {
                    pathNodes.add(new DiagnosticsPathNode(element.getAsJsonObject(), this));
                }
                return pathNodes;
            });
        }

        public CompletableFuture<DiagnosticsNode> getSelection(DiagnosticsNode previousSelection, FlutterTreeType treeType, boolean localOnly) {
            assert (!this.disposed);
            return this.nullIfDisposed(() -> {
                CompletableFuture<DiagnosticsNode> result = null;
                InspectorInstanceRef previousSelectionRef = previousSelection != null ? previousSelection.getDartDiagnosticRef() : null;
                switch (treeType) {
                    case widget: {
                        result = this.invokeServiceMethodReturningNode(localOnly ? "getSelectedSummaryWidget" : "getSelectedWidget", previousSelectionRef);
                        break;
                    }
                    case renderObject: {
                        result = this.invokeServiceMethodReturningNode("getSelectedRenderObject", previousSelectionRef);
                    }
                }
                return result.thenApplyAsync(newSelection -> this.nullValueIfDisposed(() -> {
                    if (newSelection != null && newSelection.getDartDiagnosticRef().equals(previousSelectionRef)) {
                        return previousSelection;
                    }
                    return newSelection;
                }));
            });
        }

        public void setSelection(InspectorInstanceRef selection, boolean uiAlreadyUpdated, boolean textEditorUpdated) {
            if (this.disposed) {
                return;
            }
            if (selection == null || selection.getId() == null) {
                return;
            }
            if (InspectorService.this.useServiceExtensionApi()) {
                this.handleSetSelectionDaemon(this.invokeVmServiceExtension("setSelectionById", selection), uiAlreadyUpdated, textEditorUpdated);
            } else {
                this.handleSetSelectionVmService(this.invokeEval("setSelectionById", selection), uiAlreadyUpdated, textEditorUpdated);
            }
        }

        public void setSelection(Location location, boolean uiAlreadyUpdated, boolean textEditorUpdated) {
            if (this.disposed) {
                return;
            }
            if (location == null) {
                return;
            }
            if (InspectorService.this.useServiceExtensionApi()) {
                JsonObject params = new JsonObject();
                this.addLocationToParams(location, params);
                this.handleSetSelectionDaemon(this.invokeVmServiceExtension("setSelectionByLocation", params), uiAlreadyUpdated, textEditorUpdated);
            }
        }

        public void setSelection(InstanceRef selection, boolean uiAlreadyUpdated, boolean textEditorUpdated) {
            assert (!this.disposed);
            this.handleSetSelectionVmService(this.invokeServiceMethodOnRefEval("setSelection", selection), uiAlreadyUpdated, textEditorUpdated);
        }

        private void handleSetSelectionVmService(CompletableFuture<InstanceRef> setSelectionResult, boolean uiAlreadyUpdated, boolean textEditorUpdated) {
            this.skipIfDisposed(() -> setSelectionResult.thenAcceptAsync(instanceRef -> this.skipIfDisposed(() -> this.handleSetSelectionHelper("true".equals(instanceRef.getValueAsString()), uiAlreadyUpdated, textEditorUpdated))));
        }

        private void handleSetSelectionHelper(boolean selectionChanged, boolean uiAlreadyUpdated, boolean textEditorUpdated) {
            if (selectionChanged) {
                InspectorService.this.notifySelectionChanged(uiAlreadyUpdated, textEditorUpdated);
            }
        }

        private void handleSetSelectionDaemon(CompletableFuture<JsonElement> setSelectionResult, boolean uiAlreadyUpdated, boolean textEditorUpdated) {
            this.skipIfDisposed(() -> setSelectionResult.thenAcceptAsync(json -> this.skipIfDisposed(() -> this.handleSetSelectionHelper(json.getAsBoolean(), uiAlreadyUpdated, textEditorUpdated))));
        }

        public CompletableFuture<Map<String, InstanceRef>> getEnumPropertyValues(InspectorInstanceRef ref) {
            return this.nullIfDisposed(() -> {
                if (ref == null || ref.getId() == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return this.getInstance(this.toVmServiceInstanceRef(ref)).thenComposeAsync(instance -> this.nullIfDisposed(() -> InspectorService.this.getInspectorLibrary().getClass(instance.getClassRef(), this).thenApplyAsync(clazz -> this.nullValueIfDisposed(() -> {
                    LinkedHashMap<String, InstanceRef> properties = new LinkedHashMap<String, InstanceRef>();
                    for (FieldRef field : clazz.getFields()) {
                        String name = field.getName();
                        if (name.startsWith("_") || name.equals("values") || !field.isConst() || !field.isStatic()) continue;
                        properties.put(field.getName(), field.getDeclaredType());
                    }
                    return properties;
                }))));
            });
        }

        public CompletableFuture<DiagnosticsNode> getDetailsSubtree(DiagnosticsNode node) {
            if (node == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.nullIfDisposed(() -> this.invokeServiceMethodReturningNode("getDetailsSubtree", node.getDartDiagnosticRef()));
        }

        public XDebuggerEditorsProvider getEditorsProvider() {
            return InspectorService.this.getDebugProcess().getEditorsProvider();
        }

        FlutterApp getApp() {
            return InspectorService.this.getApp();
        }

        public <T> void safeWhenComplete(CompletableFuture<T> future, BiConsumer<? super T, ? super Throwable> action) {
            if (future == null) {
                return;
            }
            future.whenCompleteAsync((value, throwable) -> this.skipIfDisposed(() -> ApplicationManager.getApplication().invokeLater(() -> action.accept((Object)value, (Throwable)throwable))));
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }

    public static interface InspectorServiceClient {
        public void onInspectorSelectionChanged(boolean var1, boolean var2);

        public void onFlutterFrame();

        public CompletableFuture<?> onForceRefresh();
    }

    public static enum FlutterTreeType {
        widget("Widget"),
        renderObject("Render");

        public final String displayName;

        private FlutterTreeType(String displayName) {
            this.displayName = displayName;
        }
    }

    public static class InteractiveScreenshot {
        public final Screenshot screenshot;
        public final ArrayList<DiagnosticsNode> boxes;
        public final ArrayList<DiagnosticsNode> elements;

        InteractiveScreenshot(Screenshot screenshot, ArrayList<DiagnosticsNode> boxes, ArrayList<DiagnosticsNode> elements) {
            this.screenshot = screenshot;
            this.boxes = boxes;
            this.elements = elements;
        }
    }

    public static class Location {
        @NotNull
        private final VirtualFile file;
        private final int line;
        private final int column;
        private final int offset;

        public Location(@NotNull VirtualFile file, int line, int column, int offset) {
            if (file == null) {
                Location.$$$reportNull$$$0(0);
            }
            this.file = file;
            this.line = line;
            this.column = column;
            this.offset = offset;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public int getOffset() {
            return this.offset;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                Location.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        @NotNull
        public String getPath() {
            String string = InspectorService.toSourceLocationUri(this.file.getPath());
            if (string == null) {
                Location.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public XSourcePosition getXSourcePosition() {
            int line = this.getLine();
            int column = this.getColumn();
            if (line < 0 || column < 0) {
                return null;
            }
            return XSourcePositionImpl.create((VirtualFile)this.file, (int)(line - 1), (int)(column - 1));
        }

        public static Location outlineToLocation(Project project, VirtualFile file, FlutterOutline outline, Document document) {
            PsiFile psiFile;
            if (file == null) {
                return null;
            }
            if (document == null) {
                return null;
            }
            if (outline == null || outline.getClassName() == null) {
                return null;
            }
            int documentLength = document.getTextLength();
            int nodeOffset = Math.max(0, Math.min(outline.getCodeOffset(), documentLength));
            int nodeEndOffset = Math.max(0, Math.min(outline.getCodeOffset() + outline.getCodeLength(), documentLength));
            if (outline.getClassName() != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) != null) {
                DartExpression expression;
                PsiElement element = psiFile.findElementAt(nodeOffset);
                DartCallExpression callExpression = (DartCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, DartCallExpression.class);
                Object match = null;
                if (callExpression != null && (expression = callExpression.getExpression()) instanceof DartReferenceExpression) {
                    DartReferenceExpression referenceExpression = (DartReferenceExpression)expression;
                    PsiElement[] children = referenceExpression.getChildren();
                    match = children.length > 1 ? children[children.length - 1] : referenceExpression;
                }
                if (match != null) {
                    nodeOffset = match.getTextOffset();
                }
            }
            int line = document.getLineNumber(nodeOffset);
            int lineStartOffset = document.getLineStartOffset(line);
            int column = nodeOffset - lineStartOffset;
            return new Location(file, line + 1, column + 1, nodeOffset);
        }

        @Nullable
        public static Location outlineToLocation(Editor editor, FlutterOutline outline) {
            if (!(editor instanceof EditorEx)) {
                return null;
            }
            EditorEx editorEx = (EditorEx)editor;
            return Location.outlineToLocation(editor.getProject(), editorEx.getVirtualFile(), outline, editor.getDocument());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/inspector/InspectorService$Location";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/inspector/InspectorService$Location";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

