/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.google.gson.JsonObject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import io.flutter.inspector.InspectorService;
import io.flutter.utils.JsonUtils;

public class InspectorSourceLocation {
    private final JsonObject json;
    private final InspectorSourceLocation parent;
    private final Project project;

    public InspectorSourceLocation(JsonObject json, InspectorSourceLocation parent, Project project) {
        this.json = json;
        this.parent = parent;
        this.project = project;
    }

    public String getFile() {
        return JsonUtils.getStringMember(this.json, "file");
    }

    public VirtualFile getVirtualFile() {
        String fileName = this.getFile();
        if (fileName == null) {
            return this.parent != null ? this.parent.getVirtualFile() : null;
        }
        fileName = InspectorService.fromSourceLocationUri(fileName, this.project);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
        if (virtualFile != null && !virtualFile.exists()) {
            return null;
        }
        return virtualFile;
    }

    public int getLine() {
        return JsonUtils.getIntMember(this.json, "line");
    }

    public String getName() {
        return JsonUtils.getStringMember(this.json, "name");
    }

    public int getColumn() {
        return JsonUtils.getIntMember(this.json, "column");
    }

    public XSourcePosition getXSourcePosition() {
        VirtualFile file = this.getVirtualFile();
        if (file == null) {
            return null;
        }
        int line = this.getLine();
        int column = this.getColumn();
        if (line < 0 || column < 0) {
            return null;
        }
        return XSourcePositionImpl.create((VirtualFile)file, (int)(line - 1), (int)(column - 1));
    }

    public InspectorService.Location getLocation() {
        return new InspectorService.Location(this.getVirtualFile(), this.getLine(), this.getColumn(), this.getXSourcePosition().getOffset());
    }
}

