/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import io.flutter.inspector.TreeScrollAnimator;
import io.flutter.view.InspectorTreeUI;
import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectorTree
extends Tree
implements DataProvider {
    public final boolean detailsSubtree;
    private DefaultMutableTreeNode highlightedRoot;
    private TreeScrollAnimator scrollAnimator;
    public static final DataKey<Tree> INSPECTOR_KEY = DataKey.create((String)"Flutter.InspectorKey");
    private static final JBColor VERY_LIGHT_GREY = new JBColor((Color)Gray._220, (Color)Gray._65);

    public DefaultMutableTreeNode getHighlightedRoot() {
        return this.highlightedRoot;
    }

    public void setHighlightedRoot(DefaultMutableTreeNode value) {
        if (this.highlightedRoot == value) {
            return;
        }
        this.highlightedRoot = value;
        this.repaint();
    }

    protected boolean isWideSelection() {
        return false;
    }

    public void scrollRectToVisible(Rectangle rect) {
        this.scrollAnimator.animateTo(rect);
    }

    public void immediateScrollRectToVisible(Rectangle rect) {
        super.scrollRectToVisible(rect);
    }

    public void setUI(TreeUI ui) {
        InspectorTreeUI inspectorTreeUI = ui instanceof InspectorTreeUI ? (InspectorTreeUI)ui : new InspectorTreeUI();
        super.setUI((TreeUI)inspectorTreeUI);
        inspectorTreeUI.setRightChildIndent(JBUI.scale((int)4));
    }

    public InspectorTree(DefaultMutableTreeNode treemodel, String treeName, boolean detailsSubtree, String parentTreeName, boolean rootVisible, boolean legacyMode, Disposable parentDisposable) {
        super((TreeNode)treemodel);
        this.setUI(new InspectorTreeUI());
        BasicTreeUI ui = (BasicTreeUI)this.getUI();
        this.detailsSubtree = detailsSubtree;
        this.setRootVisible(rootVisible);
        this.getSelectionModel().setSelectionMode(1);
        this.registerShortcuts(parentDisposable);
        if (detailsSubtree) {
            this.getEmptyText().setText(treeName + " subtree of the selected " + parentTreeName);
        } else {
            this.getEmptyText().setText(treeName + " tree for the running app");
        }
    }

    void registerShortcuts(Disposable parentDisposable) {
        DebuggerUIUtil.registerActionOnComponent((String)"Flutter.JumpToTypeSource", (JComponent)((Object)this), (Disposable)parentDisposable);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        XValueNodeImpl[] selectedNodes;
        if (dataId == null) {
            InspectorTree.$$$reportNull$$$0(0);
        }
        if (INSPECTOR_KEY.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId) && (selectedNodes = (XValueNodeImpl[])this.getSelectedNodes(XValueNodeImpl.class, null)).length == 1 && selectedNodes[0].getFullValueEvaluator() == null) {
            return DebuggerUIUtil.getNodeRawValue((XValueNodeImpl)selectedNodes[0]);
        }
        return null;
    }

    public void setScrollAnimator(TreeScrollAnimator scrollAnimator) {
        this.scrollAnimator = scrollAnimator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "io/flutter/inspector/InspectorTree", "getData"));
    }
}

