/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.intellij.openapi.Disposable;
import com.intellij.ui.components.JBScrollBar;
import gnu.trove.THashSet;
import io.flutter.inspector.InspectorTree;
import io.flutter.utils.animation.Curve;
import io.flutter.utils.animation.Curves;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;

public class TreeScrollAnimator
implements Disposable {
    private final InspectorTree tree;
    private final JScrollPane scrollPane;
    private final Timer timer;
    private final Timer scrollIdleTimer;
    private Set<TreePath> targets;
    private long animationStartTime;
    private final LockableScrollbar[] scrollbars = new LockableScrollbar[]{new LockableScrollbar(0), new LockableScrollbar(1)};
    private long lastScrollTime;
    private int activeScrollbar = 2;
    double animationDuration;
    static final double TARGET_LEFT_INDENT = 25.0;
    static final int MS_DELAY_BEFORE_CHANGING_SCROLL_AXIS = 150;
    static final int DEFAULT_ANIMATION_DURATION = 150;
    static final int DEFAULT_ANIMATE_X_DURATION = 80;
    private Point animationStart;
    private Point animationEnd;
    private Curve animationCurve;
    private boolean scrollTriggeredAnimator = false;
    private Point scrollPosition;
    private boolean autoHorizontalScroll;

    public TreeScrollAnimator(InspectorTree tree, JScrollPane scrollPane) {
        this.tree = tree;
        this.scrollPane = scrollPane;
        this.timer = new Timer(16, this::onFrame);
        this.scrollIdleTimer = new Timer(150, this::onScrollIdle);
        scrollPane.setHorizontalScrollBar((JScrollBar)((Object)this.scrollbars[0]));
        scrollPane.setVerticalScrollBar((JScrollBar)((Object)this.scrollbars[1]));
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setAutoscrolls(false);
        tree.setScrollsOnExpand(false);
        scrollPane.getVerticalScrollBar().getModel().addChangeListener(this::verticalScrollChanged);
        scrollPane.getHorizontalScrollBar().getModel().addChangeListener(this::horizontalScrollChanged);
        this.scrollPosition = scrollPane.getViewport().getViewPosition();
        this.computeScrollPosition();
    }

    public void setAutoHorizontalScroll(boolean autoHorizontalScroll) {
        this.autoHorizontalScroll = autoHorizontalScroll;
        if (autoHorizontalScroll) {
            this.applyAutoHorizontalScroll();
        } else if (!this.timer.isRunning()) {
            this.setActiveScrollbar(2);
        }
    }

    private void computeScrollPosition() {
        this.scrollPosition = new Point(this.scrollbars[0].getModel().getValue(), this.scrollbars[1].getModel().getValue());
    }

    private void handleScrollChanged() {
        int orientation;
        Point last = this.scrollPosition;
        this.computeScrollPosition();
        if (!this.autoHorizontalScroll) {
            return;
        }
        int dx = this.scrollPosition.x - last.x;
        int dy = this.scrollPosition.y - last.y;
        if (dx == 0 && dy == 0) {
            return;
        }
        if (this.scrollTriggeredAnimator || this.timer.isRunning()) {
            return;
        }
        int n = orientation = Math.abs(dy) >= Math.abs(dx) ? 1 : 0;
        if (this.activeScrollbar != 2 && this.activeScrollbar != orientation) {
            return;
        }
        this.lastScrollTime = System.currentTimeMillis();
        this.setActiveScrollbar(orientation);
        this.scrollIdleTimer.restart();
    }

    private void setActiveScrollbar(int orientation) {
        block4: {
            if (this.activeScrollbar == orientation) break block4;
            this.activeScrollbar = orientation;
            if (orientation == 128) {
                for (int axis = 0; axis <= 1; ++axis) {
                    this.scrollbars[axis].setAllowScroll(false);
                }
            } else {
                for (int axis = 0; axis <= 1; ++axis) {
                    int otherAxis = 1 - axis;
                    this.scrollbars[axis].setAllowScroll(orientation != otherAxis);
                }
            }
        }
    }

    private void horizontalScrollChanged(ChangeEvent e) {
        this.handleScrollChanged();
    }

    private void verticalScrollChanged(ChangeEvent e) {
        this.handleScrollChanged();
        if (this.targets != null || this.scrollTriggeredAnimator) {
            return;
        }
        if (this.autoHorizontalScroll) {
            this.applyAutoHorizontalScroll();
        }
    }

    private void applyAutoHorizontalScroll() {
        this.animateToX(this.calculateTargetX(this.scrollPosition, null));
    }

    private int calculateTargetX(Point candidate, TreePath selectionPath) {
        int[] rows;
        int rowStart = this.tree.getClosestRowForLocation(candidate.x, candidate.y);
        int rowEnd = this.tree.getClosestRowForLocation(candidate.x, candidate.y + this.scrollPane.getHeight() - 1);
        Rectangle union = null;
        int selectedRow = -1;
        selectedRow = selectionPath != null ? this.tree.getRowForPath(selectionPath) : ((rows = this.tree.getSelectionRows()) != null && rows.length > 0 ? rows[0] : selectedRow);
        Rectangle selectedBounds = null;
        for (int i = rowStart; i <= rowEnd; ++i) {
            Rectangle bounds = this.tree.getRowBounds(i);
            if (i == selectedRow) {
                selectedBounds = bounds;
            }
            union = union == null ? bounds : union.union(bounds);
        }
        if (union == null) {
            return 0;
        }
        int targetX = Math.max(union.x - 25, 0);
        if (selectedBounds != null) {
            int selectionWidth = Math.min(this.scrollPane.getViewport().getWidth() / 2, 100);
            Interval xAxis = TreeScrollAnimator.clampInterval(new Interval(selectedBounds.x, selectionWidth), new Interval(targetX, selectedBounds.x + selectionWidth - targetX), this.scrollPane.getViewport().getWidth());
            targetX = xAxis.start;
        }
        return targetX;
    }

    private void animateToX(int x) {
        this.targets = null;
        this.computeScrollPosition();
        this.animationStart = this.scrollPosition;
        this.setActiveScrollbar(1);
        this.animationEnd = new Point(x, this.animationStart.y);
        long currentTime = System.currentTimeMillis();
        if (!this.timer.isRunning()) {
            this.animationCurve = Curves.LINEAR;
            this.animationDuration = 80.0;
        } else {
            this.animationDuration = Math.max(40.0, this.animationDuration - (double)(currentTime - this.animationStartTime));
            this.animationCurve = Curves.LINEAR;
        }
        this.animationStartTime = currentTime;
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    static Interval clampInterval(Interval required, Interval ideal, int clampLength) {
        if (required.start < ideal.start || required.start + required.length > ideal.start + ideal.length || required.length < 0 || ideal.length < 0 || clampLength < 0) {
            throw new IllegalArgumentException();
        }
        if (ideal.length <= clampLength) {
            return ideal;
        }
        double extraSpace = clampLength - required.length;
        if (extraSpace <= 0.0) {
            return new Interval(required.start, clampLength);
        }
        double desiredSpace = ideal.length - required.length;
        return new Interval(Curves.LINEAR.interpolate(required.start, ideal.start, extraSpace / desiredSpace), clampLength);
    }

    public void animateTo(Rectangle rect) {
        int selectedRow;
        int firstRow = this.tree.getClosestRowForLocation(rect.x, rect.y);
        int lastRow = this.tree.getClosestRowForLocation(rect.x, rect.y + rect.height);
        ArrayList<TreePath> targets = new ArrayList<TreePath>();
        int[] selectionRows = this.tree.getSelectionRows();
        int n = selectedRow = selectionRows != null && selectionRows.length > 0 ? selectionRows[0] : -1;
        if (selectedRow > firstRow && selectedRow <= lastRow) {
            targets.add(this.tree.getPathForRow(selectedRow));
        }
        for (int row = firstRow; row <= lastRow; ++row) {
            if (row == selectedRow) continue;
            targets.add(this.tree.getPathForRow(row));
        }
        this.animateTo(targets);
    }

    public void animateTo(List<TreePath> targets) {
        if (targets == null || targets.isEmpty()) {
            return;
        }
        Rectangle bounds = this.tree.getPathBounds(targets.get(0));
        if (bounds == null) {
            return;
        }
        Rectangle primaryBounds = bounds;
        boolean newTarget = true;
        if (this.targets != null) {
            for (TreePath target : targets) {
                if (!this.targets.contains(target)) continue;
                newTarget = false;
                break;
            }
        }
        this.animationStart = this.scrollPane.getViewport().getViewPosition();
        double minX = Math.max(0.0, bounds.getMinX() - Math.min((double)this.scrollPane.getWidth() * 0.5, 25.0));
        double maxX = bounds.getMaxX();
        double y = bounds.getMinY();
        double height = bounds.getHeight();
        bounds.setRect(minX, y, maxX - minX, height);
        for (int i = 1; i < targets.size(); ++i) {
            Rectangle secoundaryBounds = this.tree.getPathBounds(targets.get(i));
            if (secoundaryBounds == null) continue;
            bounds = bounds.union(secoundaryBounds);
        }
        Interval xAxis = TreeScrollAnimator.clampInterval(new Interval(primaryBounds.x, primaryBounds.width), new Interval(bounds.x, bounds.width), this.scrollPane.getViewport().getWidth());
        Interval yAxis = TreeScrollAnimator.clampInterval(new Interval(primaryBounds.y, primaryBounds.height), new Interval(bounds.y, bounds.height), this.scrollPane.getViewport().getHeight());
        bounds.setBounds(xAxis.start, yAxis.start, xAxis.length, yAxis.length);
        this.scrollTriggeredAnimator = true;
        if (this.timer.isRunning()) {
            this.scrollPane.getViewport().setViewPosition(this.animationEnd);
        }
        this.tree.immediateScrollRectToVisible(bounds);
        this.animationEnd = this.scrollPane.getViewport().getViewPosition();
        if (this.autoHorizontalScroll) {
            int targetX = this.calculateTargetX(this.animationEnd, targets.get(0));
            this.animationEnd = new Point(targetX, this.animationEnd.y);
        }
        this.scrollPane.getViewport().setViewPosition(this.animationStart);
        this.scrollTriggeredAnimator = false;
        if (this.animationStart.y == this.animationEnd.y && this.animationStart.x == this.animationEnd.x) {
            return;
        }
        this.targets = new THashSet(targets);
        long currentTime = System.currentTimeMillis();
        if (newTarget) {
            this.animationCurve = Curves.EASE_IN_OUT;
            this.animationDuration = 150.0;
        } else {
            this.animationDuration = Math.max(75.0, this.animationDuration - (double)(currentTime - this.animationStartTime));
            this.animationCurve = Curves.EASE_OUT;
        }
        this.animationStartTime = currentTime;
        this.setActiveScrollbar(128);
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    private void setScrollPosition(int x, int y) {
        this.scrollPosition = new Point(x, y);
        this.scrollTriggeredAnimator = true;
        this.scrollPane.getViewport().setViewPosition(this.scrollPosition);
        this.scrollTriggeredAnimator = false;
    }

    private void onFrame(ActionEvent e) {
        long now = System.currentTimeMillis();
        long delta = now - this.animationStartTime;
        double fraction = Math.min((double)delta / this.animationDuration, 1.0);
        boolean animateX = this.animationStart.x != this.animationEnd.x;
        boolean animateY = this.animationStart.y != this.animationEnd.y;
        Point current = this.scrollPane.getViewport().getViewPosition();
        int x = animateX ? this.animationCurve.interpolate(this.animationStart.x, this.animationEnd.x, fraction) : current.x;
        int y = animateY ? this.animationCurve.interpolate(this.animationStart.y, this.animationEnd.y, fraction) : current.y;
        this.setScrollPosition(x, y);
        if (fraction >= 1.0) {
            this.targets = null;
            this.setActiveScrollbar(2);
            this.timer.stop();
        }
    }

    private void onScrollIdle(ActionEvent e) {
        if (this.activeScrollbar != 128 && !this.timer.isRunning()) {
            this.setActiveScrollbar(2);
        }
    }

    public void dispose() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        if (this.scrollIdleTimer.isRunning()) {
            this.scrollIdleTimer.stop();
        }
    }

    private static class LockableScrollbar
    extends JBScrollBar {
        boolean allowScroll = true;

        LockableScrollbar(int orientation) {
            super(orientation);
        }

        void setAllowScroll(boolean value) {
            this.allowScroll = value;
        }

        public boolean isVisible() {
            return this.allowScroll && super.isVisible();
        }
    }

    public static class Interval {
        final int start;
        final int length;

        Interval(int start, int length) {
            this.start = start;
            this.length = length;
        }

        public String toString() {
            return "Interval(" + this.start + ", " + this.length + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof Interval)) {
                return false;
            }
            Interval interval = (Interval)o;
            return interval.start == this.start && interval.length == this.length;
        }
    }
}

