/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.google.common.collect.ArrayListMultimap;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import io.flutter.FlutterInitializer;
import io.flutter.inspector.InspectorService;
import io.flutter.perf.FlutterWidgetPerf;
import io.flutter.perf.FlutterWidgetPerfManager;
import io.flutter.perf.Location;
import io.flutter.perf.PerfTip;
import io.flutter.perf.PerfTipRule;
import io.flutter.perf.WidgetPerfLinter;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.AsyncUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class WidgetPerfTipsPanel
extends JPanel {
    static final int PERF_TIP_COMPUTE_DELAY = 1000;
    private final FlutterWidgetPerfManager perfManager;
    private long lastUpdateTime;
    private final JPanel perfTips;
    private TextEditor currentEditor;
    private ArrayList<TextEditor> currentTextEditors;
    final LinkListener<PerfTip> linkListener;
    private final List<PerfTip> currentTips;
    ArrayListMultimap<TextEditor, PerfTip> tipsPerFile;

    public WidgetPerfTipsPanel(Disposable parentDisposable, @NotNull FlutterApp app) {
        if (app == null) {
            WidgetPerfTipsPanel.$$$reportNull$$$0(0);
        }
        this.currentTips = new ArrayList<PerfTip>();
        this.setLayout((LayoutManager)new VerticalLayout(5));
        this.add(new JSeparator());
        this.perfManager = FlutterWidgetPerfManager.getInstance(app.getProject());
        this.perfTips = new JPanel();
        this.perfTips.setLayout((LayoutManager)new VerticalLayout(0));
        this.linkListener = (source, tip) -> WidgetPerfTipsPanel.handleTipSelection(tip);
        Project project = app.getProject();
        MessageBusConnection bus = project.getMessageBus().connect((Disposable)project);
        FileEditorManagerListener listener = new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                WidgetPerfTipsPanel.this.selectedEditorChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/inspector/WidgetPerfTipsPanel$1", "selectionChanged"));
            }
        };
        this.selectedEditorChanged();
        bus.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener);
        Timer perfTipComputeDelayTimer = new Timer(1000, this::onComputePerfTips);
        perfTipComputeDelayTimer.start();
        Disposer.register((Disposable)parentDisposable, perfTipComputeDelayTimer::stop);
    }

    private static void handleTipSelection(@NotNull PerfTip tip) {
        if (tip == null) {
            WidgetPerfTipsPanel.$$$reportNull$$$0(1);
        }
        FlutterInitializer.getAnalytics().sendEvent("perf", "perfTipSelected." + tip.getRule().getId());
        BrowserLauncher.getInstance().browse(tip.getUrl(), null);
    }

    private void onComputePerfTips(ActionEvent event) {
        long latestPerfUpdate;
        FlutterWidgetPerf stats = this.perfManager.getCurrentStats();
        if (stats != null && (latestPerfUpdate = stats.getLastLocalPerfEventTime()) != this.lastUpdateTime) {
            this.lastUpdateTime = latestPerfUpdate;
            this.updateTip();
        }
    }

    public void clearTips() {
        this.currentTips.clear();
        this.remove(this.perfTips);
        this.setVisible(this.hasPerfTips());
    }

    private void selectedEditorChanged() {
        this.lastUpdateTime = -1L;
        this.updateTip();
    }

    private void updateTip() {
        if (this.perfManager.getCurrentStats() == null) {
            return;
        }
        HashSet<TextEditor> selectedEditors = new HashSet<TextEditor>(this.perfManager.getSelectedEditors());
        if (selectedEditors.isEmpty()) {
            this.clearTips();
            return;
        }
        WidgetPerfLinter linter = this.perfManager.getCurrentStats().getPerfLinter();
        AsyncUtils.whenCompleteUiThread(linter.getTipsFor(selectedEditors), (tips, throwable) -> {
            if (tips == null || tips.isEmpty() || throwable != null) {
                this.clearTips();
                return;
            }
            HashMap<String, TextEditor> forPath = new HashMap<String, TextEditor>();
            for (TextEditor editor : selectedEditors) {
                VirtualFile file = editor.getFile();
                if (file == null) continue;
                forPath.put(InspectorService.toSourceLocationUri(file.getPath()), editor);
            }
            ArrayListMultimap newTipsForFile = ArrayListMultimap.create();
            for (PerfTip tip : tips) {
                for (Location location : tip.getLocations()) {
                    if (!forPath.containsKey(location.path)) continue;
                    newTipsForFile.put((Object)((TextEditor)forPath.get(location.path)), (Object)tip);
                }
            }
            this.tipsPerFile = newTipsForFile;
            if (!PerfTipRule.equivalentPerfTips(this.currentTips, tips)) {
                this.showPerfTips((ArrayList<PerfTip>)tips);
            }
        });
    }

    private void showPerfTips(@NotNull ArrayList<PerfTip> tips) {
        if (tips == null) {
            WidgetPerfTipsPanel.$$$reportNull$$$0(2);
        }
        this.perfTips.removeAll();
        this.currentTips.clear();
        this.currentTips.addAll(tips);
        for (PerfTip tip : tips) {
            LinkLabel label = new LinkLabel("<html><body><a>" + tip.getMessage() + "</a><body></html>", tip.getRule().getIcon(), this.linkListener, (Object)tip);
            label.setPaintUnderline(false);
            label.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)5, (int)5));
            this.perfTips.add((Component)label);
        }
        this.add(this.perfTips);
        this.setVisible(this.hasPerfTips());
    }

    private boolean hasPerfTips() {
        return !this.currentTips.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tip";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tips";
                break;
            }
        }
        objectArray2[1] = "io/flutter/inspector/WidgetPerfTipsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleTipSelection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showPerfTips";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

