/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.QueueProcessor;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterUtils;
import io.flutter.devtools.DevToolsUtils;
import io.flutter.inspector.DiagnosticLevel;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.DiagnosticsTreeStyle;
import io.flutter.inspector.InspectorService;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.sdk.FlutterSdk;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.JsonUtils;
import io.flutter.view.EmbeddedBrowser;
import io.flutter.vmService.VmServiceConsumers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.GetObjectConsumer;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.ExtensionData;
import org.dartlang.vm.service.element.Instance;
import org.dartlang.vm.service.element.InstanceKind;
import org.dartlang.vm.service.element.InstanceRef;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.LogRecord;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterConsoleLogManager {
    private static final Logger LOG = Logger.getInstance(FlutterConsoleLogManager.class);
    private static final String consolePreferencesSetKey = "io.flutter.console.preferencesSet";
    private static final String DEEP_LINK_GROUP_ID = "deeplink";
    private static final ConsoleViewContentType TITLE_CONTENT_TYPE = new ConsoleViewContentType("title", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES.toTextAttributes());
    private static final ConsoleViewContentType NORMAL_CONTENT_TYPE = ConsoleViewContentType.NORMAL_OUTPUT;
    private static final ConsoleViewContentType SUBTLE_CONTENT_TYPE = new ConsoleViewContentType("subtle", SimpleTextAttributes.GRAY_ATTRIBUTES.toTextAttributes());
    private static final ConsoleViewContentType ERROR_CONTENT_TYPE = ConsoleViewContentType.ERROR_OUTPUT;
    private static QueueProcessor<Runnable> queue;
    private static final AtomicInteger queueLength;
    @NotNull
    final ConsoleView console;
    @NotNull
    final FlutterApp app;
    private int frameErrorCount;
    private CompletableFuture<InspectorService.ObjectGroup> objectGroup;
    private static final int errorSeparatorLength = 100;
    private static final String errorSeparatorChar = "=";
    private static final ArrayList<DiagnosticsNode> emptyList;

    public static void initConsolePreferences() {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (!properties.getBoolean(consolePreferencesSetKey)) {
            properties.setValue(consolePreferencesSetKey, true);
            EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
            editorSettings.setUseSoftWraps(true, SoftWrapAppliancePlaces.CONSOLE);
        }
    }

    public FlutterConsoleLogManager(@NotNull ConsoleView console, @NotNull FlutterApp app) {
        if (console == null) {
            FlutterConsoleLogManager.$$$reportNull$$$0(0);
        }
        if (app == null) {
            FlutterConsoleLogManager.$$$reportNull$$$0(1);
        }
        this.frameErrorCount = 0;
        this.console = console;
        this.app = app;
        app.addStateListener(new FlutterApp.FlutterAppListener(){

            @Override
            public void notifyFrameRendered() {
                FlutterConsoleLogManager.this.frameErrorCount = 0;
            }

            @Override
            public void stateChanged(FlutterApp.State newState) {
                FlutterConsoleLogManager.this.frameErrorCount = 0;
            }

            @Override
            public void notifyAppReloaded() {
                FlutterConsoleLogManager.this.frameErrorCount = 0;
            }

            @Override
            public void notifyAppRestarted() {
                FlutterConsoleLogManager.this.frameErrorCount = 0;
            }
        });
        if (queue == null) {
            queue = QueueProcessor.createRunnableQueueProcessor();
        }
    }

    @Nullable
    private CompletableFuture<InspectorService.ObjectGroup> getCreateInspectorGroup() {
        if (this.objectGroup == null) {
            if (this.app.getFlutterDebugProcess() == null || this.app.getVmService() == null) {
                return null;
            }
            this.objectGroup = InspectorService.createGroup(this.app, this.app.getFlutterDebugProcess(), this.app.getVmService(), "console-group");
            this.objectGroup.whenCompleteAsync((group, error) -> {
                if (group != null) {
                    Disposer.register((Disposable)this.app, (Disposable)group.getInspectorService());
                }
            });
        }
        return this.objectGroup;
    }

    public void handleFlutterErrorEvent(@NotNull Event event) {
        CompletableFuture<InspectorService.ObjectGroup> objectGroup;
        if (event == null) {
            FlutterConsoleLogManager.$$$reportNull$$$0(2);
        }
        if ((objectGroup = this.getCreateInspectorGroup()) == null) {
            return;
        }
        try {
            ExtensionData extensionData = event.getExtensionData();
            JsonObject jsonObject = extensionData.getJson().getAsJsonObject();
            DiagnosticsNode diagnosticsNode = new DiagnosticsNode(jsonObject, objectGroup, this.app, false, null);
            if (FlutterSettings.getInstance().isShowStructuredErrors()) {
                queueLength.incrementAndGet();
                queue.add(() -> {
                    try {
                        this.processFlutterErrorEvent(diagnosticsNode);
                    }
                    catch (Throwable t) {
                        LOG.warn(t);
                    }
                    finally {
                        queueLength.decrementAndGet();
                        AtomicInteger atomicInteger = queueLength;
                        synchronized (atomicInteger) {
                            queueLength.notifyAll();
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flushFlutterErrorQueue() {
        if (queueLength.get() <= 0) return;
        try {
            while (queueLength.get() > 0) {
                AtomicInteger atomicInteger = queueLength;
                synchronized (atomicInteger) {
                    queueLength.wait();
                }
            }
            return;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void processFlutterErrorEvent(@NotNull DiagnosticsNode diagnosticsNode) {
        if (diagnosticsNode == null) {
            FlutterConsoleLogManager.$$$reportNull$$$0(3);
        }
        String description = " " + String.valueOf(diagnosticsNode) + " ";
        boolean terseError = !this.isFirstErrorForFrame() && !FlutterSettings.getInstance().isIncludeAllStackTraces();
        ++this.frameErrorCount;
        String prefix = "========";
        String suffix = "==";
        this.console.print("\n========", TITLE_CONTENT_TYPE);
        this.console.print(description, NORMAL_CONTENT_TYPE);
        this.console.print(StringUtil.repeat((String)errorSeparatorChar, (int)Math.max(100 - "========".length() - description.length() - "==".length(), 0)), TITLE_CONTENT_TYPE);
        this.console.print("==\n", TITLE_CONTENT_TYPE);
        if (terseError) {
            for (DiagnosticsNode property : diagnosticsNode.getInlineProperties()) {
                this.printTerseNodeProperty(this.console, "", property);
            }
        } else {
            DiagnosticLevel lastLevel = null;
            String errorSummary = null;
            for (DiagnosticsNode property : diagnosticsNode.getInlineProperties()) {
                if (lastLevel != property.getLevel() && (lastLevel == DiagnosticLevel.hint || property.getLevel() == DiagnosticLevel.hint)) {
                    this.console.print("\n", NORMAL_CONTENT_TYPE);
                }
                lastLevel = property.getLevel();
                if (StringUtil.equals((CharSequence)"ErrorSummary", (CharSequence)property.getType())) {
                    errorSummary = property.getDescription();
                } else if (StringUtil.equals((CharSequence)"DevToolsDeepLinkProperty", (CharSequence)property.getType())) {
                    this.showDeepLinkNotification(property, errorSummary);
                    continue;
                }
                this.printDiagnosticsNodeProperty(this.console, "", property, null, false);
            }
        }
        this.console.print(StringUtil.repeat((String)errorSeparatorChar, (int)100) + "\n", TITLE_CONTENT_TYPE);
    }

    private boolean isFirstErrorForFrame() {
        return this.frameErrorCount == 0;
    }

    private void printTerseNodeProperty(ConsoleView console, String indent, DiagnosticsNode property) {
        CompletableFuture<ArrayList<DiagnosticsNode>> future;
        ArrayList<DiagnosticsNode> children;
        boolean skip = true;
        if (property.getLevel() == DiagnosticLevel.summary) {
            skip = false;
        } else if (property.hasChildren() && (children = (future = property.getChildren()).getNow(emptyList)).stream().noneMatch(DiagnosticsNode::hasChildren)) {
            skip = false;
        }
        if (skip) {
            return;
        }
        ConsoleViewContentType contentType = this.getContentTypeFor(property.getLevel());
        console.print(indent, contentType);
        if (property.getShowName()) {
            console.print(property.getName(), contentType);
            if (property.getShowSeparator()) {
                console.print(property.getSeparator() + " ", contentType);
            }
        }
        String description = property.getDescription() == null ? "" : property.getDescription();
        console.print(description + "\n", contentType);
        String childIndent = this.getChildIndent(indent, property);
        if (property.hasInlineProperties()) {
            for (DiagnosticsNode childProperty : property.getInlineProperties()) {
                this.printDiagnosticsNodeProperty(console, childIndent, childProperty, contentType, false);
            }
        }
        if (property.hasChildren()) {
            CompletableFuture<ArrayList<DiagnosticsNode>> future2 = property.getChildren();
            ArrayList<DiagnosticsNode> children2 = future2.getNow(emptyList);
            for (DiagnosticsNode child : children2) {
                this.printDiagnosticsNodeProperty(console, childIndent, child, contentType, false);
            }
        }
    }

    private void printDiagnosticsNodeProperty(ConsoleView console, String indent, DiagnosticsNode property, ConsoleViewContentType contentType, boolean isInChild) {
        if (property.getDescription() != null && property.getLevel() == DiagnosticLevel.info && StringUtil.equals((CharSequence)"ErrorSpacer", (CharSequence)property.getType())) {
            return;
        }
        if (contentType == null) {
            contentType = this.getContentTypeFor(property.getLevel());
        }
        console.print(indent, contentType);
        if (property.getShowName()) {
            String name = property.getName();
            console.print(name == null ? "" : name, contentType);
            if (property.getShowSeparator()) {
                console.print(property.getSeparator() + " ", contentType);
            }
        }
        String description = property.getDescription() == null ? "" : property.getDescription();
        console.print(description + "\n", contentType);
        if (property.hasInlineProperties()) {
            Object childIndent = this.getChildIndent(indent, property);
            if (property.getStyle() == DiagnosticsTreeStyle.shallow && !indent.startsWith("...")) {
                childIndent = "...  " + indent;
            }
            for (DiagnosticsNode childProperty : property.getInlineProperties()) {
                this.printDiagnosticsNodeProperty(console, (String)childIndent, childProperty, contentType, isInChild);
            }
        }
        if (property.hasChildren()) {
            CompletableFuture<ArrayList<DiagnosticsNode>> future = property.getChildren();
            ArrayList<DiagnosticsNode> children = future.getNow(emptyList);
            if (!isInChild && children.stream().noneMatch(DiagnosticsNode::hasChildren)) {
                childIndent = this.getChildIndent(indent, property);
                for (DiagnosticsNode child : children) {
                    this.printDiagnosticsNodeProperty(console, (String)childIndent, child, contentType, false);
                }
            } else if (property.getStyle() != DiagnosticsTreeStyle.shallow) {
                childIndent = isInChild ? this.getChildIndent(indent, property) : "...  " + indent;
                for (DiagnosticsNode child : children) {
                    this.printDiagnosticsNodeProperty(console, (String)childIndent, child, contentType, true);
                }
            }
        }
        if (property.getLevel() == DiagnosticLevel.summary) {
            console.print("\n", contentType);
        }
    }

    private void showDeepLinkNotification(final DiagnosticsNode property, final @NotNull String errorSummary) {
        if (errorSummary == null) {
            FlutterConsoleLogManager.$$$reportNull$$$0(4);
        }
        NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup(DEEP_LINK_GROUP_ID);
        assert (group != null);
        final Notification notification = group.createNotification(errorSummary, NotificationType.INFORMATION);
        notification.setIcon(AllIcons.General.BalloonWarning);
        notification.addAction(new AnAction("Inspect Widget"){

            public void actionPerformed(@NotNull AnActionEvent event) {
                EmbeddedBrowser browser;
                ToolWindowManager toolWindowManager;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!((toolWindowManager = ToolWindowManager.getInstance((Project)FlutterConsoleLogManager.this.app.getProject())) instanceof ToolWindowManagerEx)) {
                    return;
                }
                ToolWindow toolWindow = toolWindowManager.getToolWindow("Flutter Inspector");
                if (toolWindow != null && !toolWindow.isVisible()) {
                    toolWindow.show();
                }
                String widgetId = DevToolsUtils.findWidgetId(property.getValue());
                Project project = FlutterConsoleLogManager.this.app.getProject();
                if (!project.isDisposed() && (browser = FlutterUtils.embeddedBrowser(project)) != null) {
                    browser.updatePanelToWidget(widgetId);
                }
                notification.expire();
                FlutterInitializer.getAnalytics().sendEvent("deep-link-clicked", errorSummary.contains("RenderFlex overflowed") ? "overflow" : "unknown", FlutterSdk.getFlutterSdk(FlutterConsoleLogManager.this.app.getProject()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/logging/FlutterConsoleLogManager$2", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)notification, (Project)this.app.getProject());
        Executors.newSingleThreadScheduledExecutor().schedule(() -> ((Notification)notification).expire(), 25L, TimeUnit.SECONDS);
    }

    private String getChildIndent(String indent, DiagnosticsNode property) {
        if (property.getStyle() == DiagnosticsTreeStyle.flat) {
            return indent;
        }
        return indent + "  ";
    }

    public void handleLoggingEvent(@NotNull Event event) {
        if (event == null) {
            FlutterConsoleLogManager.$$$reportNull$$$0(5);
        }
        queue.add(() -> {
            try {
                this.processLoggingEvent(event);
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        });
    }

    private ConsoleViewContentType getContentTypeFor(DiagnosticLevel level) {
        switch (level) {
            case error: 
            case summary: {
                return ERROR_CONTENT_TYPE;
            }
            case hint: {
                return NORMAL_CONTENT_TYPE;
            }
        }
        return SUBTLE_CONTENT_TYPE;
    }

    @VisibleForTesting
    public void processLoggingEvent(@NotNull Event event) {
        String padding;
        LogRecord logRecord;
        if (event == null) {
            FlutterConsoleLogManager.$$$reportNull$$$0(6);
        }
        if ((logRecord = event.getLogRecord()) == null) {
            return;
        }
        VmService service = this.app.getVmService();
        if (service == null) {
            return;
        }
        IsolateRef isolateRef = event.getIsolate();
        InstanceRef message = logRecord.getMessage();
        @NotNull InstanceRef loggerName = logRecord.getLoggerName();
        String name = loggerName.getValueAsString().isEmpty() ? "log" : loggerName.getValueAsString();
        String prefix = "[" + name + "] ";
        String messageStr = this.getFullStringValue(service, isolateRef.getId(), message);
        this.console.print(prefix, SUBTLE_CONTENT_TYPE);
        this.console.print(messageStr + "\n", NORMAL_CONTENT_TYPE);
        final @NotNull InstanceRef error = logRecord.getError();
        @NotNull InstanceRef stackTrace = logRecord.getStackTrace();
        if (!error.isNull()) {
            padding = StringUtil.repeat((String)" ", (int)prefix.length());
            if (error.getKind() == InstanceKind.String) {
                String string = this.getFullStringValue(service, isolateRef.getId(), error);
                boolean isJson = false;
                try {
                    JsonElement json = JsonUtils.parseString(string);
                    isJson = true;
                    string = new GsonBuilder().setPrettyPrinting().create().toJson(json);
                    string = string.replaceAll("\n", "\n" + padding);
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
                this.console.print(padding + string + "\n", isJson ? ConsoleViewContentType.NORMAL_OUTPUT : ERROR_CONTENT_TYPE);
            } else {
                final CountDownLatch latch = new CountDownLatch(1);
                service.invoke(isolateRef.getId(), error.getId(), "toString", Collections.emptyList(), true, new VmServiceConsumers.InvokeConsumerWrapper(){

                    @Override
                    public void received(InstanceRef response) {
                        FlutterConsoleLogManager.this.console.print(padding + FlutterConsoleLogManager.this.stringValueFromStringRef(response) + "\n", ERROR_CONTENT_TYPE);
                        latch.countDown();
                    }

                    @Override
                    public void noGoodResult() {
                        FlutterConsoleLogManager.this.console.print(padding + error.getClassRef().getName() + " " + error.getId() + "\n", ERROR_CONTENT_TYPE);
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (!stackTrace.isNull()) {
            padding = StringUtil.repeat((String)" ", (int)prefix.length());
            String out = stackTrace.getValueAsString() == null ? "" : stackTrace.getValueAsString().trim();
            this.console.print(padding + out.replaceAll("\n", "\n" + padding) + "\n", ERROR_CONTENT_TYPE);
        }
    }

    private String stringValueFromStringRef(InstanceRef ref) {
        return ref.getValueAsStringIsTruncated() ? this.formatTruncatedString(ref) : ref.getValueAsString();
    }

    private String stringValueFromStringRef(Instance instance) {
        return instance.getValueAsStringIsTruncated() ? instance.getValueAsString() + "..." : instance.getValueAsString();
    }

    private String formatTruncatedString(InstanceRef ref) {
        return ref.getValueAsString() + "...";
    }

    private String getFullStringValue(@NotNull VmService service, String isolateId, final @Nullable InstanceRef ref) {
        if (service == null) {
            FlutterConsoleLogManager.$$$reportNull$$$0(7);
        }
        if (ref == null) {
            return null;
        }
        if (!ref.getValueAsStringIsTruncated()) {
            return ref.getValueAsString();
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final String[] result = new String[1];
        service.getObject(isolateId, ref.getId(), 0, ref.getLength(), new GetObjectConsumer(){

            @Override
            public void onError(RPCError error) {
                result[0] = FlutterConsoleLogManager.this.formatTruncatedString(ref);
                latch.countDown();
            }

            @Override
            public void received(Obj response) {
                result[0] = response instanceof Instance && ((Instance)response).getKind() == InstanceKind.String ? FlutterConsoleLogManager.this.stringValueFromStringRef((Instance)response) : FlutterConsoleLogManager.this.formatTruncatedString(ref);
                latch.countDown();
            }

            @Override
            public void received(Sentinel response) {
                result[0] = FlutterConsoleLogManager.this.formatTruncatedString(ref);
                latch.countDown();
            }
        });
        try {
            latch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
        return result[0];
    }

    static {
        queueLength = new AtomicInteger();
        emptyList = new ArrayList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticsNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorSummary";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        objectArray2[1] = "io/flutter/logging/FlutterConsoleLogManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleFlutterErrorEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processFlutterErrorEvent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showDeepLinkNotification";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleLoggingEvent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processLoggingEvent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getFullStringValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

